/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf;

import de.uniks.networkparser.DateTimeEntity;
import de.uniks.networkparser.ext.petaf.Message;
import de.uniks.networkparser.ext.petaf.SimpleTimerTask;
import de.uniks.networkparser.ext.petaf.Space;
import de.uniks.networkparser.ext.petaf.TaskExecutor;
import java.util.Timer;
import java.util.TimerTask;

public class TimerExecutor
extends Timer
implements TaskExecutor {
    private boolean isCancel;
    private Space space;
    private DateTimeEntity lastRun = new DateTimeEntity();

    @Override
    public TimerExecutor withSpace(Space space) {
        this.space = space;
        return this;
    }

    @Override
    public Space getSpace() {
        return this.space;
    }

    public TimerExecutor(String value) {
        super(value);
    }

    @Override
    public void cancel() {
        this.isCancel = true;
        super.cancel();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    public Object executeTask(Runnable task, int delay, int interval) {
        if (this.isCancel()) {
            return null;
        }
        SimpleTimerTask newTask = task instanceof SimpleTimerTask ? (SimpleTimerTask)task : new SimpleTimerTask(this.space).withTask(task);
        newTask.withDateTime(this.lastRun);
        if (interval > 0) {
            this.schedule((TimerTask)newTask, delay, (long)interval);
        } else {
            this.schedule((TimerTask)newTask, delay);
        }
        return null;
    }

    @Override
    public Object executeTask(Runnable task, int delay) {
        if (this.isCancel()) {
            return null;
        }
        SimpleTimerTask newTask = task instanceof SimpleTimerTask ? (SimpleTimerTask)task : new SimpleTimerTask(this.space).withTask(task);
        newTask.withDateTime(this.lastRun);
        this.schedule((TimerTask)newTask, delay);
        return null;
    }

    @Override
    public void shutdown() {
        this.isCancel = true;
        this.cancel();
    }

    @Override
    public DateTimeEntity getLastRun() {
        return this.lastRun;
    }

    @Override
    public boolean handleMsg(Message message) {
        if (this.space != null) {
            return this.space.handleMsg(message);
        }
        return false;
    }
}

