/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf;

import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.Space;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyFileSystem;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SimpleEventCondition;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SortedSet;

public class NodeBackup
implements Runnable {
    public static final String KEY = "Backup";
    private SimpleEventCondition task;
    private boolean runnable;
    protected long sendtime;
    private Space space;
    private SimpleEvent event;
    private SimpleList<NodeProxy> queries;

    public void enable() {
        this.runnable = true;
    }

    public NodeBackup with(NodeProxy ... nodeProxies) {
        if (nodeProxies == null) {
            return this;
        }
        if (this.queries == null) {
            this.queries = new SimpleList();
        }
        for (NodeProxy proxy : nodeProxies) {
            this.queries.add(proxy);
        }
        return this;
    }

    public boolean close() {
        this.runnable = false;
        return true;
    }

    public NodeBackup withSpace(Space space) {
        this.space = space;
        this.event = new SimpleEvent(this, KEY, null, space);
        return this;
    }

    @Override
    public void run() {
        if (this.task != null && this.runnable) {
            this.sendtime = System.currentTimeMillis();
            this.task.update(this.event);
            if (this.space != null) {
                SortedSet<NodeProxy> proxies = this.space.getNodeProxies(new ObjectCondition[0]);
                for (NodeProxy proxy : proxies) {
                    if (!(proxy instanceof NodeProxyFileSystem)) continue;
                    proxy.sending(null);
                }
            }
            if (this.queries != null) {
                for (NodeProxy proxy : this.queries) {
                    proxy.sending(null);
                }
            }
            this.runnable = false;
        }
    }

    public boolean isEnable() {
        return this.runnable;
    }

    public long getSendtime() {
        return this.sendtime;
    }

    public NodeBackup withTask(SimpleEventCondition task) {
        this.task = task;
        return this;
    }

    public Space getSpace() {
        return this.space;
    }
}

