/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx.controller;

import de.uniks.networkparser.ext.generic.GenericCreator;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.interfaces.SendableEntity;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;

public abstract class AbstractModelController
implements PropertyChangeListener {
    public <ST extends AbstractModelController> ST init(Object model, Object gui) {
        if (model != null && gui != null) {
            try {
                Method method = this.getClass().getMethod("initPropertyChange" + model.getClass().getSimpleName(), model.getClass(), ReflectionLoader.NODE);
                method.invoke((Object)this, model, gui);
            }
            catch (ReflectiveOperationException e) {
                this.initPropertyChange(model, gui);
            }
            catch (SecurityException e) {
                this.initPropertyChange(model, gui);
            }
            catch (IllegalArgumentException e) {
                this.initPropertyChange(model, gui);
            }
        }
        return (ST)this;
    }

    public abstract void initPropertyChange(Object var1, Object var2);

    public boolean addListener(Object item, String property) {
        return this.addListener(item, property, this);
    }

    public boolean addListener(Object item, String property, PropertyChangeListener listener) {
        if (item == null) {
            return false;
        }
        GenericCreator creator = new GenericCreator(item);
        if (property != null) {
            if (item instanceof SendableEntity) {
                ((SendableEntity)item).addPropertyChangeListener(property, listener);
                listener.propertyChange(new PropertyChangeEvent(item, property, null, creator.getValue(item, property)));
                return true;
            }
            if (item instanceof PropertyChangeSupport) {
                ((PropertyChangeSupport)item).addPropertyChangeListener(property, listener);
                listener.propertyChange(new PropertyChangeEvent(item, property, null, creator.getValue(item, property)));
                return true;
            }
            try {
                Method method = item.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                method.invoke(item, property, listener);
                listener.propertyChange(new PropertyChangeEvent(item, property, null, creator.getValue(item, property)));
                return true;
            }
            catch (ReflectiveOperationException method) {
                // empty catch block
            }
        }
        try {
            Method method = item.getClass().getMethod("getPropertyChangeSupport", new Class[0]);
            PropertyChangeSupport pc = (PropertyChangeSupport)method.invoke(item, new Object[0]);
            if (property == null) {
                pc.addPropertyChangeListener(listener);
                listener.propertyChange(new PropertyChangeEvent(item, property, null, null));
            } else {
                pc.addPropertyChangeListener(property, listener);
                listener.propertyChange(new PropertyChangeEvent(item, property, null, creator.getValue(item, property)));
            }
            return true;
        }
        catch (ReflectiveOperationException method) {
            try {
                Method method2 = item.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                method2.invoke(item, listener);
                listener.propertyChange(new PropertyChangeEvent(item, property, null, creator.getValue(item, property)));
                return true;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                return false;
            }
        }
    }
}

