/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.javafx.GUIEvent;
import de.uniks.networkparser.ext.javafx.JavaAdapter;
import de.uniks.networkparser.ext.javafx.MethodCallbackListener;
import de.uniks.networkparser.gui.EventTypes;
import de.uniks.networkparser.gui.JavaBridge;
import de.uniks.networkparser.gui.JavaViewAdapter;
import de.uniks.networkparser.gui.controls.Button;
import de.uniks.networkparser.gui.controls.Control;
import de.uniks.networkparser.gui.controls.Label;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.logic.ChainCondition;
import java.util.List;

public class JavaBridgeFX
extends JavaBridge {
    public JavaBridgeFX() {
        this(null);
    }

    public JavaBridgeFX(IdMap map) {
        super(map, new JavaAdapter(), CONTENT_TYPE_INCLUDE);
    }

    public JavaBridgeFX(IdMap map, JavaViewAdapter webView, String type) {
        super(map, webView, type);
    }

    @Override
    public void addListener(Control c, EventTypes type, String methodName, Object object) {
        this.addEventListener(c, type, new MethodCallbackListener(object, methodName));
    }

    public static void addChildren(Object element, int pos, Object ... childrenValues) {
        Object children = ReflectionLoader.calling(element, "getChildren", false, null, new Object[0]);
        if (children == null) {
            children = ReflectionLoader.call(element, "getItems", new Object[0]);
        }
        if (children != null && children instanceof List) {
            List childrenList = (List)children;
            for (Object item : childrenValues) {
                if (pos < 0) {
                    childrenList.add(item);
                    continue;
                }
                childrenList.add(pos++, item);
            }
        }
    }

    public static void removeChildren(Object element, Object ... childrenValues) {
        Object children = ReflectionLoader.calling(element, "getChildren", false, null, new Object[0]);
        if (children == null) {
            children = ReflectionLoader.call(element, "getItems", new Object[0]);
        }
        if (children != null && children instanceof List) {
            List childrenList = (List)children;
            for (Object item : childrenValues) {
                childrenList.remove(item);
            }
        }
    }

    public static void setStyle(Object element, boolean clear, String ... stylesValues) {
        Object styles = ReflectionLoader.call(element, "getStyleClass", new Object[0]);
        if (styles != null && styles instanceof List) {
            List styleList = (List)styles;
            if (clear) {
                styleList.clear();
            }
            for (String item : stylesValues) {
                styleList.add(item);
            }
        }
    }

    public static void removeStyle(Object element, String ... stylesValues) {
        Object styles = ReflectionLoader.call(element, "getStyleClass", new Object[0]);
        if (styles != null && styles instanceof List) {
            List styleList = (List)styles;
            for (String item : stylesValues) {
                styleList.remove(item);
            }
        }
    }

    public static void addListener(Object element, String method, Class<?> proxyClass, ObjectCondition condition) {
        GUIEvent event = new GUIEvent();
        event.withListener(condition);
        Object proxy = ReflectionLoader.createProxy(event, proxyClass);
        ReflectionLoader.call(element, method, proxyClass, proxy);
    }

    public static Object convert(Control item, boolean clearStyle) {
        if (item instanceof Button) {
            return JavaBridgeFX.convertButton((Button)item, clearStyle);
        }
        if (item instanceof Label) {
            return JavaBridgeFX.convertLabel((Label)item, clearStyle);
        }
        return null;
    }

    private static Object convertButton(Button button, boolean clearStyle) {
        String value = (String)button.getValue();
        Object javaFXBtn = ReflectionLoader.newInstance(ReflectionLoader.BUTTON, value);
        List<ObjectCondition> events = button.getEvents(EventTypes.CLICK);
        ChainCondition condition = new ChainCondition();
        condition.with(events);
        condition.withStaticEvent(button);
        GUIEvent javaFXEvent = new GUIEvent();
        javaFXEvent.withListener(condition);
        Object proxy = ReflectionLoader.createProxy(javaFXEvent, ReflectionLoader.EVENTHANDLER);
        ReflectionLoader.call(javaFXBtn, "setOnAction", ReflectionLoader.EVENTHANDLER, proxy);
        ReflectionLoader.call(javaFXBtn, "setFocusTraversable", Boolean.TYPE, false);
        JavaBridgeFX.setStyle(javaFXBtn, clearStyle, "window-button", "window-" + button.getActionType() + "-button");
        if (value == null) {
            Object stackPane = ReflectionLoader.newInstance(ReflectionLoader.STACKPANE, new Object[0]);
            JavaBridgeFX.setStyle(stackPane, true, "graphic");
            ReflectionLoader.call(javaFXBtn, "setGraphic", ReflectionLoader.NODE, stackPane);
            ReflectionLoader.call(javaFXBtn, "setMinSize", Double.TYPE, 17, Double.TYPE, 17);
            ReflectionLoader.call(javaFXBtn, "setPrefSize", Double.TYPE, 17, Double.TYPE, 17);
        }
        return javaFXBtn;
    }

    private static Object convertLabel(Label label, boolean clearStyle) {
        Object javaFXLabel;
        if ("spacer".equalsIgnoreCase(label.getType())) {
            javaFXLabel = ReflectionLoader.newInstance(ReflectionLoader.REGION, new Object[0]);
            Object prio = ReflectionLoader.getField("ALWAYS", ReflectionLoader.PRIORITY);
            ReflectionLoader.call(ReflectionLoader.HBOX, "setHgrow", ReflectionLoader.NODE, javaFXLabel, ReflectionLoader.PRIORITY, prio);
        } else if ("title".equalsIgnoreCase(label.getType())) {
            javaFXLabel = ReflectionLoader.newInstance(ReflectionLoader.LABEL, label.getValue());
            ReflectionLoader.call(javaFXLabel, "setMaxHeight", Double.TYPE, Double.MAX_VALUE);
            JavaBridgeFX.setStyle(javaFXLabel, false, "window-title");
        } else {
            javaFXLabel = ReflectionLoader.newInstance(ReflectionLoader.LABEL, label.getValue());
        }
        return javaFXLabel;
    }
}

