/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx;

import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.javafx.JsonObjectLazy;
import de.uniks.networkparser.gui.Event;
import de.uniks.networkparser.gui.EventTypes;
import de.uniks.networkparser.interfaces.ObjectCondition;

public class GUIEvent
extends Event {
    public static final int ESCAPE = 27;
    private ObjectCondition listerner;

    public GUIEvent withListener(ObjectCondition value) {
        this.listerner = value;
        return this;
    }

    public void handle(Object event) {
        if (this.listerner != null) {
            this.listerner.update(event);
        }
    }

    public void invalidated(Object event) {
        if (this.listerner != null) {
            this.listerner.update(event);
        }
    }

    public void actionPerformed(Object e) {
        if (this.listerner != null) {
            this.listerner.update(e);
        }
    }

    public void changed(Object observable, Object oldValue, Object newValue) {
        if (this.listerner != null) {
            this.listerner.update(new SimpleEvent(observable, "State", oldValue, newValue));
        }
    }

    private static Object getMember(Object obj, String value) {
        if (obj == null || !obj.getClass().getName().startsWith("javafx")) {
            return null;
        }
        return ReflectionLoader.call(obj, "getMember", String.class, value);
    }

    public boolean isSubEventName(String name) {
        if (name == null || this.event == null) {
            return false;
        }
        String subName = this.event.getClass().getName();
        return subName.equals(name);
    }

    public ObjectCondition match(Object other) {
        if (other == null) {
            return null;
        }
        if (other instanceof ObjectCondition) {
            return (ObjectCondition)other;
        }
        if (other instanceof GUIEvent) {
            GUIEvent otherEvt = (GUIEvent)other;
            if (this.eventType == EventTypes.KEYPRESS && otherEvt.getEventType() == EventTypes.KEYPRESS && this.getCode() == otherEvt.getCode()) {
                return otherEvt.getListener();
            }
        }
        return null;
    }

    public static GUIEvent create(Object obj) {
        GUIEvent event = new GUIEvent();
        if (obj == null) {
            return event;
        }
        String name = obj.getClass().getName();
        if ("javafx.scene.input.KeyEvent".equals(name)) {
            event.setValue("eventType", (Object)EventTypes.KEYPRESS);
            event.put("altKey", ReflectionLoader.call(obj, "isAltDown", new Object[0]));
            event.put("ctrlKey", ReflectionLoader.call(obj, "isControlDown", new Object[0]));
            event.put("shiftKey", ReflectionLoader.call(obj, "isShiftDown", new Object[0]));
            if (obj != null) {
                Object value = ReflectionLoader.callChain(obj, "getCode", "getCode");
                if (value != null) {
                    event.withCode((Integer)value);
                }
                event.setValue("currentTarget", ReflectionLoader.call(obj, "getTarget", new Object[0]));
                event.setValue("event", obj);
            }
            return event;
        }
        if ("javafx.stage.WindowEvent".equals(name)) {
            event.setValue("eventType", (Object)EventTypes.WINDOWEVENT);
            event.setValue("currentTarget", ReflectionLoader.call(obj, "getTarget", new Object[0]));
            String type = "" + ReflectionLoader.call(obj, "getEventType", new Object[0]);
            event.active = !"WINDOW_CLOSE_REQUEST".equals(type);
            event.setValue("event", obj);
            return event;
        }
        event.setValue("event", obj);
        if ("java.awt.event.ActionEvent".equals(name)) {
            event.setValue("eventType", (Object)EventTypes.CLICK);
            Long longValue = (Long)ReflectionLoader.call(obj, "getWhen", new Object[0]);
            event.setValue("timeStamp", (Object)longValue.intValue());
            event.setValue("currentTarget", ReflectionLoader.call(obj, "getSource", new Object[0]));
            event.setValue("id", "" + ReflectionLoader.callChain(obj, "getSource", "getLabel"));
            return event;
        }
        if (!name.startsWith("javafx")) {
            return event;
        }
        Object value = GUIEvent.getMember(obj, "timeStamp");
        if (value != null) {
            if (value instanceof Double) {
                event.timeStamp = ((Double)value).intValue();
            } else if (value instanceof Integer) {
                event.timeStamp = (Integer)value;
            }
        }
        if ((value = GUIEvent.getMember(obj, "id")) != null) {
            event.id = "" + value;
        }
        if ((value = GUIEvent.getMember(obj, "eventType")) != null) {
            String eventName = "" + value;
            event.eventType = EventTypes.valueOf(eventName.toUpperCase());
        }
        if ((value = GUIEvent.getMember(obj, "type")) != null) {
            event.put("type", "" + value);
        }
        if ((value = GUIEvent.getMember(obj, "currentTarget")) != null) {
            event.currentTarget = new JsonObjectLazy(value);
        }
        return event;
    }

    public ObjectCondition getListener() {
        return this.listerner;
    }

    public GUIEvent withCode(int value) {
        this.put("code", value);
        return this;
    }

    public int getCode() {
        Object object = this.get("code");
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }
}

