/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.io;

import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.X509TrustManager;

class ServerTrustManager
implements X509TrustManager {
    private static Pattern cnPattern = Pattern.compile("(?i)(cn=)([^,]*)");

    ServerTrustManager() {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String arg1) throws CertificateException {
    }

    public static List<String> getPeerIdentity(X509Certificate x509Certificate) {
        List<String> names = ServerTrustManager.getSubjectAlternativeNames(x509Certificate);
        if (names.isEmpty()) {
            String name = x509Certificate.getSubjectDN().getName();
            Matcher matcher = cnPattern.matcher(name);
            if (matcher.find()) {
                name = matcher.group(2);
            }
            names = new ArrayList<String>();
            names.add(name);
        }
        return names;
    }

    private static List<String> getSubjectAlternativeNames(X509Certificate certificate) {
        ArrayList<String> identities = new ArrayList<String>();
        try {
            Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
            if (altNames == null) {
                return Collections.emptyList();
            }
        }
        catch (CertificateParsingException e) {
            e.printStackTrace();
        }
        return identities;
    }
}

