/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.io;

import de.uniks.networkparser.buffer.ByteBuffer;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;

public class MQTTMessage {
    public static final byte MESSAGE_TYPE_CONNECT = 1;
    public static final byte MESSAGE_TYPE_CONNACK = 2;
    public static final byte MESSAGE_TYPE_PUBLISH = 3;
    public static final byte MESSAGE_TYPE_PUBACK = 4;
    public static final byte MESSAGE_TYPE_PUBREC = 5;
    public static final byte MESSAGE_TYPE_PUBREL = 6;
    public static final byte MESSAGE_TYPE_PUBCOMP = 7;
    public static final byte MESSAGE_TYPE_SUBSCRIBE = 8;
    public static final byte MESSAGE_TYPE_SUBACK = 9;
    public static final byte MESSAGE_TYPE_UNSUBSCRIBE = 10;
    public static final byte MESSAGE_TYPE_UNSUBACK = 11;
    public static final byte MESSAGE_TYPE_PINGREQ = 12;
    public static final byte MESSAGE_TYPE_PINGRESP = 13;
    public static final byte MESSAGE_TYPE_DISCONNECT = 14;
    private byte type;
    protected int msgId;
    protected boolean duplicate = false;
    public static final String KEY_CONNACK = "Con";
    public static final String KEY_DISCONNECT = "Disc";
    public static final String KEY_PING = "Ping";
    public static final String KEY_CONNECT = "Con";
    public static final int MQTT_VERSION_3_1_1 = 4;
    protected int code;
    protected boolean session;
    protected int[] data;
    protected String[] names;
    protected int keepAliveInterval;
    private int messageQOS = 1;
    private byte[] messagePayload;
    private boolean messageRetained = false;

    public MQTTMessage withType(byte type) {
        this.type = type;
        return this;
    }

    public ByteBuffer getHeader() {
        byte first = (byte)((this.getType() & 0xF) << 4 ^ this.getMessageInfo() & 0xF);
        byte[] varHeader = this.getVariableHeader();
        int remLen = varHeader.length + this.getPayload().length;
        ByteBuffer buffer = new ByteBuffer();
        buffer.insert(first, true);
        int numBytes = 0;
        do {
            byte digit = (byte)(remLen % 128);
            if ((remLen /= 128) > 0) {
                digit = (byte)(digit | 0x80);
            }
            buffer.insert(digit, false);
        } while (remLen > 0 && ++numBytes < 4);
        buffer.insert(varHeader, false);
        return buffer;
    }

    protected void encodeUTF8(ByteBuffer buffer, String stringToEncode) {
        try {
            byte[] encodedString = stringToEncode.getBytes("UTF-8");
            buffer.insert((short)encodedString.length, false);
            buffer.insert(encodedString, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte getType() {
        return this.type;
    }

    protected byte[] getVariableHeader() {
        if (this.type == 4) {
            ByteBuffer buffer = new ByteBuffer();
            short id = (short)this.msgId;
            buffer.insert(id, false);
            return buffer.array();
        }
        if (this.type == 8 || this.type == 10 || this.type == 3 || this.type == 1) {
            ByteBuffer buffer = new ByteBuffer();
            if (this.type == 3) {
                this.encodeUTF8(buffer, this.names[0]);
                if (this.messageQOS > 0) {
                    short id = (short)this.msgId;
                    buffer.insert(id, false);
                }
            } else if (this.type == 1) {
                if (this.code == 3) {
                    this.encodeUTF8(buffer, "MQIsdp");
                } else if (this.code == 4) {
                    this.encodeUTF8(buffer, "MQTT");
                }
                buffer.insert((byte)this.code, false);
                byte connectFlags = 0;
                if (this.session) {
                    connectFlags = (byte)(connectFlags | 2);
                }
                if (this.names[1] != null) {
                    connectFlags = (byte)(connectFlags | 0x80);
                    if (this.names[2] != null) {
                        connectFlags = (byte)(connectFlags | 0x40);
                    }
                }
                buffer.insert(connectFlags, false);
                short id = (short)this.keepAliveInterval;
                buffer.insert(id, false);
            } else {
                short id = (short)this.msgId;
                buffer.insert(id, false);
            }
            return buffer.array();
        }
        return new byte[0];
    }

    public byte[] getPayload() {
        if (this.type == 8 || this.type == 10 || this.type == 1) {
            int i;
            ByteBuffer buffer = new ByteBuffer();
            if (this.type == 8) {
                for (i = 0; i < this.names.length; ++i) {
                    this.encodeUTF8(buffer, this.names[i]);
                    buffer.addBytes((byte)this.data[i], 1, false);
                }
            }
            if (this.type == 10) {
                for (i = 0; i < this.names.length; ++i) {
                    this.encodeUTF8(buffer, this.names[i]);
                }
            }
            if (this.type == 1) {
                this.encodeUTF8(buffer, this.names[0]);
                if (this.names[1] != null) {
                    this.encodeUTF8(buffer, this.names[1]);
                    if (this.names[2] != null) {
                        this.encodeUTF8(buffer, this.names[2]);
                    }
                }
            }
            return buffer.array();
        }
        if (this.type == 3) {
            return this.messagePayload;
        }
        return new byte[0];
    }

    protected byte getMessageInfo() {
        if (this.type == 8 || this.type == 10) {
            return (byte)(2 | (this.duplicate ? 8 : 0));
        }
        if (this.type == 3) {
            byte info = (byte)(this.messageQOS << 1);
            if (this.messageRetained) {
                info = (byte)(info | 1);
            }
            if (this.duplicate) {
                info = (byte)(info | 8);
            }
            return info;
        }
        return 0;
    }

    public static MQTTMessage create(byte type) {
        return MQTTMessage.create(type, (byte)0, null);
    }

    protected String decodeUTF8(ByteBuffer input) {
        short encodedLength = input.getShort();
        byte[] encodedString = input.getBytes(new Object[]{new byte[encodedLength]});
        return new String(encodedString);
    }

    public MQTTMessage withNames(String ... names) {
        this.names = names;
        this.code = names.length;
        return this;
    }

    public static MQTTMessage create(byte type, byte info, byte[] variableHeader) {
        ByteBuffer buffer;
        MQTTMessage message = new MQTTMessage().withType(type);
        if (type == 14) {
            return message;
        }
        if (type == 3) {
            message.messageQOS = info >> 1 & 3;
            if ((info & 1) == 1) {
                message.messageRetained = true;
            }
            if ((info & 8) == 8) {
                message.duplicate = true;
            }
            if (variableHeader == null) {
                return message;
            }
            buffer = new ByteBuffer().with(variableHeader);
            buffer.flip(true);
            message.names = new String[]{message.decodeUTF8(buffer)};
            if (message.messageQOS > 0) {
                message.msgId = buffer.getShort();
            }
            message.messagePayload = buffer.getBytes(new Object[]{new byte[variableHeader.length - buffer.position() - 1]});
        }
        if (variableHeader == null) {
            return message;
        }
        buffer = new ByteBuffer().with(variableHeader);
        if (type == 1) {
            String[] values = new String[3];
            message.names = values;
            message.decodeUTF8(buffer);
            buffer.getByte();
            buffer.getByte();
            message.keepAliveInterval = buffer.getShort();
            values[0] = message.decodeUTF8(buffer);
        }
        if (type == 2) {
            message.session = (buffer.getByte() & 1) == 1;
            message.code = buffer.getByte();
        }
        if (type == 4) {
            message.msgId = buffer.getShort();
        }
        if (type == 9) {
            message.msgId = buffer.getShort();
            int index = 0;
            message.data = new int[variableHeader.length - 2];
            for (int i = 0; i < message.data.length; ++i) {
                message.data[index] = buffer.getByte();
            }
        }
        if (type == 8) {
            message.msgId = buffer.getShort();
            message.code = 0;
            message.names = new String[10];
            message.data = new int[10];
            boolean end = false;
            while (!end) {
                try {
                    message.names[message.code] = message.decodeUTF8(buffer);
                    message.data[message.code++] = buffer.getByte();
                }
                catch (Exception e) {
                    end = true;
                }
            }
        }
        if (type == 10) {
            message.msgId = buffer.getShort();
            message.code = 0;
            message.names = new String[10];
            boolean end = false;
            while (!end) {
                try {
                    message.names[message.code] = message.decodeUTF8(buffer);
                }
                catch (Exception e) {
                    end = true;
                }
            }
        }
        return message;
    }

    protected static int readMBI(DataInputStream in) throws IOException {
        byte digit;
        int msgLength = 0;
        int multiplier = 1;
        do {
            digit = in.readByte();
            msgLength += (digit & 0x7F) * multiplier;
            multiplier *= 128;
        } while ((digit & 0x80) != 0);
        return msgLength;
    }

    protected static void encodeMBI(ByteBuffer buffer, long number) {
        int numBytes = 0;
        long no = number;
        do {
            byte digit = (byte)(no % 128L);
            if ((no /= 128L) > 0L) {
                digit = (byte)(digit | 0x80);
            }
            buffer.insert(digit, false);
        } while (no > 0L && ++numBytes < 4);
    }

    public static MQTTMessage readFrom(DataInputStream in) {
        MQTTMessage message;
        block6: {
            message = null;
            try {
                byte first = in.readByte();
                byte type = (byte)(first >>> 4 & 0xF);
                if (type < 1 || type > 14) {
                    return null;
                }
                int remLen = MQTTMessage.readMBI(in);
                ByteBuffer buffer = new ByteBuffer();
                buffer.insert(first, false);
                MQTTMessage.encodeMBI(buffer, remLen);
                if (remLen < 0) break block6;
                byte[] packet = new byte[remLen];
                try {
                    in.read(packet, 0, remLen);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
                remLen = -1;
                byte info = first = (byte)(first & 0xF);
                if (type == 2 || type == 14 || type == 4 || type == 9 || type == 12 || type == 8 || type == 10 || type == 1 || type == 3) {
                    return MQTTMessage.create(type, info, packet);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return message;
    }

    public MQTTMessage withCode(int value) {
        this.code = value;
        return this;
    }

    public MQTTMessage withQOS(int ... qos) {
        this.data = qos;
        return this;
    }

    public MQTTMessage withKeepAliveInterval(int value) {
        this.keepAliveInterval = value;
        return this;
    }

    public MQTTMessage withSession(boolean value) {
        this.session = value;
        return this;
    }

    public static MQTTMessage createChannelOpen(String topic) {
        MQTTMessage msg = new MQTTMessage().withType((byte)8);
        msg.withNames(topic).withQOS(1);
        return msg;
    }

    public MQTTMessage createMessage(String content) {
        this.messagePayload = content.getBytes();
        this.messageQOS = 1;
        return this;
    }

    public boolean isMessageIdRequired() {
        if (this.type == 1) {
            return false;
        }
        if (this.type == 2) {
            return false;
        }
        if (this.type == 14) {
            return false;
        }
        return this.type != 12;
    }

    public int getMessageId() {
        return this.msgId;
    }

    public int getMessageQOS() {
        return this.messageQOS;
    }

    public MQTTMessage withMessageId(int value) {
        this.msgId = value;
        return this;
    }

    public String getText() {
        if (this.type == 3) {
            return new String(this.messagePayload);
        }
        return null;
    }

    public String[] getNames() {
        return this.names;
    }
}

