/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.io;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.xml.XMLEntity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class FileBuffer
extends Buffer {
    public static final int BUFFER = 4096;
    private BufferedReader reader;
    private File file;
    private CharacterBuffer lookAHead = new CharacterBuffer();
    private int length;
    private char currentChar;
    public static byte NONE = 0;
    public static byte APPEND = 1;
    public static byte OVERRIDE = (byte)2;

    public FileBuffer withFile(String fileName) {
        if (fileName != null) {
            this.withFile(new File(fileName));
        }
        return this;
    }

    public FileBuffer withFile(File file, int cache) {
        this.file = file;
        this.length = (int)this.file.length();
        try {
            FileInputStream fis = new FileInputStream(this.file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.forName("utf-8"));
            this.reader = new BufferedReader(isr, cache);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.position = 0;
        return this;
    }

    public FileBuffer withFile(File file) {
        return this.withFile(file, 0x100000);
    }

    @Override
    public int length() {
        return this.length;
    }

    public boolean exists() {
        if (this.file == null) {
            return false;
        }
        return this.file.exists();
    }

    @Override
    public char getChar() {
        char value = '\u0000';
        if (this.lookAHead.length() > 0) {
            value = this.lookAHead.charAt(0);
            if (this.lookAHead.length() == 1) {
                this.lookAHead.clear();
            } else {
                this.lookAHead.trimStart(1);
            }
            ++this.position;
            return value;
        }
        try {
            int charInt = this.reader.read();
            if (charInt < 0) {
                charInt = 0;
            }
            this.currentChar = value = (char)charInt;
            ++this.position;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    public String toString() {
        char[] values = new char[this.remaining()];
        int len = this.lookAHead.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                values[i] = this.lookAHead.charAt(i);
            }
        }
        try {
            if (values.length == 0) {
                return "";
            }
            int max = values.length - len;
            int read = this.reader.read(values, len, max);
            if (read < max) {
                this.length = max - read;
            }
            this.lookAHead.clear();
            this.lookAHead.with(values, 0, len + read);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(values);
    }

    @Override
    public FileBuffer withLookAHead(CharSequence lookahead) {
        this.lookAHead.set(lookahead);
        this.currentChar = lookahead.charAt(0);
        this.lookAHead.trimStart(1);
        this.position -= this.lookAHead.length();
        return this;
    }

    @Override
    public FileBuffer withLookAHead(char current) {
        this.lookAHead.set(this.currentChar);
        this.currentChar = current;
        --this.position;
        return this;
    }

    @Override
    public char nextClean(boolean currentValid) {
        char current;
        this.currentChar = current = super.nextClean(currentValid);
        return current;
    }

    @Override
    public char getCurrentChar() {
        if (this.currentChar != '\u0000') {
            return this.currentChar;
        }
        char value = this.getChar();
        return value;
    }

    @Override
    public byte getByte() {
        return (byte)this.getChar();
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final boolean writeFile(String fileName, CharSequence data, byte flag) {
        if (data != null) {
            return FileBuffer.writeFile(fileName, data.toString().getBytes(), flag);
        }
        return false;
    }

    public static final boolean writeFile(String fileName, byte[] data, byte flag) {
        if (fileName == null || fileName.length() < 1) {
            return false;
        }
        FileBuffer buffer = new FileBuffer();
        buffer.withFile(fileName);
        if (buffer.exists() ? flag == NONE : !buffer.createFile()) {
            return false;
        }
        return buffer.write(flag, data);
    }

    public static final boolean writeFile(String fileName, CharSequence data) {
        return FileBuffer.writeFile(fileName, data, OVERRIDE);
    }

    public static final boolean writeFile(String fileName, byte[] data) {
        return FileBuffer.writeFile(fileName, data, OVERRIDE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CharacterBuffer readResource(String file) {
        InputStream is = IdMap.class.getResourceAsStream(file);
        CharacterBuffer sb = new CharacterBuffer();
        if (is != null) {
            byte[] buffer = new byte[4096];
            try {
                int read;
                do {
                    if ((read = is.read(buffer)) <= 0) continue;
                    sb.with(new String(buffer, 0, read, "utf-8"));
                } while (read >= 0);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb;
    }

    public static final CharacterBuffer readFile(String file) {
        return FileBuffer.readFile(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CharacterBuffer readFile(File file) {
        CharacterBuffer sb = new CharacterBuffer();
        if (file.exists()) {
            byte[] buffer = new byte[4096];
            FileInputStream is = null;
            try {
                int read;
                is = new FileInputStream(file);
                do {
                    if ((read = is.read(buffer, 0, buffer.length)) <= 0) continue;
                    sb.with(new String(buffer, 0, read, "utf-8"));
                } while (read >= 0);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ByteBuffer readBinaryFile(String file) {
        File content = new File(file);
        ByteBuffer sb = new ByteBuffer();
        if (content.exists()) {
            byte[] buffer = new byte[4096];
            FileInputStream is = null;
            try {
                int read;
                is = new FileInputStream(content);
                do {
                    if ((read = is.read(buffer, 0, buffer.length)) <= 0) continue;
                    sb.addBytes(buffer, read, false);
                } while (read >= 0);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb;
    }

    public static BaseItem readBaseFile(String configFile) {
        return FileBuffer.readBaseFile(configFile, null);
    }

    public static BaseItem readBaseFile(String configFile, BaseItem container) {
        CharacterBuffer buffer = FileBuffer.readFile(configFile);
        if (buffer != null && buffer.length() > 0) {
            if (buffer.charAt(0) == '{') {
                JsonObject result = container instanceof JsonObject ? (JsonObject)container : new JsonObject();
                result.withValue(buffer);
                if (buffer.isEnd()) {
                    return result;
                }
                JsonArray array = new JsonArray();
                array.add(result);
                while (!buffer.isEndCharacter()) {
                    result = new JsonObject();
                    result.withValue(buffer);
                    array.add(result);
                }
                return array;
            }
            if (buffer.charAt(0) == '[') {
                JsonArray result = container instanceof JsonArray ? (JsonArray)container : new JsonArray();
                return result.withValue(buffer);
            }
            if (buffer.charAt(0) == '<') {
                XMLEntity result = container instanceof XMLEntity ? (XMLEntity)container : new XMLEntity();
                return result.withValue(buffer);
            }
        }
        return container;
    }

    public static final boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public boolean createFile() {
        return FileBuffer.createFile(this.file);
    }

    public static boolean createFile(File file) {
        if (file == null) {
            return false;
        }
        File parentFile = file.getParentFile();
        if (parentFile == null || parentFile.exists()) {
            return true;
        }
        if (!parentFile.mkdirs()) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean write(byte flag, CharSequence data) {
        if (data != null) {
            return this.write(flag, data.toString().getBytes());
        }
        return false;
    }

    public boolean write(byte flag, byte ... data) {
        if (this.file == null) {
            return false;
        }
        try {
            boolean append = false;
            if (flag == APPEND) {
                append = true;
            }
            FileOutputStream os = new FileOutputStream(this.file, append);
            os.write(data);
            os.flush();
            os.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean println(CharSequence string) {
        this.write(APPEND, string);
        return this.newline();
    }

    public boolean newline() {
        return this.write(APPEND, "\r\n");
    }
}

