/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.generic;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.Tokener;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.ext.generic.GenericCreator;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.json.JsonTokener;
import de.uniks.networkparser.xml.XMLTokener;

public class SimpleParser {
    private IdMap map;
    private Tokener tokener;
    private char endTag;

    public Tokener getTokener() {
        if (this.tokener == null) {
            this.tokener = new JsonTokener();
        }
        return this.tokener;
    }

    public IdMap getMap() {
        if (this.map == null) {
            this.map = new IdMap();
        }
        return this.map;
    }

    public <T> T decode(Object json) {
        return this.decode(json, null);
    }

    public <T> T decode(Object json, Class<T> classOfT) {
        JsonObject jsonObject = null;
        if (json instanceof String) {
            jsonObject = new JsonObject().withValue((String)json);
        } else if (json instanceof JsonObject) {
            jsonObject = (JsonObject)json;
        }
        if (jsonObject == null) {
            return null;
        }
        String className = jsonObject.getString("class");
        if (className == null || className.length() < 1) {
            if (classOfT == null) {
                return null;
            }
            className = classOfT.getName();
            if (!jsonObject.has("prop")) {
                JsonObject obj = new JsonObject();
                obj.put("prop", jsonObject);
                jsonObject = obj;
            }
            jsonObject.put("class", className);
        }
        IdMap map = this.getMap();
        GenericCreator.create(map, className);
        Object result = map.decode(jsonObject);
        if (classOfT == null) {
            try {
                Class<?> targetClass = Class.forName(className);
                if (targetClass == null) {
                    return null;
                }
                return (T)targetClass.cast(result);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return classOfT.cast(result);
    }

    public JsonObject encode(Object src) {
        if (src == null) {
            return new JsonObject();
        }
        IdMap map = this.getMap();
        GenericCreator.create(map, src.getClass());
        return map.toJsonObject(src);
    }

    public static <T> T fromJson(Object json) {
        return new SimpleParser().decode(json);
    }

    public static <T> T fromFile(String file) {
        BaseItem modelJson = FileBuffer.readBaseFile(file);
        return new SimpleParser().decode(modelJson);
    }

    public static <T> T fromJson(Object json, Class<T> classOfT) {
        return new SimpleParser().decode(json, classOfT);
    }

    public static JsonObject toJson(Object src) {
        return new SimpleParser().encode(src);
    }

    public <T> T decodeModel(Buffer buffer) {
        return SimpleParser.decodeModel(buffer, this.map, this.getTokener(), this.endTag);
    }

    public static <T> T decodeModel(Buffer buffer, IdMap map) {
        char firstChar = buffer.nextClean(true);
        Tokener tokener = null;
        char endTag = '\u0000';
        if (firstChar == '[') {
            tokener = new JsonTokener();
            endTag = ']';
        } else if (firstChar == '{') {
            tokener = new JsonTokener();
            endTag = '}';
        } else if (firstChar == '<') {
            tokener = new XMLTokener();
            endTag = '>';
        }
        if (tokener == null) {
            return null;
        }
        buffer.nextClean(false);
        return SimpleParser.decodeModel(buffer, map, tokener, endTag);
    }

    private static char getEndTag(char startTag) {
        if (startTag == '[') {
            return ']';
        }
        if (startTag == '{') {
            return '}';
        }
        if (startTag == '<') {
            return '>';
        }
        return '\u0000';
    }

    public static <T> T decodeModel(Buffer buffer, IdMap map, Tokener tokener, char endTag) {
        Object result = SimpleParser.decodingModel(buffer, map, tokener, endTag);
        try {
            Class<?> targetClass = result.getClass();
            return (T)targetClass.cast(result);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object decodingModel(Buffer buffer, IdMap map, Tokener tokener, char endTag) {
        String className = null;
        tokener.withBuffer(buffer);
        String key = tokener.nextString().toString();
        Object result = null;
        if (key != null && "class".equals(key)) {
            tokener.getChar();
            className = tokener.nextString().toString();
            SendableEntityCreator creator = map.getCreator(className, true);
            if (creator == null) {
                return null;
            }
            key = tokener.nextString().toString();
            String id = null;
            if ("id".equals(key)) {
                tokener.getChar();
                id = tokener.nextString().toString();
                result = map.getObject(id);
                if (result != null) {
                    return result;
                }
            }
            result = creator.getSendableInstance(false);
            if (id != null) {
                map.put(id, result, false);
            }
            char currentChar = tokener.getCurrentChar();
            while (currentChar != endTag && !tokener.isEnd() && (key = tokener.nextString().toString()).length() >= 1) {
                if ("prop".equals(key)) {
                    char propStartTag = currentChar = tokener.getChar();
                    char propEndTag = SimpleParser.getEndTag(currentChar);
                    while (currentChar != propEndTag && !tokener.isEnd() && (key = tokener.nextString().toString()).length() >= 1) {
                        Object subElement;
                        tokener.getChar();
                        if (tokener.getCurrentChar() == propStartTag) {
                            subElement = SimpleParser.decodingModel(buffer, map, tokener, propEndTag);
                            creator.setValue(result, key, subElement, "new");
                            continue;
                        }
                        if (tokener.getCurrentChar() == '[') {
                            do {
                                subElement = SimpleParser.decodingModel(buffer, map, tokener, propEndTag);
                                creator.setValue(result, key, subElement, "new");
                            } while ((currentChar = tokener.getCurrentChar()) != ']' && !tokener.isEnd());
                            continue;
                        }
                        String value = tokener.nextString().toString();
                        creator.setValue(result, key, value, "new");
                        currentChar = tokener.getCurrentChar();
                    }
                    continue;
                }
                tokener.nextString().toString();
            }
        } else {
            return key;
        }
        return result;
    }
}

