/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext;

import de.uniks.networkparser.DateTimeEntity;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.GraphConverter;
import de.uniks.networkparser.ext.ClassModel;
import de.uniks.networkparser.ext.JSEditor;
import de.uniks.networkparser.ext.generic.ReflectionBlackBoxTester;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.git.GitRevision;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.ext.javafx.GUIEvent;
import de.uniks.networkparser.ext.javafx.JavaAdapter;
import de.uniks.networkparser.ext.javafx.JavaBridgeFX;
import de.uniks.networkparser.ext.javafx.SimpleController;
import de.uniks.networkparser.ext.javafx.dialog.DialogBox;
import de.uniks.networkparser.ext.petaf.Message;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyTCP;
import de.uniks.networkparser.gui.EventTypes;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SimpleEventCondition;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.xml.HTMLEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;

public class DiagramEditor
extends JavaAdapter
implements ObjectCondition {
    private static final String FILE404 = "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\r\n<html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL was not found on this server.</p></body></html>";
    private static final String METHOD_GENERATE = "generating";
    private SimpleController controller;
    private Object logic;
    private SimpleEventCondition listener;
    private JavaBridgeFX bridge;
    private String file;
    private final int WIDTH = 900;
    private final int HEIGHT = 600;
    private boolean autoClose = true;
    private JSEditor jsEditor;

    public static boolean convertToPNG(HTMLEntity entity, String file, int ... dimension) {
        return DiagramEditor.converting(entity, file, true, true, dimension);
    }

    public static boolean convertToPNG(String url, String file, int ... dimension) {
        return DiagramEditor.converting(url, file, true, true, dimension);
    }

    public static boolean convertToPNG(File localFile, String file, int ... dimension) {
        return DiagramEditor.converting(localFile, file, true, true, dimension);
    }

    public static boolean converting(final Object entity, final String file, final boolean wait, final boolean autoClose, int ... dimension) {
        int height;
        int width;
        if (dimension != null && dimension.length > 1) {
            width = dimension[0];
            height = dimension[1];
        } else {
            width = -1;
            height = -1;
        }
        Class<?> launcherClass = ReflectionLoader.getClass("com.sun.javafx.application.LauncherImpl");
        if (launcherClass == null) {
            return false;
        }
        ReflectionLoader.call(launcherClass, "startToolkit", new Object[0]);
        if (entity != null && file != null) {
            ReflectionLoader.call(ReflectionLoader.PLATFORM, "setImplicitExit", Boolean.TYPE, false);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object stage = ReflectionLoader.newInstance(ReflectionLoader.STAGE, new Object[0]);
                DiagramEditor editor = new DiagramEditor();
                editor.type = "EDITOR";
                if (file != null) {
                    editor.file = file;
                    editor.type = "CONTENT";
                    editor.autoClose = autoClose;
                }
                editor.creating(stage, entity, width, height);
                editor.withIcon(IdMap.class.getResource("np.png").toString());
                editor.show(wait);
            }
        };
        if (wait) {
            JavaAdapter.executeAndWait(runnable);
        } else {
            JavaAdapter.execute(runnable);
        }
        return true;
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            if ("GIT".equalsIgnoreCase(args[0])) {
                GitRevision revision = new GitRevision();
                try {
                    int commit = -1;
                    if (args.length > 1) {
                        try {
                            commit = Integer.valueOf(args[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    System.out.println(revision.execute(commit));
                }
                catch (Exception commit) {
                    // empty catch block
                }
                return;
            }
            if (args[0] != null && args[0].toLowerCase().startsWith("test=")) {
                ReflectionBlackBoxTester.mainTester(args);
                return;
            }
        }
        if (!DiagramEditor.converting(null, null, false, true, new int[0])) {
            NodeProxyTCP server = NodeProxyTCP.createServer(8080);
            server.withListener(new DiagramEditor());
            if (server.start()) {
                Object desktop;
                System.out.println("LISTEN ON: " + server.getKey());
                if (ReflectionLoader.DESKTOP != null && (desktop = ReflectionLoader.call(ReflectionLoader.DESKTOP, "getDesktop", new Object[0])) != null) {
                    try {
                        ReflectionLoader.call(desktop, "browse", URI.class, new URI("http://" + server.getKey()));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public boolean executeWebServer(Message msg) {
        String request = msg.getMessage().toString();
        if (request.startsWith("GET")) {
            CharacterBuffer path = new CharacterBuffer();
            for (int i = 4; i < request.length() && request.charAt(i) != ' '; ++i) {
                path.with(request.charAt(i));
            }
            if (path.equals("/")) {
                HTMLEntity html = new HTMLEntity();
                html.createScript("classEditor = new ClassEditor(\"board\");", html.getBody());
                html.withHeader("diagram.js");
                html.withHeader("jspdf.min.js");
                html.withHeader("diagramstyle.css");
                String response = html.toString(2);
                this.writeHTTPResponse(msg, response, false);
            } else if (path.equalsIgnoreCase("/diagram.js")) {
                this.writeHTTPResponse(msg, FileBuffer.readResource("graph/diagram.js").toString(), false);
            } else if (path.equalsIgnoreCase("/diagramstyle.css")) {
                this.writeHTTPResponse(msg, FileBuffer.readResource("graph/diagramstyle.css").toString(), false);
            } else if (path.equalsIgnoreCase("/jspdf.min.js")) {
                this.writeHTTPResponse(msg, FileBuffer.readResource("graph/jspdf.min.js").toString(), false);
            } else {
                this.writeHTTPResponse(msg, FILE404, true);
            }
        }
        return true;
    }

    private void writeHTTPResponse(Message message, String response, boolean error) {
        if (error) {
            message.write("HTTP/1.1 404 Not Found\n");
        } else {
            message.write("HTTP/1.1 200 OK\n");
        }
        message.write("Date: " + new DateTimeEntity().toGMTString() + "\n");
        message.write("Server: Java\n");
        message.write("Last-Modified: " + new DateTimeEntity().toGMTString() + "\n");
        message.write("Content-Length: " + response.length() + "\n");
        message.write("Connection: Closed\n");
        message.write("Content-Type: text/html\n\n");
        message.write(response);
        Socket session = (Socket)message.getSession();
        try {
            session.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean update(Object value) {
        GUIEvent evt;
        EventTypes evtName;
        SimpleEvent evt2;
        if (value == null) {
            return false;
        }
        if (value instanceof Message) {
            return this.executeWebServer((Message)value);
        }
        if (value instanceof SimpleEvent && "javafx.concurrent.Worker$State".equalsIgnoreCase((evt2 = (SimpleEvent)value).getNewValue().getClass().getName())) {
            if (evt2.getNewValue().toString().equals("SUCCEEDED")) {
                Object win = super.executeScript("window", false);
                ReflectionLoader.call(win, "setMember", String.class, "java", Object.class, this);
                this.changed(evt2);
                super.executeScript("window['editor'] = new ClassEditor(\"board\");", false);
            }
            return true;
        }
        String name = (String)ReflectionLoader.callChain(value, "getEventType", "getName");
        if ("Drag_Over".equalsIgnoreCase(name)) {
            return this.onDragOver(value);
        }
        if ("Drag_Dropped".equalsIgnoreCase(name)) {
            return this.onDragDropped(value);
        }
        if ("Error".equalsIgnoreCase(name)) {
            return this.onError(value);
        }
        if ("Drag_Exited".equalsIgnoreCase(name)) {
            return this.onDragExited(value);
        }
        if (value instanceof GUIEvent && EventTypes.KEYPRESS == (evtName = (evt = (GUIEvent)value).getEventType()) && evt.getCode() == 123) {
            this.enableDebug();
        }
        return false;
    }

    public JSEditor getJSEditor() {
        if (this.jsEditor == null) {
            Object JSwin = super.executeScript("window", false);
            Object result = ReflectionLoader.call(JSwin, "getMember", String.class, "editor");
            this.jsEditor = new JSEditor(result);
        }
        return this.jsEditor;
    }

    public void exit() {
        ReflectionLoader.call(ReflectionLoader.PLATFORM, "exit", new Object[0]);
    }

    public boolean save(Object value) {
        JsonObject model = value instanceof JsonObject ? (JsonObject)value : new JsonObject().withValue((String)value);
        Object name = model.getString("package");
        if (name == null || ((String)name).length() < 1) {
            name = "model";
            if (model.size() < 1) {
                return false;
            }
        }
        DateTimeEntity entity = new DateTimeEntity();
        name = (String)name + "_" + entity.toString("yyyyMMdd_HHmmss") + ".json";
        return FileBuffer.writeFile((String)name, model.toString());
    }

    public void log(String value) {
        this.owner.logScript(value, 0, this, null);
    }

    public String generate(String value) {
        try {
            Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    DiagramEditor.this.saveException(e);
                }
            });
            this.generating(new JsonObject().withValue(value));
        }
        catch (Exception e) {
            this.saveException(e);
        }
        return "";
    }

    public boolean generating(JsonObject model) {
        Object result;
        if (this.listener != null) {
            SimpleEvent event = new SimpleEvent(model, METHOD_GENERATE, null, null);
            event.with(model);
            if (this.update(event)) {
                return true;
            }
        }
        if (this.logic != null && (result = ReflectionLoader.call(this.logic, METHOD_GENERATE, JsonObject.class, model)) instanceof Boolean) {
            return (Boolean)result;
        }
        GraphConverter converter = new GraphConverter();
        ClassModel modelGen = converter.convertFromJson(model);
        if (modelGen == null) {
            System.err.println("no Nodes");
            System.out.println("no Nodes");
            return false;
        }
        modelGen.generate("src/main/java");
        return true;
    }

    protected boolean onDragOver(Object event) {
        List<File> files = this.getFiles(event);
        if (files != null) {
            Object mode;
            boolean error = true;
            for (File file : files) {
                String name = file.getName().toLowerCase();
                if (name.indexOf("json", name.length() - 4) < 0) continue;
                error = false;
            }
            if (!error) {
                mode = ReflectionLoader.getField("COPY", ReflectionLoader.TRANSFERMODE);
                ReflectionLoader.call(event, "acceptTransferModes", ReflectionLoader.TRANSFERMODE, mode);
                this.getJSEditor().setBoardStyle("OK");
            } else {
                mode = ReflectionLoader.getField("NONE", ReflectionLoader.TRANSFERMODE);
                ReflectionLoader.call(event, "acceptTransferModes", ReflectionLoader.TRANSFERMODE, mode);
                this.getJSEditor().setBoardStyle("Error");
            }
        }
        ReflectionLoader.call(event, "consume", new Object[0]);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onDragDropped(Object event) {
        block14: {
            Iterator<File> iterator;
            List<File> files = this.getFiles(event);
            if (files == null || !(iterator = files.iterator()).hasNext()) break block14;
            File file = iterator.next();
            StringBuilder sb = new StringBuilder();
            byte[] buf = new byte[1024];
            FileInputStream is = null;
            try {
                int read;
                is = new FileInputStream(file);
                do {
                    if ((read = is.read(buf, 0, buf.length)) <= 0) continue;
                    sb.append(new String(buf, 0, read, "UTF-8"));
                } while (read >= 0);
            }
            catch (IOException iOException) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.getJSEditor().importModel(sb.toString());
        }
        return true;
    }

    protected boolean onDragExited(Object event) {
        this.getJSEditor().setBoardStyle("dragleave");
        return true;
    }

    protected void saveException(Object value) {
    }

    protected boolean onError(Object event) {
        System.err.println(ReflectionLoader.call(event, "getMessage", new Object[0]));
        return true;
    }

    protected List<File> getFiles(Object event) {
        Object db = ReflectionLoader.call(event, "getDragboard", new Object[0]);
        if (((Boolean)ReflectionLoader.call(db, "hasFiles", new Object[0])).booleanValue()) {
            List files = (List)ReflectionLoader.call(db, "getFiles", new Object[0]);
            return files;
        }
        return null;
    }

    @Override
    public boolean load(Object item) {
        boolean result = super.load(item);
        if (result) {
            return result;
        }
        HTMLEntity html = new HTMLEntity();
        boolean loadFile = false;
        if ("EDITOR".equalsIgnoreCase(this.type)) {
            loadFile = true;
            html.withScript(FileBuffer.readResource("graph/diagram.js").toString(), html.getHeader());
            html.withHeader("dagre.min.js");
            html.withHeader("jspdf.min.js");
            html.withHeader("diagramstyle.css");
            FileBuffer.writeFile("dagre.min.js", FileBuffer.readResource("graph/dagre.min.js"), FileBuffer.NONE);
            FileBuffer.writeFile("diagram.js", FileBuffer.readResource("graph/diagram.js"), FileBuffer.NONE);
            FileBuffer.writeFile("jspdf.min.js", FileBuffer.readResource("graph/jspdf.min.js"), FileBuffer.NONE);
            FileBuffer.writeFile("diagramstyle.css", FileBuffer.readResource("graph/diagramstyle.css"), FileBuffer.NONE);
        }
        if ("EXPORT".equalsIgnoreCase(this.type)) {
            loadFile = true;
            html.withHeader("dagre.min.js");
            html.withHeader("diagram.js");
            html.withHeader("jspdf.min.js");
            html.withHeader("diagramstyle.css");
            FileBuffer.writeFile("dagre.min.js", FileBuffer.readResource("graph/dagre.min.js"), FileBuffer.NONE);
            FileBuffer.writeFile("diagram.js", FileBuffer.readResource("graph/diagram.js"), FileBuffer.NONE);
            FileBuffer.writeFile("jspdf.min.js", FileBuffer.readResource("graph/jspdf.min.js"), FileBuffer.NONE);
            FileBuffer.writeFile("diagramstyle.css", FileBuffer.readResource("graph/diagramstyle.css"), FileBuffer.NONE);
        }
        if ("EXPORTALL".equalsIgnoreCase(this.type)) {
            loadFile = true;
            html.withScript(this.readFile("graph/dagre.min.js"), html.getHeader());
            html.withScript(this.readFile("graph/diagram.js"), html.getHeader());
            html.withScript(this.readFile("graph/jspdf.min.js"), html.getHeader());
            html.withScript(this.readFile("graph/diagramstyle.css"), html.getHeader());
        }
        if (loadFile) {
            FileBuffer.writeFile("Editor.html", html.toString(), FileBuffer.NONE);
            try {
                String string = new File("Editor.html").toURI().toURL().toString();
                ReflectionLoader.call(this.webEngine, "load", string);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                return true;
            }
        }
        html.withScript(this.readFile("graph/dagre.min.js"), html.getHeader());
        html.withScript(this.readFile("graph/diagram.js"), html.getHeader());
        html.withScript(this.readFile("graph/diagramstyle.css"), html.getHeader());
        ReflectionLoader.call(this.webEngine, "loadContent", html.toString());
        return true;
    }

    public static DiagramEditor create(Object stage, String ... url) {
        DiagramEditor editor = new DiagramEditor();
        editor.creating(stage, url, -1, -1);
        return editor;
    }

    private DiagramEditor creating(Object stage, Object url, int width, int height) {
        SimpleKeyValueList<String, String> parameterMap;
        if (stage == null) {
            return this;
        }
        if (this.controller == null) {
            SimpleController controller;
            this.controller = controller = new SimpleController(stage);
            this.controller.withListener(this);
        }
        if ((parameterMap = this.controller.getParameterMap()) != null && parameterMap.contains("EXPORTALL")) {
            this.type = "EXPORTALL";
        }
        this.registerListener(this);
        this.load(url);
        JavaBridgeFX javaFX = new JavaBridgeFX(null, this, JavaBridgeFX.CONTENT_TYPE_NONE);
        if (width < 0) {
            width = 900;
        }
        if (height < 0) {
            height = 600;
        }
        this.controller.withTitle("ClassdiagrammEditor");
        this.controller.withSize(width, height);
        this.controller.withErrorPath("errors");
        this.bridge = javaFX;
        return this;
    }

    public void show(boolean waitFor) {
        this.controller.show(this.bridge.getWebView(), waitFor, true);
    }

    public DiagramEditor withListener(Object item) {
        this.logic = item;
        if (item instanceof SimpleEventCondition) {
            this.listener = (SimpleEventCondition)this.logic;
        }
        return this;
    }

    public DiagramEditor withIcon(String icon) {
        this.controller.withIcon(icon);
        return this;
    }

    public SimpleController getController() {
        return this.controller;
    }

    @Override
    public boolean changed(SimpleEvent evt) {
        if (!"CONTENT".equalsIgnoreCase(this.type)) {
            super.changed(evt);
            return true;
        }
        if ("SUCCEEDED".equals("" + evt.getNewValue())) {
            JavaAdapter.execute(new Runnable(){

                @Override
                public void run() {
                    DiagramEditor.this.screendump(null);
                }
            });
            return true;
        }
        return true;
    }

    public void screendump(String nameExtension) {
        Class<?> snapshotParametersClass = ReflectionLoader.getClass("javafx.scene.SnapshotParameters");
        Class<?> writableImageClass = ReflectionLoader.getClass("javafx.scene.image.WritableImage");
        Object image = ReflectionLoader.call(this.webView, "snapshot", snapshotParametersClass, null, writableImageClass, null);
        Class<?> swingUtil = ReflectionLoader.getClass("javafx.embed.swing.SwingFXUtils");
        Class<?> bufferedImageClass = ReflectionLoader.getClass("java.awt.image.BufferedImage");
        Object bufferedImage = ReflectionLoader.call(swingUtil, "fromFXImage", ReflectionLoader.IMAGE, image, bufferedImageClass, null);
        Object fileName = this.file;
        if (nameExtension != null) {
            int pos = ((String)fileName).indexOf(".");
            fileName = pos < 1 ? (String)fileName + nameExtension : ((String)fileName).substring(0, pos) + "-" + nameExtension + ((String)fileName).substring(pos);
        }
        ReflectionLoader.call(ReflectionLoader.IMAGEIO, "write", ReflectionLoader.RENDEREDIMAGE, bufferedImage, String.class, "png", File.class, new File((String)fileName));
        if (this.autoClose) {
            this.controller.close();
        }
    }

    public void export(String type, Object value, String name, String context) {
        String typeName = "files";
        if ("PNG".equalsIgnoreCase(type)) {
            typeName = "Portable Network Graphics";
        } else if ("SVG".equalsIgnoreCase(type)) {
            typeName = "Scalable Vector Graphics";
        } else if ("JSON".equalsIgnoreCase(type)) {
            typeName = "JavaScript Object Notation";
        } else if ("HTML".equalsIgnoreCase(type)) {
            typeName = "Hypertext Markup Language";
        } else if ("PDF".equalsIgnoreCase(type)) {
            typeName = "Portable Document Format";
        }
        String file = DialogBox.showFileSaveChooser("Export Diagramm", name, typeName, type, this.controller.getStage());
        if (file != null && value instanceof String) {
            FileBuffer.writeFile(file, ((String)value).getBytes());
        }
    }

    public void close() {
        if (this.controller != null) {
            this.controller.close();
        }
    }
}

