/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.converter;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.ByteConverter;

public class ByteConverterHex
extends ByteConverter {
    @Override
    public String toString(BufferedBuffer values) {
        return this.toString(values, 0);
    }

    public String toString(BufferedBuffer values, int space) {
        if (values == null) {
            return null;
        }
        String hexVal = "0123456789ABCDEF";
        CharacterBuffer returnValue = new CharacterBuffer().withBufferLength(values.length() << 1 + values.length() * space);
        String step = EntityUtil.repeat(' ', space);
        for (int i = 0; i < values.length(); ++i) {
            int value = values.byteAt(i);
            if (value < 0) {
                value += 256;
            }
            returnValue.with(hexVal.charAt(value / 16));
            returnValue.with(hexVal.charAt(value % 16));
            returnValue.with(step);
        }
        return returnValue.toString();
    }

    @Override
    public byte[] decode(String value) {
        String hexVal = "0123456789ABCDEF";
        byte[] out = new byte[value.length() / 2];
        int n = value.length();
        for (int i = 0; i < n; i += 2) {
            int hn = hexVal.indexOf(value.charAt(i));
            int ln = hexVal.indexOf(value.charAt(i + 1));
            out[i / 2] = (byte)(hn << 4 | ln);
        }
        return out;
    }
}

