/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.interfaces.SendableEntityCreatorTag;

public class ByteMessage
implements SendableEntityCreatorTag {
    private final String[] properties = new String[]{"value"};
    public static final String PROPERTY_VALUE = "value";
    private byte[] value = new byte[0];

    @Override
    public Object getValue(Object entity, String attrName) {
        if (!(entity instanceof ByteMessage)) {
            return null;
        }
        int pos = attrName.indexOf(".");
        String attribute = pos > 0 ? attrName.substring(0, pos) : attrName;
        if (attribute.equalsIgnoreCase(PROPERTY_VALUE)) {
            return ((ByteMessage)entity).value;
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (!(entity instanceof ByteMessage)) {
            return false;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_VALUE)) {
            ((ByteMessage)entity).withValue((byte[])value);
            return true;
        }
        return false;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getValueString() {
        return new String(this.value);
    }

    public ByteMessage withValue(byte[] value) {
        this.value = value;
        return this;
    }

    public ByteMessage withValue(String value) {
        this.value = value.getBytes();
        return this;
    }

    @Override
    public String[] getProperties() {
        return this.properties;
    }

    @Override
    public Object getSendableInstance(boolean reference) {
        return new ByteMessage();
    }

    @Override
    public String getTag() {
        return new String(new byte[]{66});
    }
}

