package de.uniks.networkparser.parser.generator.typescript;

/*
The MIT License

Copyright (c) 2010-2016 Stefan Lindel https://github.com/fujaba/NetworkParser/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.parser.Template;
import de.uniks.networkparser.parser.generator.BasicGenerator;

public class TypescriptClazz extends BasicGenerator {
	@Override
	public Class<?> getTyp() {
		return Clazz.class;
	}

	// TODO return superclazzes and interfaces, to add proper imports via short clazz name
	public TypescriptClazz() {
		createTemplate("Declaration", Template.TEMPLATE,
				"{{#template PACKAGE {{packagename}}}}'use strict':","","","{{#endtemplate}}",
				"{{#template IMPORT}}{{#foreach {{file.headers}}}}import { {{item}} } from \"./{{item}}\";","","{{#endfor}}{{#endtemplate}}","",
				"{{#if {{type}}==interface}}export interface{{#else}}export default class{{#endif}} {{name}}{{#if {{superclazz}}}} extends {{superclazz}}{{#endif}}{{#if {{implements}}}} implements {{implements}}{{#endif}}","{",
				"{{#template TEMPLATEEND}}}{{#endtemplate}}");

		this.metaModel = true;
		this.extension = "ts";
		// TODO add classes
		this.addGenerator(new TypescriptAttribute());
//		this.addGenerator(new TypesriptAssociation());
//		this.addGenerator(new TypescriptMethod());
	}
}
