/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.LocalisationInterface;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.ParserCondition;
import de.uniks.networkparser.interfaces.TemplateParser;
import java.util.Collection;

public class ForeachCondition
implements ParserCondition {
    private static final String ITEM = "item";
    private static final String ITEMPOS = "itemPos";
    public static final String TAG = "foreach";
    private ObjectCondition expression;
    private ObjectCondition loop;
    private ObjectCondition preLoopCondition;
    private ObjectCondition postLoopCondition;

    @Override
    public String getKey() {
        return TAG;
    }

    @Override
    public CharSequence getValue(LocalisationInterface variables) {
        return null;
    }

    public ForeachCondition withExpression(ObjectCondition value) {
        this.expression = value;
        return this;
    }

    @Override
    public boolean update(Object value) {
        if (this.expression != null && this.loop != null && this.expression instanceof ParserCondition && value instanceof LocalisationInterface) {
            ParserCondition parser = (ParserCondition)this.expression;
            Object object = parser.getValue((LocalisationInterface)value);
            LocalisationInterface variablen = (LocalisationInterface)value;
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                int pos = 0;
                for (Object item : collection) {
                    variablen.put(ITEMPOS, pos);
                    variablen.put(ITEM, item);
                    if (this.preLoopCondition != null && pos > 0) {
                        this.preLoopCondition.update(value);
                    }
                    this.loop.update(value);
                    if (this.postLoopCondition != null && pos > 0) {
                        this.postLoopCondition.update(value);
                    }
                    variablen.put(ITEM, null);
                    variablen.put(ITEMPOS, null);
                    ++pos;
                }
            }
        }
        return true;
    }

    @Override
    public void create(CharacterBuffer buffer, TemplateParser parser, LocalisationInterface customTemplate) {
        buffer.skipChar(' ');
        this.expression = parser.parsing(buffer, customTemplate, true, true, new String[0]);
        buffer.skipChar('}');
        if (buffer.getCurrentChar() != '}') {
            this.preLoopCondition = parser.parsing(buffer, customTemplate, true, true, new String[0]);
        }
        buffer.skipChar('}');
        this.loop = parser.parsing(buffer, customTemplate, false, true, "endfor");
        buffer.skipChar('}');
        if (buffer.getCurrentChar() != '}') {
            this.postLoopCondition = parser.parsing(buffer, customTemplate, true, true, new String[0]);
        }
        buffer.skipChar('}');
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    public ForeachCondition withLoopCondition(ObjectCondition value) {
        this.loop = value;
        return this;
    }

    public ObjectCondition getLoopCondition() {
        return this.loop;
    }

    @Override
    public ForeachCondition getSendableInstance(boolean prototyp) {
        return new ForeachCondition();
    }

    public String toString() {
        return "{{#FOREACH " + this.expression + "}}" + this.loop + "{{#ENDFOREACH}}";
    }
}

