/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import java.beans.PropertyChangeEvent;

public class Between
implements ObjectCondition,
SendableEntityCreator {
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String BORDER = "border";
    private Double fromValue;
    private Double toValue;
    private boolean border = true;

    public Between withRange(double from, double to) {
        this.fromValue = from;
        this.toValue = to;
        return this;
    }

    public Between withFrom(double from) {
        this.fromValue = from;
        return this;
    }

    public Between withTo(double to) {
        this.toValue = to;
        return this;
    }

    public double getFrom() {
        return this.fromValue;
    }

    public double getTo() {
        return this.toValue;
    }

    @Override
    public boolean update(Object evt) {
        if (!(evt instanceof PropertyChangeEvent)) {
            return false;
        }
        PropertyChangeEvent event = (PropertyChangeEvent)evt;
        Object newValue = event.getNewValue();
        boolean result = true;
        if (this.border) {
            if (newValue instanceof Double) {
                Double newNumber = (Double)newValue;
                if (this.fromValue != null) {
                    boolean bl = result = newNumber >= this.fromValue;
                }
                if (this.toValue != null) {
                    result = result && newNumber <= this.toValue;
                }
                return result;
            }
            if (newValue instanceof Integer) {
                Integer newNumber = (Integer)newValue;
                if (this.fromValue != null) {
                    boolean bl = result = (double)newNumber.intValue() >= this.fromValue;
                }
                if (this.toValue != null) {
                    result = result && (double)newNumber.intValue() <= this.toValue;
                }
                return result;
            }
        } else {
            if (newValue instanceof Double) {
                Double newNumber = (Double)newValue;
                if (this.fromValue != null) {
                    boolean bl = result = newNumber > this.fromValue;
                }
                if (this.toValue != null) {
                    result = result && newNumber < this.toValue;
                }
                return result;
            }
            if (newValue instanceof Integer) {
                Integer newNumber = (Integer)newValue;
                if (this.fromValue != null) {
                    boolean bl = result = (double)newNumber.intValue() > this.fromValue;
                }
                if (this.toValue != null) {
                    result = result && (double)newNumber.intValue() < this.toValue;
                }
                return result;
            }
        }
        return false;
    }

    @Override
    public String[] getProperties() {
        return new String[]{FROM, TO};
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new Between();
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (FROM.equalsIgnoreCase(attribute)) {
            return ((Between)entity).getFrom();
        }
        if (TO.equalsIgnoreCase(attribute)) {
            return ((Between)entity).getTo();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (FROM.equalsIgnoreCase(attribute)) {
            if (value instanceof Double) {
                ((Between)entity).withFrom((Double)value);
            } else if (value instanceof Integer) {
                ((Between)entity).withFrom(((Integer)value).intValue());
            }
            return true;
        }
        if (TO.equalsIgnoreCase(attribute)) {
            if (value instanceof Double) {
                ((Between)entity).withTo((Double)value);
            } else if (value instanceof Integer) {
                ((Between)entity).withTo(((Integer)value).intValue());
            }
            return true;
        }
        return false;
    }
}

