/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf.proxy;

import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.ext.io.MQTTMessage;
import de.uniks.networkparser.ext.io.MessageSession;
import de.uniks.networkparser.ext.io.RabbitMessage;
import de.uniks.networkparser.ext.io.ReaderComm;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NodeProxyBroker
extends NodeProxy {
    public static final String PROPERTY_SERVERURL = "url";
    public static final String PROPERTY_clientId = "clientId";
    private String sender;
    private String password;
    private String url;
    private String clientId;
    private boolean reconnecting = false;
    private MessageSession session;
    private ExecutorService executorService;
    private ReaderComm readerComm;
    private static final String CLIENTID_PREFIX = "np_broker";
    private String format = "AMQ";
    private int mqttVersion = 4;
    private SimpleKeyValueList<String, String> topics = new SimpleKeyValueList();
    private SimpleKeyValueList<Short, SimpleKeyValueList<Short, SimpleKeyValueList<String, Byte>>> values;
    private ObjectCondition callBack;
    public static final String EVENT_CONNECT = "connected";
    public static final String EVENT_CONNECTLOST = "ConnectionLost";
    public static final String EVENT_MESSAGE = "Message";
    private static final int MIN_MSG_ID = 1;
    private static final int MAX_MSG_ID = 65535;
    private int nextMsgId = 0;

    public NodeProxyBroker() {
        this.property.addAll(PROPERTY_SERVERURL);
        this.propertyUpdate.addAll(PROPERTY_SERVERURL);
        this.propertyInfo.addAll(PROPERTY_SERVERURL);
    }

    public NodeProxyBroker(String serverURI) {
        this(serverURI, null);
    }

    public NodeProxyBroker withAuth(String sender, String password) {
        this.sender = sender;
        this.password = password;
        return this;
    }

    public NodeProxyBroker(String url, String clientId) {
        this.url = url;
        if (clientId == null) {
            this.clientId = NodeProxyBroker.generateClientId();
        }
    }

    public static String generateClientId() {
        return CLIENTID_PREFIX + System.nanoTime();
    }

    public boolean connect() {
        if (this.session == null) {
            this.session = new MessageSession();
        }
        if (!this.session.isClose()) {
            return false;
        }
        this.session.withHost(this.url);
        boolean success = false;
        success = "MQTT".equals(this.format) ? this.session.connectMQTT(this, this.clientId, this.sender, this.password, 60, this.mqttVersion, true) : this.session.connectAMQ(this, this.sender, this.password);
        if (success && this.callBack != null) {
            SimpleEvent event = new SimpleEvent(this, this.url, null, this.session).withType(EVENT_CONNECT);
            this.callBack.update(event);
        }
        return success;
    }

    public void executeException(Exception e) {
        if (this.callBack != null) {
            SimpleEvent event = new SimpleEvent(this, this.url, null, this.session).withType(EVENT_CONNECTLOST);
            this.callBack.update(event);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getServerURI() {
        return this.url;
    }

    @Override
    public boolean isSendable() {
        return true;
    }

    @Override
    public boolean close() {
        return this.close(false);
    }

    public boolean close(boolean force) {
        if (this.session == null) {
            return true;
        }
        if ("AMQ".equals(this.format)) {
            RabbitMessage msg;
            if (this.topics != null) {
                while (this.topics.size() > 0) {
                    String channel = this.topics.removePos(this.topics.size() - 1);
                    short no = Short.valueOf(channel);
                    msg = RabbitMessage.createClose(no);
                    this.session.sending(this, msg, false);
                }
            }
            msg = RabbitMessage.createClose((short)0);
            this.session.sending(this, msg, false);
        } else if ("MQTT".equals(this.format)) {
            MQTTMessage msg = MQTTMessage.create((byte)14);
            this.session.sending(this, msg, false);
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        return this.session.close();
    }

    @Override
    protected boolean initProxy() {
        try {
            return this.connect();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getKey() {
        return this.url;
    }

    public String getUserName() {
        return this.sender;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getReconnecting() {
        return this.reconnecting;
    }

    @Override
    public NodeProxyBroker getSendableInstance(boolean prototyp) {
        return new NodeProxyBroker();
    }

    public NodeProxyBroker withCallback(ObjectCondition condition) {
        this.callBack = condition;
        return this;
    }

    public boolean subscribe(String topic, ObjectCondition callBack) {
        this.callBack = callBack;
        return this.subscribe(topic);
    }

    public boolean consume(String topic, ObjectCondition condition) {
        this.callBack = condition;
        this.startConsume(topic, this.callBack);
        return true;
    }

    public boolean subscribe(String topic) {
        if (this.session != null) {
            if ("AMQ".equals(this.format)) {
                RabbitMessage message = RabbitMessage.createChannelOpen(this, topic);
                if (this.session.sending(this, message, true) == null) {
                    return false;
                }
                short channel = message.getChannel();
                if (this.session.sending(this, message = RabbitMessage.createQueue(channel, topic, false, false, false, null), true) == null) {
                    return false;
                }
                this.startConsume(topic, this.callBack);
                message = RabbitMessage.createConsume(channel, topic, "", false, true, false, false, null);
                this.session.sending(this, message, false);
                return true;
            }
            if ("MQTT".equals(this.format)) {
                MQTTMessage.createChannelOpen(topic);
                MQTTMessage register = MQTTMessage.createChannelOpen(topic);
                register.withNames(topic).withQOS(1);
                this.session.sending(this, register, false);
                this.startConsume(topic, this.callBack);
                return true;
            }
        }
        return false;
    }

    private boolean startConsume(String queue, ObjectCondition condition) {
        if (this.space == null) {
            this.executorService = Executors.newScheduledThreadPool(1);
            this.readerComm = new ReaderComm();
            this.readerComm.withSession(this.session);
            this.readerComm.withChannel(queue);
            this.readerComm.withCondition(condition);
            this.readerComm.start(this, "Broker-Reader: " + queue);
            this.executorService.execute(this.readerComm);
            return true;
        }
        return false;
    }

    public boolean publish(String channel, String message) {
        if ("AMQ".equals(this.format)) {
            SimpleKeyValueList<String, String> topics = this.getTopics();
            short channelNo = Short.valueOf(topics.get(channel));
            RabbitMessage msg = RabbitMessage.createPublish(channelNo, "", channel, message.getBytes());
            this.session.sending(this, msg, false);
            msg = RabbitMessage.createPublishHeader(channelNo, message);
            this.session.sending(this, msg, false);
            msg = RabbitMessage.createPublishBody(channelNo, message);
            this.session.sending(this, msg, false);
            return true;
        }
        if ("MQTT".equals(this.format)) {
            MQTTMessage msg = MQTTMessage.create((byte)3);
            msg.withNames(channel).createMessage(message);
            this.session.sending(this, msg, true);
            return true;
        }
        return false;
    }

    public boolean bindExchange(String exchange, String queue) {
        if ("AMQ".equals(this.format)) {
            RabbitMessage msg;
            short channelNo;
            SimpleKeyValueList<String, String> topics = this.getTopics();
            if (topics.get(exchange) != null) {
                channelNo = Short.valueOf(topics.get(exchange));
            } else {
                msg = RabbitMessage.createChannelOpen(this, exchange);
                this.session.sending(this, msg, false);
                channelNo = Short.valueOf(topics.get(exchange));
            }
            msg = RabbitMessage.createExange(channelNo, exchange, null);
            this.session.sending(this, msg, true);
            msg = RabbitMessage.createBind(channelNo, exchange, queue);
            this.session.sending(this, msg, true);
            return true;
        }
        return false;
    }

    public NodeProxyBroker withFormat(String format) {
        this.format = format;
        return this;
    }

    public static NodeProxyBroker createMQTTBroker(String url) {
        NodeProxyBroker broker = new NodeProxyBroker(url);
        broker.withFormat("MQTT");
        return broker;
    }

    public SimpleKeyValueList<Short, SimpleKeyValueList<Short, SimpleKeyValueList<String, Byte>>> getGrammar(boolean create) {
        if (!create) {
            return this.values;
        }
        this.values = new SimpleKeyValueList();
        return this.values;
    }

    public SimpleKeyValueList<String, String> getTopics() {
        if (this.topics == null) {
            this.topics = new SimpleKeyValueList();
        }
        return this.topics;
    }

    public String getFormat() {
        return this.format;
    }

    public int getNextMessageId() {
        ++this.nextMsgId;
        if (this.nextMsgId > 65535) {
            this.nextMsgId = 1;
        }
        return this.nextMsgId;
    }
}

