/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf;

import de.uniks.networkparser.ext.petaf.MessageRequest;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyTCP;
import de.uniks.networkparser.interfaces.Server;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class Server_TCP
extends Thread
implements Server {
    protected boolean run = true;
    private boolean searchFreePort = true;
    protected ServerSocket serverSocket;
    private NodeProxyTCP proxy;

    public Server_TCP(int port) {
        this(NodeProxyTCP.createServer(port));
    }

    public Server_TCP(NodeProxyTCP proxy) {
        this.proxy = proxy;
        if (this.init()) {
            this.start();
        }
    }

    @Override
    public boolean isRun() {
        return this.run;
    }

    @Override
    public boolean close() {
        this.run = false;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        if (this.proxy.getUrl() != null) {
            Thread.currentThread().setName(this.proxy.getUrl() + ":" + this.proxy.getPort() + " com server");
        } else {
            Thread.currentThread().setName("localhost:" + this.proxy.getPort() + " com server");
        }
        while (!this.isInterrupted() && this.run) {
            Socket requestSocket = null;
            try {
                requestSocket = this.serverSocket.accept();
                MessageRequest.executeTask(this.proxy, requestSocket);
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    private boolean init() {
        try {
            this.serverSocket = new ServerSocket(this.proxy.getPort(), 10, null);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
        catch (IOException e) {
            if (this.searchFreePort) {
                try {
                    this.serverSocket = new ServerSocket(0, 10, null);
                    this.proxy.withPort(this.serverSocket.getLocalPort());
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public boolean isSearchFreePort() {
        return this.searchFreePort;
    }

    public Server_TCP withSearchFreePort(boolean searchFreePort) {
        this.searchFreePort = searchFreePort;
        return this;
    }
}

