/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf;

import de.uniks.networkparser.ext.petaf.Message;
import de.uniks.networkparser.ext.petaf.PropertyList;
import de.uniks.networkparser.ext.petaf.SendableItem;
import de.uniks.networkparser.ext.petaf.SimpleExecutor;
import de.uniks.networkparser.ext.petaf.Space;
import de.uniks.networkparser.ext.petaf.TaskExecutor;
import de.uniks.networkparser.ext.petaf.messages.ConnectMessage;
import de.uniks.networkparser.ext.petaf.messages.InfoMessage;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreatorNoIndex;
import de.uniks.networkparser.list.SimpleList;

public abstract class NodeProxy
extends SendableItem
implements Comparable<NodeProxy>,
SendableEntityCreatorNoIndex {
    public static final String TYPE_IN = "IN";
    public static final String TYPE_OUT = "OUT";
    public static final String TYPE_INOUT = "INOUT";
    public static int BUFFER = 102400;
    public static final String PROPERTY_SEND = "sendtime";
    public static final String PROPERTY_RECEIVE = "receivetime";
    public static final String PROPERTY_HISTORY = "history";
    public static final String PROPERTY_NODES = "nodes";
    public static final String PROPERTY_FILTER = "filter";
    public static final String PROPERTY_ONLINE = "online";
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_TYP = "typ";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_ID = "id";
    protected PropertyList propertyId = PropertyList.create("id");
    protected PropertyList propertyUpdate = PropertyList.create("id", "history", "filter", "sendtime");
    protected PropertyList propertyInfo = PropertyList.create("id", "sendtime", "receivetime", "history", "filter", "version");
    protected PropertyList property = PropertyList.create("id", "sendtime", "receivetime", "online", "nodes", "history", "filter", "version");
    protected String type;
    protected long sendtime;
    protected long receivetime;
    protected long lastSendTryTime;
    protected long receiveBytes;
    protected long sendBytes;
    protected int lastSendCount;
    protected String version;
    protected boolean online;
    protected String history;
    protected ObjectCondition filter;
    protected long no;
    protected Space space;
    protected String name;
    protected NodeProxy nextNode;

    public String[] getUpdateProperties() {
        return this.propertyUpdate.getList();
    }

    public String[] getInfoProperties() {
        return this.propertyInfo.getList();
    }

    @Override
    public String[] getProperties() {
        return this.property.getList();
    }

    public String[] getIDProperties() {
        return this.propertyId.getList();
    }

    public void connectToPeer() {
        this.sendMessage(ConnectMessage.create());
    }

    public void connectInfo() {
        this.sendMessage(new InfoMessage());
    }

    public boolean sendMessage(Message msg) {
        if (this.space != null) {
            return this.space.sendMessage(msg, false, this);
        }
        return this.sending(msg);
    }

    public boolean sendPing() {
        InfoMessage message = new InfoMessage();
        return this.sendMessage(message);
    }

    public boolean sendMessageToPeers(Message msg) {
        return this.space.sendMessageToPeers(msg, this);
    }

    public boolean isValid() {
        return true;
    }

    protected boolean sending(Message msg) {
        if (!this.isValid()) {
            return true;
        }
        msg.withAddToReceived(this);
        this.lastSendTryTime = System.currentTimeMillis();
        if (this.space != null) {
            this.space.updateNetwork(TYPE_OUT, this);
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public void updateReceive(int len, boolean setOnline) {
        this.receivetime = System.currentTimeMillis();
        this.receiveBytes += (long)len;
        if (setOnline) {
            this.withOnline(true);
        }
    }

    public NodeProxy withType(String value) {
        this.type = value;
        return this;
    }

    public long getNewMsgNo() {
        ++this.no;
        if (this.no < 0L) {
            this.no = 0L;
        }
        return this.no;
    }

    public void setSendTime(int bytes) {
        this.sendtime = System.currentTimeMillis();
        this.lastSendCount = 0;
    }

    public long getSendTime() {
        return this.sendtime;
    }

    public boolean isReconnecting(SimpleList<Integer> seconds) {
        boolean result;
        int time;
        if (this.isOnline() || seconds.size() < 1) {
            return false;
        }
        if (this.lastSendCount >= seconds.size()) {
            this.lastSendCount = seconds.size() - 1;
        }
        if ((time = ((Integer)seconds.get(this.lastSendCount)).intValue()) == 0) {
            return false;
        }
        boolean bl = result = !this.isOnline() && System.currentTimeMillis() - this.lastSendTryTime > (long)time;
        if (result) {
            ++this.lastSendCount;
        }
        return result;
    }

    public void setReceiveTime() {
        this.receivetime = System.currentTimeMillis();
    }

    public Long getReceiveTime() {
        return this.receivetime;
    }

    public NodeProxy withOnline(boolean value) {
        boolean oldValue = this.online;
        this.online = value;
        this.firePropertyChange(PROPERTY_ONLINE, oldValue, value);
        return this;
    }

    public boolean isOnline() {
        return this.online;
    }

    public abstract boolean isSendable();

    @Override
    public int compareTo(NodeProxy o) {
        if (this.getKey() == null) {
            if (o.getKey() == null) {
                return 0;
            }
            return 1;
        }
        if (o == null || o.getKey() == null) {
            if (this.getKey() == null) {
                return 0;
            }
            return -1;
        }
        return this.getKey().compareTo(o.getKey());
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeProxy) {
            return this.compareTo((NodeProxy)obj) == 0;
        }
        return super.equals(obj);
    }

    public String getHistory() {
        return this.history;
    }

    public NodeProxy withHistory(String value) {
        String oldValue = this.history;
        this.history = value;
        this.firePropertyChange(PROPERTY_HISTORY, oldValue, value);
        return this;
    }

    public NodeProxy withFilter(ObjectCondition value) {
        if (value != null && !value.equals(this.filter)) {
            this.filter = value;
        }
        return this;
    }

    public ObjectCondition getFilter() {
        return this.filter;
    }

    public boolean filter(Object value) {
        if (this.filter != null) {
            return this.filter.update(value);
        }
        return true;
    }

    public String getVersion() {
        return this.version;
    }

    public NodeProxy withVersion(String value) {
        String oldValue = this.version;
        this.version = value;
        this.firePropertyChange(PROPERTY_VERSION, oldValue, value);
        return this;
    }

    @Override
    public boolean setValue(Object element, String attrName, Object value, String type) {
        if (!(element instanceof NodeProxy)) {
            return false;
        }
        NodeProxy nodeProxy = (NodeProxy)element;
        if (PROPERTY_SEND.equals(attrName)) {
            long oldValue = nodeProxy.sendtime;
            nodeProxy.sendtime = Long.valueOf("" + value);
            this.firePropertyChange(PROPERTY_SEND, oldValue, nodeProxy.sendtime);
            return true;
        }
        if (PROPERTY_RECEIVE.equals(attrName)) {
            long oldValue = nodeProxy.receivetime;
            nodeProxy.receivetime = Long.valueOf("" + value);
            this.firePropertyChange(PROPERTY_RECEIVE, oldValue, nodeProxy.receivetime);
            return true;
        }
        if (PROPERTY_HISTORY.equals(attrName)) {
            nodeProxy.withHistory("" + value);
            return true;
        }
        if (PROPERTY_FILTER.equals(attrName)) {
            nodeProxy.withFilter((ObjectCondition)value);
            return true;
        }
        if (PROPERTY_ONLINE.equals(attrName)) {
            nodeProxy.withOnline(Boolean.valueOf("" + value));
            return true;
        }
        if (PROPERTY_VERSION.equals(attrName)) {
            nodeProxy.withVersion("" + value);
            return true;
        }
        if (PROPERTY_TYP.equals(attrName)) {
            nodeProxy.withType("" + value);
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(Object element, String attrName) {
        if (!(element instanceof NodeProxy)) {
            return null;
        }
        NodeProxy nodeProxy = (NodeProxy)element;
        if (PROPERTY_SEND.equals(attrName)) {
            return nodeProxy.getSendTime();
        }
        if (PROPERTY_RECEIVE.equals(attrName)) {
            return nodeProxy.getReceiveTime();
        }
        if (PROPERTY_HISTORY.equals(attrName)) {
            return nodeProxy.getHistory();
        }
        if (PROPERTY_FILTER.equals(attrName)) {
            return nodeProxy.getFilter();
        }
        if (PROPERTY_ONLINE.equals(attrName)) {
            return nodeProxy.isOnline();
        }
        if (PROPERTY_VERSION.equals(attrName)) {
            return nodeProxy.getVersion();
        }
        if (PROPERTY_TYP.equals(attrName)) {
            return nodeProxy.getType();
        }
        if (PROPERTY_ID.equals(attrName)) {
            return nodeProxy.getKey();
        }
        return null;
    }

    public abstract boolean close();

    public NodeProxy initSpace(Space value) {
        if (value == this.space) {
            return this;
        }
        Space oldValue = this.space;
        if (null != this.space) {
            this.space = null;
            oldValue.removeProxy(this);
        }
        this.space = value;
        this.initProxy();
        if (null != value) {
            value.with(this);
        }
        this.firePropertyChange(PROPERTY_NODES, oldValue, value);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NodeProxy withName(String name) {
        this.name = name;
        return this;
    }

    public Space getSpace() {
        return this.space;
    }

    protected abstract boolean initProxy();

    public NodeProxy next() {
        return this.nextNode;
    }

    public NodeProxy setNextMyNode(NodeProxy nextNode) {
        this.nextNode = nextNode;
        if (nextNode == null) {
            return this;
        }
        nextNode.setNextMyNode(null);
        return nextNode;
    }

    public TaskExecutor getExecutor() {
        if (this.space != null) {
            return this.space.getExecutor();
        }
        return new SimpleExecutor();
    }

    public abstract String getKey();

    public static boolean isInput(String value) {
        return value != null && value.indexOf(TYPE_IN) >= 0;
    }

    public static boolean isOutput(String value) {
        return value != null && value.indexOf(TYPE_OUT) >= 0;
    }
}

