/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx.dialog;

import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.javafx.dialog.DialogBox;

public class DialogStage
implements Runnable {
    public DialogBox parent;
    private Object stage;
    private Object owner;

    public DialogStage(DialogBox parent, Object owner) {
        this.parent = parent;
        this.owner = owner;
    }

    public void showAndWait() {
        this.centerOnScreen();
        ReflectionLoader.call(this.stage, "showAndWait", new Object[0]);
    }

    public void show() {
        ReflectionLoader.call(this.stage, "show", new Object[0]);
    }

    @Override
    public void run() {
        Object transparent = ReflectionLoader.getField("TRANSPARENT", ReflectionLoader.STAGESTYLE);
        this.stage = ReflectionLoader.newInstance(ReflectionLoader.STAGE, ReflectionLoader.STAGESTYLE, transparent);
        this.parent.setStage(this.stage);
        Object modality = this.parent.modal ? (this.owner != null ? ReflectionLoader.getField("WINDOW_MODAL", ReflectionLoader.MODALITY) : ReflectionLoader.getField("APPLICATION_MODAL", ReflectionLoader.MODALITY)) : ReflectionLoader.getField("NONE", ReflectionLoader.MODALITY);
        ReflectionLoader.call(this.stage, "initModality", ReflectionLoader.MODALITY, modality);
        this.parent.createContent();
        Object scene = ReflectionLoader.newInstance(ReflectionLoader.SCENE, ReflectionLoader.PARENT, this.parent.getRoot());
        Object color = ReflectionLoader.getField("TRANSPARENT", ReflectionLoader.COLOR);
        ReflectionLoader.call(scene, "setFill", ReflectionLoader.PAINT, color);
        ReflectionLoader.call(this.stage, "setScene", scene);
        this.parent.configScene();
        if (this.parent.modal) {
            this.showAndWait();
            return;
        }
        this.show();
    }

    public void centerOnScreen() {
        Object scene = ReflectionLoader.call(this.owner, "getScene", new Object[0]);
        if (scene != null) {
            double y;
            double x;
            double sceneX = (Double)ReflectionLoader.call(this.owner, "getX", new Object[0]);
            double sceneY = (Double)ReflectionLoader.call(this.owner, "getY", new Object[0]);
            double dialogWidth = this.parent.prefWidth(-1.0);
            double dialogHeight = this.parent.prefHeight(-1.0);
            double ownerX = (Double)ReflectionLoader.call(this.owner, "getX", new Object[0]);
            double ownerY = (Double)ReflectionLoader.call(this.owner, "getY", new Object[0]);
            if (ownerX < 0.0 || ownerY < 0.0) {
                Object screen = ReflectionLoader.call(ReflectionLoader.SCREEN, "getPrimary", new Object[0]);
                double maxW = (Double)ReflectionLoader.callChain(screen, "getVisualBounds", "getWidth");
                double maxH = (Double)ReflectionLoader.callChain(screen, "getVisualBounds", "getHeight");
                x = maxW / 2.0 - dialogWidth / 2.0;
                y = maxH / 2.0 - dialogHeight / 2.0 + sceneY;
            } else {
                x = ownerX + sceneX / 2.0 - dialogWidth / 2.0;
                y = ownerY + sceneY + sceneY / 2.0 - dialogHeight / 2.0;
            }
            ReflectionLoader.call(this.stage, "setX", Double.TYPE, x);
            ReflectionLoader.call(this.stage, "setY", Double.TYPE, y);
        }
    }
}

