/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.converter;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.Method;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.BufferItem;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.Converter;

public class DotConverter
implements Converter {
    private boolean removePackage;

    public DotConverter() {
    }

    public DotConverter(boolean removePackage) {
        this.removePackage = removePackage;
    }

    public GraphList decode(Object item) {
        if (item instanceof CharacterBuffer) {
            return this.decodeGraph((CharacterBuffer)item);
        }
        if (item != null) {
            CharacterBuffer buffer = new CharacterBuffer();
            buffer.with(item.toString());
            return this.decodeGraph(buffer);
        }
        return null;
    }

    GraphList decodeGraph(BufferItem value) {
        char c = value.nextClean(true);
        StringBuilder sb = new StringBuilder();
        boolean useStrict = false;
        GraphList graph = new GraphList();
        block5: do {
            c = value.getChar();
            switch (c) {
                case '\u0000': {
                    break;
                }
                case ' ': {
                    if (useStrict || !"strict".equals(sb.toString())) continue block5;
                    sb = new StringBuilder();
                    useStrict = true;
                    break;
                }
                case '\n': 
                case '[': 
                case '{': {
                    value.getChar();
                    if (c == '[') {
                        this.decodeAttributes(graph, value);
                    }
                    this.decodeEdge(graph, value);
                    c = '\u0000';
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
        } while (c != '\u0000');
        return graph;
    }

    void decodeEdge(GraphList graph, BufferItem value) {
        char endChar;
        do {
            GraphEntity node = this.decodeNode(graph, value);
            graph.withNode(node);
            if (value.getCurrentChar() != '-') continue;
            Association edge = new Association(node);
            char c = value.getChar();
            if (c != '-' && c == '>') {
                edge.with(AssociationTypes.UNDIRECTIONAL);
            }
            value.getChar();
            GraphEntity otherNode = this.decodeNode(graph, value);
            if (otherNode == null) continue;
            Association otherEdge = new Association(otherNode);
            otherEdge.with(otherNode);
            graph.withNode(otherNode);
            edge.with(otherEdge);
        } while ((endChar = value.getCurrentChar()) != '\u0000' && endChar != '}');
        value.skip();
    }

    GraphEntity decodeNode(GraphList graph, BufferItem value) {
        char c = value.nextClean(true);
        StringBuilder sb = new StringBuilder();
        sb.append(c);
        Clazz node = null;
        do {
            c = value.getChar();
            switch (c) {
                case '\u0000': {
                    break;
                }
                case '\n': 
                case '-': 
                case '[': 
                case '}': {
                    String id = sb.toString().trim();
                    node = graph.getNode(id);
                    if (node == null) {
                        node = new Clazz(id);
                    }
                    if (c == '[') {
                        this.decodeAttributes(node, value);
                    }
                    if (c == '\n') {
                        value.skip();
                    }
                    value.nextClean(true);
                    c = '\u0000';
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
        } while (c != '\u0000');
        return node;
    }

    void decodeAttributes(GraphEntity node, BufferItem value) {
        char c;
        value.skipTo('[', false);
        do {
            String key;
            if ((key = this.decodeValue(value)) != null && value.getCurrentChar() == '=') {
                value.skip();
                String valueStr = this.decodeValue(value);
                if (node instanceof Clazz) {
                    Attribute attribute = ((Clazz)node).createAttribute(key, DataType.STRING);
                    attribute.withValue(valueStr);
                }
            }
            if ((c = value.getCurrentChar()) == ']') continue;
            c = value.getChar();
        } while (c != ']');
        value.skip();
    }

    String decodeValue(BufferItem value) {
        char c = value.nextClean(true);
        StringBuilder sb = new StringBuilder();
        sb.append(c);
        do {
            c = value.getChar();
            switch (c) {
                case '\u0000': {
                    break;
                }
                case '\n': 
                case ',': 
                case ';': 
                case '=': 
                case ']': 
                case '}': {
                    c = '\u0000';
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
        } while (c != '\u0000');
        return sb.toString();
    }

    private String getType(GraphEntity item, String type, boolean shortName) {
        if (type.equals("objectdiagram")) {
            return item.getId();
        }
        if (type.equals("classdiagram")) {
            return item.getName(shortName);
        }
        return "";
    }

    @Override
    public String encode(BaseItem entity) {
        return this.encode(entity, this.removePackage);
    }

    public String encode(BaseItem entity, boolean removePackage) {
        if (!(entity instanceof GraphList)) {
            return "";
        }
        GraphList root = (GraphList)entity;
        StringBuilder sb = new StringBuilder();
        String graphType = "graph";
        if ("objectdiagram".equals(root.getType())) {
            sb.append(" ObjectDiagram {\r\n");
        } else {
            sb.append(" ClassDiagram {\r\n");
        }
        sb.append("   node [shape = none, fontsize = 10, fontname = \"Arial\"];\r\n");
        sb.append("   edge [fontsize = 10, fontname = \"Arial\"];\r\n");
        sb.append("   compound=true;\r\n\r\n");
        boolean isObjectdiagram = false;
        isObjectdiagram = "objectdiagram".equals(root.getType());
        for (GraphEntity node : root.getNodes()) {
            sb.append(node.getName(false));
            sb.append("[label=<<table border='0' cellborder='1' cellspacing='0'><tr><td><b>");
            if (isObjectdiagram) {
                sb.append("<u>");
            }
            sb.append(node.getName(false) + " : " + this.getType(node, root.getType(), removePackage));
            if (isObjectdiagram) {
                sb.append("</u>");
            }
            sb.append("</b></td></tr>");
            if (!(node instanceof Clazz)) {
                sb.append("</table>>];\r\n");
                continue;
            }
            Clazz graphClazz = (Clazz)node;
            StringBuilder childBuilder = new StringBuilder();
            for (Attribute attribute : graphClazz.getAttributes(new Condition[0])) {
                if (isObjectdiagram) {
                    childBuilder.append("\r\n<tr><td align='left'>" + attribute.getName() + " = " + attribute.getValue() + "</td></tr>");
                    continue;
                }
                childBuilder.append("\r\n<tr><td align='left'>" + attribute.getName() + " : " + attribute.getType().getName(removePackage) + "</td></tr>");
            }
            if (childBuilder.length() > 0) {
                sb.append("\r\n<tr><td><table border='0' cellborder='0' cellspacing='0'>");
                sb.append(childBuilder.toString());
                sb.append("\r\n</table></td></tr>");
            }
            childBuilder = new StringBuilder();
            for (Method method : graphClazz.getMethods(new Condition[0])) {
                childBuilder.append("\r\n<tr><td align='left'>" + method.getName(false) + "</td></tr>");
            }
            if (childBuilder.length() > 0) {
                sb.append("\r\n<tr><td><table border='0' cellborder='0' cellspacing='0'>");
                sb.append(childBuilder.toString());
                sb.append("\r\n</table></td></tr>");
            }
            sb.append("</table>>];\r\n");
        }
        root.initSubLinks();
        for (Association edge : root.getAssociations(new Condition[0])) {
            Association otherEdge = edge.getOther();
            if (otherEdge.getType() != AssociationTypes.EDGE) {
                sb.append(edge.getClazz().getName(false) + " -- " + otherEdge.getClazz().getName(false));
                sb.append("[headlabel = \"" + edge.getName() + "\" taillabel = \"" + otherEdge.getName() + "\"];" + "\r\n");
                continue;
            }
            sb.append(edge.getClazz().getName(false) + " -> " + otherEdge.getClazz().getName(false));
            graphType = "digraph";
            sb.append("[taillabel = \"" + edge.getName() + "\"];" + "\r\n");
        }
        sb.append("}");
        return graphType + sb.toString();
    }
}

