/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.converter;

import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.ByteConverter;
import java.nio.charset.Charset;

public class ByteConverterHTTP
extends ByteConverter {
    @Override
    public String toString(BufferedBuffer values) {
        CharacterBuffer returnValue = new CharacterBuffer();
        if (values != null) {
            for (int i = 0; i < values.length(); ++i) {
                byte value = values.byteAt(i);
                if (value <= 32 || value == 127) {
                    returnValue.with(' ');
                    returnValue.with((char)(value + 32 + 1));
                    continue;
                }
                returnValue.with((char)value);
            }
        }
        return returnValue.toString();
    }

    @Override
    public byte[] decode(String values) {
        return this.decode(values.getBytes(Charset.forName("utf-8")));
    }

    public byte[] decode(byte[] values) {
        if (values == null) {
            return null;
        }
        int len = values.length;
        ByteBuffer buffer = ByteBuffer.allocate(len);
        for (int i = 0; i < len; ++i) {
            byte value = values[i];
            if (value == 32) {
                value = values[++i];
                buffer.put((byte)(value - 32 - 1));
                continue;
            }
            buffer.put(value);
        }
        buffer.flip(false);
        return buffer.array(buffer.length(), true);
    }
}

