/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.parser;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.interfaces.LocalisationInterface;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.ParserCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.TemplateParser;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.logic.ChainCondition;
import de.uniks.networkparser.logic.Equals;
import de.uniks.networkparser.logic.IfCondition;
import de.uniks.networkparser.logic.Not;
import de.uniks.networkparser.logic.StringCondition;
import de.uniks.networkparser.logic.TemplateCondition;
import de.uniks.networkparser.logic.VariableCondition;
import de.uniks.networkparser.parser.TemplateResultFragment;
import de.uniks.networkparser.parser.TemplateResultModel;

public class Template
implements TemplateParser {
    private static final char SPLITSTART = '{';
    private static final char SPLITEND = '}';
    private static final char ENTER = '=';
    private static final char SPACE = ' ';
    private TemplateCondition token = new TemplateCondition();
    private int type = -1;
    public String name;
    private SimpleList<String> imports = new SimpleList();
    private SimpleList<String> variables = new SimpleList();

    public Template(String name) {
        this.name = name;
    }

    public Template() {
    }

    public TemplateResultFragment generate(LocalisationInterface parameters, SendableEntityCreator parent, GraphMember member) {
        ObjectCondition template;
        if (this.token.getCondition() instanceof StringCondition) {
            this.token.withCondition(this.parsing((StringCondition)this.token.getCondition(), parameters, false));
        }
        if ((template = this.token.getTemplate()) instanceof StringCondition) {
            this.token.withTemplate(null);
            ObjectCondition newTemplate = this.parsing((StringCondition)template, parameters, true);
            this.token.withTemplate(newTemplate);
        }
        TemplateResultFragment templateFragment = new TemplateResultFragment();
        templateFragment.withKey(this.getType());
        templateFragment.withName(this.getName());
        templateFragment.setParent(parent);
        templateFragment.withVariable(parameters);
        templateFragment.withMember(member);
        if (!this.token.update(templateFragment)) {
            return null;
        }
        templateFragment.withExpression(false);
        ObjectCondition templateCondition = this.token.getTemplate();
        templateCondition.update(templateFragment);
        return templateFragment;
    }

    public ObjectCondition parsing(StringCondition tokenTemplate, LocalisationInterface customTemplate, boolean variable) {
        CharacterBuffer template = null;
        CharSequence value2 = tokenTemplate.getValue(null);
        template = value2 instanceof CharacterBuffer ? (CharacterBuffer)value2 : new CharacterBuffer().with(value2);
        if (variable) {
            this.variables.clear();
        }
        return this.parsing(template, customTemplate, false, true, new String[0]);
    }

    @Override
    public ObjectCondition parsing(CharacterBuffer buffer, LocalisationInterface customTemplate, boolean isExpression, boolean allowSpace, String ... stopWords) {
        int end;
        int start = buffer.position();
        ObjectCondition child = null;
        ChainCondition parent = new ChainCondition();
        while (!(buffer.isEnd() || isExpression && buffer.getCurrentChar() == ' ')) {
            char character = buffer.nextClean(true);
            if (isExpression && character == '}') break;
            if (character != '{') {
                buffer.skip();
                continue;
            }
            character = buffer.getChar();
            if (character != '{') {
                buffer.skip();
                continue;
            }
            character = buffer.getChar();
            while (character == '{') {
                character = buffer.getChar();
            }
            end = buffer.position() - 2;
            if (end - start > 0) {
                child = StringCondition.create(buffer.substring(start, end));
                parent.with(child);
            }
            CharacterBuffer tokenPart = new CharacterBuffer();
            if (character == '#') {
                Object item;
                ParserCondition creator;
                int startCommand = buffer.position();
                tokenPart = buffer.nextToken(false, ' ', '}');
                if (stopWords != null) {
                    for (String stopword : stopWords) {
                        if (!tokenPart.equalsIgnoreCase(stopword)) continue;
                        buffer.withPosition(startCommand);
                        if (parent.size() == 1) {
                            return parent.first();
                        }
                        return parent;
                    }
                }
                ParserCondition condition = null;
                if (customTemplate instanceof TemplateResultModel && (creator = ((TemplateResultModel)customTemplate).getTemplate(tokenPart.toString())) != null && (item = creator.getSendableInstance(isExpression)) instanceof ParserCondition) {
                    condition = (ParserCondition)item;
                }
                if (condition != null) {
                    condition.create(buffer, this, customTemplate);
                    parent.with(condition);
                    if (stopWords != null && isExpression && buffer.getCurrentChar() == ' ') {
                        buffer.skip();
                    }
                }
                start = buffer.position();
                continue;
            }
            buffer.nextString(tokenPart, false, false, '}');
            String key = tokenPart.toString();
            child = this.createVariable(key, isExpression);
            character = buffer.getChar();
            if (character == '}') {
                buffer.getChar();
                if (isExpression) {
                    char firstChar = buffer.getCurrentChar();
                    if (firstChar == '=' || firstChar == '!') {
                        char nextChar = buffer.getChar();
                        if (nextChar == '=') {
                            buffer.skip();
                            Equals equalsExpression = new Equals();
                            char currentChar = buffer.getCurrentChar();
                            if (currentChar == '>') {
                                equalsExpression.withPosition(-1);
                                buffer.skip();
                            } else if (currentChar == '<') {
                                equalsExpression.withPosition(1);
                                buffer.skip();
                            } else if (currentChar == '!') {
                                equalsExpression.withPosition(0);
                                buffer.skip();
                                firstChar = firstChar == currentChar ? (char)'\u0000' : currentChar;
                            } else {
                                equalsExpression.withPosition(0);
                            }
                            equalsExpression.withLeft(child);
                            child = this.parsing(buffer, customTemplate, true, allowSpace, stopWords);
                            equalsExpression.withRight(child);
                            child = firstChar == '!' ? new Not().with(equalsExpression) : equalsExpression;
                        } else {
                            buffer.skip(-1);
                        }
                        parent.with(child);
                        start = buffer.position();
                    } else {
                        parent.with(child);
                        start = buffer.position();
                    }
                    if (stopWords == null) break;
                    if (buffer.getCurrentChar() == ' ') {
                        ++start;
                        buffer.skip();
                        if (!allowSpace) break;
                        continue;
                    }
                }
                start = buffer.position();
                parent.with(child);
                continue;
            }
            parent.with(child);
            tokenPart.clear();
            buffer.nextString(tokenPart, false, false, '}');
            IfCondition token = new IfCondition();
            token.withExpression(this.createVariable(key, true));
            token.withTrue(StringCondition.create(tokenPart.toString()));
            child = token;
            parent.with(child);
            buffer.skip();
            start = buffer.position();
        }
        if ((end = buffer.position()) - start > 0) {
            String token = buffer.substring(start, end);
            if (token.startsWith("#")) {
                token = token.substring(1);
                if (stopWords != null) {
                    for (String stopword : stopWords) {
                        if (!token.equalsIgnoreCase(stopword)) continue;
                        return parent;
                    }
                }
            }
            if (isExpression) {
                if (buffer.charAt(start) == '{') {
                    VariableCondition.create(token, isExpression);
                } else {
                    child = VariableCondition.create(token, false);
                }
            } else {
                child = StringCondition.create(token);
            }
            if (parent.size() == 0) {
                return child;
            }
            parent.with(child);
        }
        if (parent.size() < 1) {
            if (end - start == 0) {
                return StringCondition.create(buffer.substring(start, end + 1));
            }
            return null;
        }
        if (parent.size() == 1) {
            return parent.first();
        }
        return parent;
    }

    private VariableCondition createVariable(CharSequence value, boolean expression) {
        VariableCondition condition = VariableCondition.create(value, expression);
        this.variables.add(value.toString());
        return condition;
    }

    public Template withTemplate(String ... template) {
        CharacterBuffer sb = new CharacterBuffer();
        if (template == null) {
            this.setValue(sb);
        } else if (template.length == 1) {
            sb.with(template[0], "\r\n");
            this.setValue(sb);
        } else {
            sb.with(template[0]);
            for (int i = 1; i < template.length; ++i) {
                if (template[i].startsWith("{{#")) {
                    sb.with(template[i]);
                    continue;
                }
                sb.with("\r\n" + template[i]);
            }
            sb.with("\r\n");
            this.setValue(sb);
        }
        return this;
    }

    protected void setValue(CharSequence value) {
        this.token.withTemplate(new StringCondition().withValue(value));
    }

    public Template withCondition(CharSequence condition) {
        this.token.withCondition(new StringCondition().withValue(condition));
        return this;
    }

    public Template withImport(String item) {
        this.imports.add(item);
        return this;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Template withType(int type) {
        this.setType(type);
        return this;
    }

    public SimpleList<String> getVariables() {
        return this.variables;
    }

    public String toString() {
        return this.type + ": " + this.name;
    }

    public String getName() {
        return this.name;
    }
}

