/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.gui;

import de.uniks.networkparser.DateTimeEntity;
import de.uniks.networkparser.EntityValueFactory;
import de.uniks.networkparser.Style;
import de.uniks.networkparser.gui.CellHandler;
import de.uniks.networkparser.gui.FieldTyp;
import de.uniks.networkparser.gui.TableCellValue;
import de.uniks.networkparser.interfaces.GUIPosition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorNoIndex;
import java.util.Comparator;

public class Column
implements SendableEntityCreatorNoIndex {
    public static final int AUTOWIDTH = -1;
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_STYLE = "style";
    public static final String PROPERTY_ACTIVESTYLE = "activeStyle";
    public static final String PROPERTY_ATTRIBUTE = "attribute";
    public static final String PROPERTY_NUMBERFORMAT = "numberformat";
    public static final String PROPERTY_EDITCOLUMN = "editColumn";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_DEFAULTTEXT = "defaulttext";
    public static final String PROPERTY_RESIZE = "resize";
    public static final String PROPERTY_VISIBLE = "visible";
    public static final String PROPERTY_MOVABLE = "movable";
    public static final String PROPERTY_ALTTEXT = "altText";
    public static final String PROPERTY_BROWSERID = "browserid";
    public static final String PROPERTY_FIELDTYP = "fieldTyp";
    public static final String FORMAT_DATE = "HH:MM:SS";
    private static final String[] properties = new String[]{"id", "attribute", "numberformat", "editColumn", "label", "defaulttext", "resize", "visible", "movable", "altText", "browserid", "fieldTyp", "style", "activeStyle"};
    private Style style;
    private String id;
    private Style activestyle;
    private String attrName;
    private String numberFormat;
    private boolean isEditable = false;
    private String label;
    private String defaultText;
    private boolean isResizable = true;
    private boolean isVisible = true;
    private boolean isMovable = true;
    private String altAttribute;
    private FieldTyp fieldTyp;
    private GUIPosition browserId = GUIPosition.CENTER;
    protected CellHandler handler;
    private Comparator<TableCellValue> comparator;

    public String getId() {
        return this.id;
    }

    public Column withID(String id) {
        this.id = id;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelOrAttrName() {
        if (this.label == null) {
            return this.attrName;
        }
        return this.label;
    }

    public Column withLabel(String label) {
        this.label = label;
        return this;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public Column withAttribute(String attrName) {
        this.attrName = attrName;
        return this;
    }

    public Column withAttribute(String attrName, boolean edit) {
        this.attrName = attrName;
        if (this.label == null) {
            this.label = attrName;
        }
        this.withEditable(edit);
        return this;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public Column withNumberFormat(String value) {
        this.numberFormat = value;
        return this;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public Column withEditable(boolean value) {
        this.isEditable = value;
        return this;
    }

    public boolean isResizable() {
        return this.isResizable;
    }

    public Column withResizable(boolean isResizable) {
        this.isResizable = isResizable;
        return this;
    }

    public EntityValueFactory getCellValueCreator() {
        return new EntityValueFactory();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public Column withVisible(boolean isVisible) {
        this.isVisible = isVisible;
        return this;
    }

    public Column withAltAttribute(String altAttribute) {
        this.altAttribute = altAttribute;
        return this;
    }

    public String getAltAttribute() {
        return this.altAttribute;
    }

    public boolean isMovable() {
        return this.isMovable;
    }

    public Column withMovable(boolean isMovable) {
        this.isMovable = isMovable;
        return this;
    }

    public GUIPosition getBrowserId() {
        return this.browserId;
    }

    public Column withBrowserId(GUIPosition browserId) {
        this.browserId = browserId;
        return this;
    }

    public FieldTyp getFieldTyp() {
        return this.fieldTyp;
    }

    public Column withFieldTyp(FieldTyp fieldTyp) {
        this.fieldTyp = fieldTyp;
        return this;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public Column withDefaultText(String defaultText) {
        this.defaultText = defaultText;
        return this;
    }

    public Style getStyle() {
        return this.style;
    }

    public Style getOrCreateStyle() {
        if (this.style == null) {
            this.style = new Style();
        }
        return this.style;
    }

    public Column withStyle(Style value) {
        this.style = value;
        return this;
    }

    public Style getActiveStyle() {
        return this.activestyle;
    }

    public Column withActiveStyle(Style activestyle) {
        this.activestyle = activestyle;
        return this;
    }

    public Column withActionHandler(CellHandler handler) {
        this.handler = handler;
        return this;
    }

    public CellHandler getListener() {
        if (this.handler == null) {
            this.handler = new CellHandler(){

                @Override
                public boolean onAction(Object entity, SendableEntityCreator creator, double x, double y) {
                    return Column.this.isEditable;
                }
            };
        }
        return this.handler;
    }

    public boolean isListener() {
        return this.handler != null;
    }

    public Comparator<TableCellValue> getComparator() {
        return this.comparator;
    }

    public Column withComparator(Comparator<TableCellValue> comparator) {
        this.comparator = comparator;
        return this;
    }

    public Column withComboValue(String value) {
        if (this.numberFormat == null || !this.numberFormat.startsWith("[") || this.numberFormat.length() == 2) {
            this.numberFormat = "[" + value + "]";
            return this;
        }
        this.numberFormat = this.numberFormat.substring(0, this.numberFormat.length() - 1) + "," + value + "]";
        return this;
    }

    @Override
    public String[] getProperties() {
        return properties;
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new Column();
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        int pos = attribute.indexOf(".");
        String attrName = pos > 0 ? attribute.substring(0, pos) : attribute;
        Column that = (Column)entity;
        if (attrName.equalsIgnoreCase(PROPERTY_ATTRIBUTE)) {
            return that.getAttrName();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_ID)) {
            return that.getId();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_NUMBERFORMAT)) {
            return that.getNumberFormat();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_EDITCOLUMN)) {
            return that.isEditable();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_LABEL)) {
            return that.getLabel();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_DEFAULTTEXT)) {
            return that.getDefaultText();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_STYLE)) {
            return that.getStyle();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_ACTIVESTYLE)) {
            return that.getActiveStyle();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_RESIZE)) {
            return that.isResizable();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_VISIBLE)) {
            return that.isVisible();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_MOVABLE)) {
            return that.isMovable();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_ALTTEXT)) {
            return that.getAltAttribute();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_BROWSERID)) {
            return that.getBrowserId();
        }
        if (attrName.equalsIgnoreCase(PROPERTY_FIELDTYP)) {
            return that.getFieldTyp();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        Column that = (Column)entity;
        if (attribute.equalsIgnoreCase(PROPERTY_ATTRIBUTE)) {
            that.withAttribute((String)value);
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_ID)) {
            that.withID((String)value);
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_NUMBERFORMAT)) {
            that.withNumberFormat((String)value);
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_EDITCOLUMN)) {
            that.withEditable((Boolean)value);
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_LABEL)) {
            that.withLabel((String)value);
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_DEFAULTTEXT)) {
            that.withDefaultText((String)value);
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_STYLE)) {
            if (value instanceof Style) {
                Style style = (Style)value;
                Style oldStyle = that.getStyle();
                if ("merge".equals(type) && oldStyle != null) {
                    for (String prop : style.getProperties()) {
                        if (oldStyle.getValue(oldStyle, prop) != null) continue;
                        oldStyle.setValue(oldStyle, prop, style.getValue(style, prop), "new");
                    }
                } else {
                    that.withStyle((Style)value);
                }
            } else {
                System.out.println("FIXME");
            }
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_ACTIVESTYLE)) {
            that.withActiveStyle((Style)value);
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_RESIZE)) {
            that.withResizable((Boolean)value);
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_VISIBLE)) {
            that.withVisible((Boolean)value);
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_MOVABLE)) {
            that.withMovable((Boolean)value);
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_ALTTEXT)) {
            that.withAltAttribute((String)value);
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_BROWSERID)) {
            that.withBrowserId(GUIPosition.valueOf((String)value));
            return true;
        }
        if (attribute.equalsIgnoreCase(PROPERTY_FIELDTYP)) {
            that.withFieldTyp(FieldTyp.valueOf("" + value));
            return true;
        }
        return false;
    }

    public Object getValue(Object entity, SendableEntityCreator creator) {
        String attrName = this.getAttrName();
        if (attrName != null) {
            if (attrName.startsWith("\"")) {
                return attrName.substring(1, attrName.length() - 1);
            }
            if (creator != null) {
                Object value = creator.getValue(entity, attrName);
                if (this.getNumberFormat() != null && value instanceof Long) {
                    DateTimeEntity item = new DateTimeEntity();
                    item.withValue((Long)value);
                    return item.toString(this.getNumberFormat());
                }
                return value;
            }
        } else if ("CLAZZ".equals(this.getNumberFormat()) && entity != null) {
            return entity.getClass().getSimpleName();
        }
        return null;
    }

    public boolean setValue(Object controll, Object entity, SendableEntityCreator creator, Object value) {
        if (creator == null) {
            return false;
        }
        return creator.setValue(entity, this.getAttrName(), value, "upd");
    }

    public Column withListener(CellHandler eventHandler) {
        this.handler = eventHandler;
        return this;
    }
}

