/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import java.util.ArrayList;

public class GraphOptions {
    private TYP display;
    private LINETYP lineTyp;
    private Boolean raster;
    private String canvasid;
    private Boolean clearCanvas;
    private Integer fontSize;
    private String fontFamily;
    private String rank;
    private Integer nodeSep;
    private Boolean infobox;
    private Boolean cardinalityInfo;
    private Boolean propertyInfo;
    private Boolean rotateText;
    private ArrayList<TYP> buttons;

    public JsonObject getJson() {
        JsonObject result = new JsonObject();
        result.withKeyValue("display", (Object)this.display);
        result.withKeyValue("raster", (Object)this.raster);
        result.withKeyValue("canvasid", (Object)this.canvasid);
        result.withKeyValue("fontSize", (Object)this.fontSize);
        result.withKeyValue("fontFamily", (Object)this.fontFamily);
        result.withKeyValue("rank", (Object)this.rank);
        result.withKeyValue("nodeSep", (Object)this.nodeSep);
        result.withKeyValue("infobox", (Object)this.infobox);
        result.withKeyValue("cardinalityInfo", (Object)this.cardinalityInfo);
        result.withKeyValue("propertyinfo", (Object)this.propertyInfo);
        result.withKeyValue("rotatetext", (Object)this.rotateText);
        result.withKeyValue("linetyp", (Object)this.lineTyp);
        if (this.buttons != null) {
            result.withKeyValue("buttons", new JsonArray().with(this.buttons));
        }
        return result;
    }

    public Boolean getRaster() {
        return this.raster;
    }

    public GraphOptions withRaster(Boolean value) {
        this.raster = value;
        return this;
    }

    public String getCanvasid() {
        return this.canvasid;
    }

    public GraphOptions withCanvasid(String value) {
        this.canvasid = value;
        return this;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public GraphOptions withFontSize(Integer value) {
        this.fontSize = value;
        return this;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public GraphOptions withFontFamily(String value) {
        this.fontFamily = value;
        return this;
    }

    public String getRank() {
        return this.rank;
    }

    public GraphOptions withRank(String value) {
        this.rank = value;
        return this;
    }

    public Integer getNodeSep() {
        return this.nodeSep;
    }

    public GraphOptions withNodeSep(Integer value) {
        this.nodeSep = value;
        return this;
    }

    public Boolean getInfobox() {
        return this.infobox;
    }

    public GraphOptions withInfobox(Boolean value) {
        this.infobox = value;
        return this;
    }

    public Boolean getCardinalityInfo() {
        return this.cardinalityInfo;
    }

    public GraphOptions withCardinalityInfo(Boolean value) {
        this.cardinalityInfo = value;
        return this;
    }

    public Boolean getPropertyInfo() {
        return this.propertyInfo;
    }

    public GraphOptions withPropertyInfo(Boolean value) {
        this.propertyInfo = value;
        return this;
    }

    public ArrayList<TYP> getButtons() {
        return this.buttons;
    }

    public GraphOptions withButton(TYP ... values) {
        if (values == null) {
            return this;
        }
        if (this.buttons == null) {
            this.buttons = new ArrayList();
        }
        for (TYP item : values) {
            this.buttons.add(item);
        }
        return this;
    }

    public TYP getDisplay() {
        return this.display;
    }

    public GraphOptions withDisplay(TYP value) {
        this.display = value;
        return this;
    }

    public Boolean getRotateText() {
        return this.rotateText;
    }

    public GraphOptions withRotateText(Boolean value) {
        this.rotateText = value;
        return this;
    }

    public LINETYP getLineTyp() {
        return this.lineTyp;
    }

    public GraphOptions withLineTyp(LINETYP value) {
        this.lineTyp = value;
        return this;
    }

    public Boolean getClearCanvas() {
        return this.clearCanvas;
    }

    public GraphOptions withClearCanvas(Boolean clearCanvas) {
        this.clearCanvas = clearCanvas;
        return this;
    }

    public static enum LINETYP {
        CENTER,
        SQUARE;

    }

    public static enum RANK {
        LR,
        TB;

    }

    public static enum TYP {
        HTML,
        CANVAS,
        SVG,
        PDF;

    }
}

