/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.Literal;
import de.uniks.networkparser.graph.util.AssociationSet;
import de.uniks.networkparser.graph.util.AttributeSet;
import de.uniks.networkparser.graph.util.ClazzSet;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;

public abstract class GraphModel
extends GraphEntity
implements BaseItem {
    public static final String DEFAULTPACKAGE2 = "i.love.networkparser";
    public static final String PROPERTY_CLAZZ = "clazz";
    private String defaultAuthorName;
    protected String genPath;

    public ClazzSet getClazzes(Condition<?> ... filters) {
        ClazzSet collection = new ClazzSet();
        if (this.children == null) {
            return collection;
        }
        if (this.children instanceof Clazz) {
            collection.add((Clazz)this.children);
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet items = (GraphSimpleSet)this.children;
            for (GraphMember child : items) {
                if (!(child instanceof Clazz) || !this.check(child, filters)) continue;
                collection.add((Clazz)child);
            }
        }
        return collection;
    }

    @Override
    public Object getValue(String attribute) {
        if (PROPERTY_CLAZZ.equalsIgnoreCase(attribute)) {
            return this.getClazzes(new Condition[0]);
        }
        if ("packageName".equalsIgnoreCase(attribute)) {
            return this.getName(false);
        }
        return super.getValue(attribute);
    }

    protected boolean clearAddOnClazzes() {
        if (this.children == null) {
            return true;
        }
        if (!(this.children instanceof GraphSimpleSet)) {
            Clazz clazz;
            if (this.children instanceof Clazz && ("creator".equals((clazz = (Clazz)this.children).getType()) || "pattern".equals(clazz.getType()) || "set".equals(clazz.getType()))) {
                clazz.setParentNode(null);
                this.children = null;
            }
            return true;
        }
        GraphSimpleSet list = (GraphSimpleSet)this.children;
        for (GraphMember member : list) {
            Clazz clazz;
            if (!(member instanceof Clazz) || !"creator".equals((clazz = (Clazz)member).getType()) && !"pattern".equals(clazz.getType()) && !"set".equals(clazz.getType())) continue;
            clazz.setParentNode(null);
            list.remove(member);
        }
        return true;
    }

    public Clazz createClazz(String name) {
        if (name == null || this.children == null || this.children instanceof Clazz && name.equals(((Clazz)this.children).getName())) {
            Clazz clazz = new Clazz(name);
            clazz.setClassModel(this);
            return clazz;
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet items = (GraphSimpleSet)this.children;
            for (GraphMember child : items) {
                Clazz clazz;
                if (!(child instanceof Clazz) || !name.equals((clazz = (Clazz)child).getName())) continue;
                return clazz;
            }
        }
        Clazz clazz = new Clazz(name);
        clazz.setClassModel(this);
        return clazz;
    }

    @Override
    public GraphModel with(String name) {
        super.with(name);
        return this;
    }

    public String getAuthorName() {
        return this.defaultAuthorName;
    }

    public boolean setAuthorName(String value) {
        if (value != null && !value.equals(this.defaultAuthorName) || value == null && this.defaultAuthorName != null) {
            this.defaultAuthorName = value;
            return true;
        }
        return false;
    }

    public GraphModel generate() {
        return this;
    }

    public GraphModel generate(String rootDir) {
        return this;
    }

    public boolean dumpHTML(String diagramName) {
        return false;
    }

    public boolean fixClassModel() {
        String className;
        Clazz[] classes = this.getClazzes(new Condition[0]).toArray(new Clazz[this.getClazzes(new Condition[0]).size()]);
        SimpleSet<Clazz> visited = new SimpleSet<Clazz>();
        String packageName = null;
        for (Clazz item : classes) {
            className = item.getName();
            if (className != null && className.indexOf(46) > 0) {
                if (packageName == null) {
                    packageName = className.substring(0, className.lastIndexOf("."));
                } else if (!className.startsWith(packageName)) {
                    packageName = "";
                }
            }
            this.fixClassModel(item, visited);
        }
        if (this.getDefaultPackage().equals(this.name) && packageName != null && packageName.length() > 0) {
            this.name = packageName;
            packageName = packageName + ".";
            for (Clazz item : classes) {
                className = item.getName();
                if (className == null || !className.startsWith(packageName)) continue;
                item.setName(className.substring(packageName.length()));
            }
        }
        return true;
    }

    public String getDefaultPackage() {
        return DEFAULTPACKAGE2;
    }

    private void fixClassModel(Clazz item, SimpleSet<Clazz> visited) {
        AssociationSet assocs = item.getAssociations(new Condition[0]);
        for (Association role : assocs) {
            item.repairAssociation(role);
            Clazz clazz = role.getOtherClazz();
            if (clazz.getClassModel() == null) {
                clazz.setClassModel(this);
                if (visited.add(clazz)) {
                    this.fixClassModel(clazz, visited);
                }
            }
            this.with(role);
        }
        if ("enum".equals(item.getType())) {
            SimpleSet<Literal> literals = item.getValues();
            AttributeSet attributes = item.getAttributes(new Condition[0]);
            for (Literal literal : literals) {
                int no = 0;
                SimpleList<Object> values = literal.getValues();
                if (values == null) continue;
                for (Object v : values) {
                    if (v != null) {
                        Attribute attribute;
                        String type = v.getClass().getName();
                        if (attributes.size() > no) {
                            attribute = (Attribute)attributes.get(no);
                            if (!attribute.getType().getName(false).equals(type)) {
                                attribute.with(DataType.OBJECT);
                            }
                        } else {
                            attribute = new Attribute("value" + no, DataType.create(type));
                            attributes.add(attribute);
                            item.with(attribute);
                        }
                    }
                    ++no;
                }
            }
        }
    }

    protected GraphModel with(GraphModel model) {
        if (model == null) {
            return this;
        }
        GraphSimpleSet allChildren = model.getChildren();
        for (GraphMember child : allChildren) {
            this.withChildren(child);
        }
        if (this.defaultAuthorName == null) {
            this.defaultAuthorName = model.getAuthorName();
        }
        return this;
    }

    @Override
    public String toString(Converter converter) {
        if (converter == null) {
            return null;
        }
        return converter.encode(this);
    }

    @Override
    public int size() {
        if (this.children == null) {
            return 0;
        }
        if (this.children instanceof GraphSimpleSet) {
            return ((GraphSimpleSet)this.children).size();
        }
        return 1;
    }
}

