/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.story;

import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.story.JacocoColumnListener;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.util.Collection;
import java.util.Comparator;

public class JacocoColumn
implements JacocoColumnListener {
    private static final String COLUMRENDERER = "org.jacoco.report.internal.html.table.IColumnRenderer";
    private static final String PACKAGE = "PACKAGE";
    private static final String BUNDLE = "BUNDLE";
    private static final String SOURCEFILE = "SOURCEFILE";
    private static final String METHOD = "METHOD";
    private Object proxy;
    private static String EMPTY = "";
    private SimpleKeyValueList<String, Integer> value = new SimpleKeyValueList();
    private SimpleKeyValueList<Object, String> classes = new SimpleKeyValueList();

    public static JacocoColumn create() {
        JacocoColumn jacocoColumn = new JacocoColumn();
        Class<?> proxyClass = ReflectionLoader.getClass(COLUMRENDERER);
        if (proxyClass == null) {
            System.out.println("NO JACOCO FOUND ON BUILD-PATH");
            return null;
        }
        Object item = ReflectionLoader.createProxy(jacocoColumn, proxyClass);
        jacocoColumn.withProxy(item);
        return jacocoColumn;
    }

    private JacocoColumn withProxy(Object item) {
        this.proxy = item;
        return this;
    }

    public Object getProxy() {
        return this.proxy;
    }

    public String getType(Object element) {
        Object call = ReflectionLoader.calling(element, "getElementType", false, null, new Object[0]);
        if (call != null) {
            return call.toString();
        }
        return EMPTY;
    }

    public String getName(Object element) {
        Object call = ReflectionLoader.calling(element, "getName", false, null, new Object[0]);
        if (call instanceof String) {
            return (String)call;
        }
        return EMPTY;
    }

    @Override
    public boolean init(Object items, Object total) {
        String type = this.getType(total);
        if (PACKAGE.equalsIgnoreCase(type)) {
            Collection classes = (Collection)ReflectionLoader.call(total, "getClasses", new Object[0]);
            for (Object item : classes) {
                String name = this.getName(item);
                Collection methods = (Collection)ReflectionLoader.call(item, "getMethods", new Object[0]);
                for (Object method : methods) {
                    this.classes.add(method, name);
                }
            }
        }
        return true;
    }

    @Override
    public void footer(Object td, Object total, Object resources, Object base) {
        String search = this.getSearch(total);
        Integer no = (Integer)this.value.getValue(search);
        if (no != null) {
            this.setText(td, "" + no);
        } else {
            this.setText(td, "0");
        }
    }

    public void setText(Object item, String text) {
        ReflectionLoader.calling(item, "text", false, null, text);
    }

    private String getSearch(Object node) {
        int pos;
        String search = this.getName(node);
        if (BUNDLE.equalsIgnoreCase(this.getType(node))) {
            search = "";
        }
        if ((pos = search.indexOf("(")) > 0) {
            search = search.substring(0, pos);
        }
        if ((pos = search.indexOf("$")) > 0) {
            search = search.substring(0, pos);
        }
        return search;
    }

    public void addValueToList(String key, int no) {
        String fullClass = key.substring(0, key.indexOf(":"));
        this.addToPos("", no);
        int pos = fullClass.lastIndexOf(".");
        if (pos > 0) {
            this.addToPos(fullClass.substring(0, pos), no);
        }
        this.addToPos(fullClass, no);
        this.value.add(key, no);
    }

    private void addToPos(String key, int no) {
        int pos = this.value.indexOf(key);
        if (pos > 0) {
            Integer oldValue = this.value.getValueByIndex(pos);
            this.value.put(key, oldValue + no);
            return;
        }
        this.value.add(key, no);
    }

    @Override
    public void item(Object td, Object item, Object resources, Object base) {
        Object node = ReflectionLoader.calling(item, "getNode", false, null, new Object[0]);
        String type = this.getType(node);
        if (SOURCEFILE.equalsIgnoreCase(type)) {
            int pos;
            String name = this.getName(node);
            String search = name.substring(0, pos = name.lastIndexOf("."));
            Object value = this.value.getValue(search);
            if (value != null) {
                this.setText(td, "" + value);
            }
            return;
        }
        if (METHOD.equalsIgnoreCase(type)) {
            String search;
            Object value;
            String className = this.classes.get(node);
            Integer firstLine = (Integer)ReflectionLoader.call(node, "getFirstLine", new Object[0]);
            String name = this.getName(node);
            if (name.indexOf("(") > 0) {
                name = name.substring(0, name.indexOf("("));
            }
            if ((value = this.value.getValue(search = className + ":" + name + ":" + firstLine)) instanceof Integer) {
                Integer no = (Integer)value;
                this.setText(td, no.toString());
            }
            return;
        }
        String search = this.getSearch(node);
        Object value = this.value.getValue(search);
        if (value != null) {
            this.setText(td, "" + value);
        }
    }

    @Override
    public Comparator<Object> getComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return 1;
            }
        };
    }
}

