/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf.proxy;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.ext.petaf.FileWatcher;
import de.uniks.networkparser.ext.petaf.Message;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.messages.ChangeMessage;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyModel;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.interfaces.ObjectCondition;

public class NodeProxyFileSystem
extends NodeProxy {
    private String fileName;
    private FileWatcher nodeProxyFileWatcher;
    private boolean fullModell;

    public void enableGitFilter() {
        this.withFilter(new ObjectCondition(){

            @Override
            public boolean update(Object value) {
                return true;
            }
        });
    }

    NodeProxyFileSystem() {
        this.withOnline(true);
    }

    public NodeProxyFileSystem(String fileName) {
        if (fileName != null) {
            this.fileName = fileName;
            this.withOnline(true);
        }
    }

    public boolean startModelDistribution() {
        this.withFullModell(false);
        return this.space.startModelDistribution(true);
    }

    public boolean isFullModell() {
        return this.fullModell;
    }

    public NodeProxyFileSystem withFullModell(boolean value) {
        this.fullModell = value;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    protected boolean sending(Message msg) {
        boolean result = super.sending(msg);
        if (this.space == null) {
            return false;
        }
        try {
            FileBuffer file = new FileBuffer();
            file.withFile(this.fileName);
            file.createFile();
            int len = 0;
            if (this.fullModell) {
                NodeProxyModel model = this.getSpace().getModel();
                Object modell = model.getModel();
                BaseItem value = this.space.encode(modell, null);
                String data = value.toString();
                len = data.length();
                file.write(FileBuffer.OVERRIDE, data);
            } else if (msg != null) {
                String data = this.space.convertMessage(msg) + "\r\n";
                len = data.length();
                file.write(FileBuffer.APPEND, data);
            }
            this.setSendTime(len);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public BaseItem load(Object root) {
        IdMap map;
        BaseItem readBaseFile = FileBuffer.readBaseFile(this.fileName);
        if (this.space != null && readBaseFile != null && (map = this.space.getMap()) != null) {
            if (this.isFullModell()) {
                this.space.withInit(false);
                Object model = map.decode(readBaseFile, root, null);
                this.space.withInit(true);
                this.space.createModel(model);
                return readBaseFile;
            }
            if (readBaseFile instanceof EntityList) {
                try {
                    EntityList list = (EntityList)readBaseFile;
                    for (int i = 0; i < list.sizeChildren(); ++i) {
                        BaseItem singleMessage = list.getChild(i);
                        Object message = map.decode(singleMessage);
                        if (!(message instanceof ChangeMessage)) continue;
                        ChangeMessage changeMsg = (ChangeMessage)message;
                        if (map.getObject(changeMsg.getId()) == null) {
                            Object entity = changeMsg.getEntity();
                            if (entity != null) {
                                if (entity instanceof String || entity.getClass().equals(root.getClass())) {
                                    map.put(changeMsg.getId(), root, false);
                                } else {
                                    map.put(changeMsg.getId(), changeMsg.getEntity(), false);
                                }
                            } else {
                                map.put(changeMsg.getId(), changeMsg.getEntity(), false);
                            }
                        }
                        changeMsg.withSpace(this.space);
                        changeMsg.runTask();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return readBaseFile;
            }
            this.space.withInit(false);
            Object model = map.decode(readBaseFile, root, null);
            this.space.withInit(true);
            this.space.createModel(model);
            return readBaseFile;
        }
        return readBaseFile;
    }

    @Override
    public String getKey() {
        return this.fileName;
    }

    @Override
    public boolean close() {
        this.nodeProxyFileWatcher.close();
        return true;
    }

    @Override
    protected boolean initProxy() {
        this.withType("INOUT");
        this.nodeProxyFileWatcher = new FileWatcher().init(this, this.fileName);
        return true;
    }

    @Override
    public boolean isSendable() {
        return false;
    }

    @Override
    public Object getSendableInstance(boolean reference) {
        return new NodeProxyFileSystem(null);
    }
}

