/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.converter;

import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.GraphUtil;
import de.uniks.networkparser.graph.util.AssociationSet;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;
import java.util.Iterator;

public class YUMLConverter
implements Converter {
    public static final String URL = "http://yuml.me/diagram/class/";
    public boolean defaultShowPackage;

    public String convert(GraphList root, boolean removePackage) {
        String type = root.getType();
        GraphSimpleSet collection = GraphUtil.getChildren(root);
        if (collection.size() > 0) {
            StringBuilder sb = new StringBuilder();
            SimpleList<GraphMember> visitedObj = new SimpleList<GraphMember>();
            root.initSubLinks();
            for (GraphMember item : collection) {
                this.parse(type, item, sb, visitedObj, removePackage);
            }
            return sb.toString();
        }
        return null;
    }

    public void parse(String type, GraphMember item, StringBuilder sb, SimpleList<GraphMember> visited, boolean shortName) {
        if (item instanceof GraphEntity) {
            this.parse(type, (GraphEntity)item, sb, visited, shortName);
        }
    }

    public void parse(String type, GraphEntity item, StringBuilder sb, SimpleList<GraphMember> visited, boolean shortName) {
        AssociationSet association = item.getAssociations(new Condition[0]);
        if (association.size() == 0) {
            if (!visited.contains(item)) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(this.parseEntity(item, visited, type, shortName));
            }
            return;
        }
        if (type == null) {
            type = "objectdiagram";
        }
        for (Object entry : association) {
            if (!(entry instanceof Association)) continue;
            Association element = (Association)entry;
            Association other = element.getOther();
            if ("classdiagram".equals(type) && GraphUtil.containsClazzAssociation(visited, element, other) || visited.contains(element)) continue;
            visited.add(element);
            visited.add(other);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.parseEntity(item, visited, type, shortName));
            String seperator = GraphUtil.getSeperator(element);
            sb.append(seperator);
            SimpleSet<GraphEntity> targetCollection = GraphUtil.getNodes(other);
            Iterator targetIterator = targetCollection.iterator();
            GraphEntity target = (GraphEntity)targetIterator.next();
            sb.append(this.parseEntity(target, visited, type, shortName));
            while (targetIterator.hasNext()) {
                sb.append(this.parseEntity(item, visited, type, shortName));
                sb.append(seperator);
                target = (GraphEntity)targetIterator.next();
                sb.append(this.parseEntity(target, visited, type, shortName));
            }
        }
    }

    public String parseEntity(GraphEntity entity, SimpleList<GraphMember> visited, boolean shortName) {
        return this.parseEntity(entity, visited, null, shortName);
    }

    public String parseEntity(GraphEntity entity, SimpleList<GraphMember> visited, String type, boolean shortName) {
        if (!(entity instanceof Clazz)) {
            return "";
        }
        Clazz clazzEntity = (Clazz)entity;
        boolean shortString = visited.contains(clazzEntity);
        if (!shortString) {
            visited.add(clazzEntity);
        }
        if (type == null) {
            type = "objectdiagram";
            if (clazzEntity.getName(false) == null) {
                type = "classdiagram";
            }
        }
        StringBuilder sb = new StringBuilder("[");
        if (type == "objectdiagram") {
            sb.append(clazzEntity.getId());
            sb.append(" : ");
        }
        sb.append(clazzEntity.getName(shortName));
        if (!shortString) {
            sb.append(this.parseEntityValues(clazzEntity, type, shortName));
        }
        sb.append("]");
        return sb.toString();
    }

    public String parseEntityValues(GraphEntity entity, String type, boolean shortName) {
        StringBuilder sb = new StringBuilder();
        Iterator i = GraphUtil.getChildren(entity).iterator();
        boolean second = false;
        if (i.hasNext()) {
            String splitter = "";
            if (type.equals("objectdiagram")) {
                splitter = "=";
            } else if (type.equals("classdiagram")) {
                splitter = ":";
            }
            while (i.hasNext()) {
                Object element = i.next();
                if (!(element instanceof Attribute)) continue;
                Attribute attribute = (Attribute)element;
                if (second) {
                    sb.append(";");
                }
                second = true;
                sb.append(attribute.getName() + splitter + attribute.getValue(type, shortName));
            }
        }
        if (sb.length() > 0) {
            return "|" + sb.toString();
        }
        return sb.toString();
    }

    @Override
    public String encode(BaseItem entity) {
        if (entity instanceof GraphList) {
            return this.convert((GraphList)entity, this.defaultShowPackage);
        }
        return null;
    }
}

