/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.list;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.list.SimpleList;

public class NumberList
extends SimpleList<Number> {
    public double sum() {
        double result = 0.0;
        for (Number x : this) {
            result += x.doubleValue();
        }
        return result;
    }

    public double max() {
        double max = Double.MIN_VALUE;
        for (Number x : this) {
            if (!(x.doubleValue() > max)) continue;
            max = x.doubleValue();
        }
        return max;
    }

    public double min() {
        double min = Double.MAX_VALUE;
        for (Number x : this) {
            if (!(x.doubleValue() < min)) continue;
            min = x.doubleValue();
        }
        return min;
    }

    public double middle() {
        double middleValue = 0.0;
        for (Number x : this) {
            middleValue += x.doubleValue();
        }
        if (this.size() > 0) {
            middleValue /= (double)this.size();
        }
        return middleValue;
    }

    public String toString(String seperator) {
        if (this.size < 1) {
            return "";
        }
        CharacterBuffer buf = new CharacterBuffer();
        buf.with(((Number)this.get(0)).toString());
        for (int i = 1; i < this.size; ++i) {
            buf.with(seperator);
            buf.with(((Number)this.get(i)).toString());
        }
        return buf.toString();
    }
}

