/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.gui;

import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.Pos;
import de.uniks.networkparser.gui.TileObject;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.SendableEntityCreatorTag;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.xml.MapEntityStack;
import de.uniks.networkparser.xml.XMLEntity;
import de.uniks.networkparser.xml.XMLTokener;

public class TileMap
implements SendableEntityCreatorTag {
    public static final String ENCODING = "encoding";
    public static final String TAG = "map";
    public static final String VERSION = "version";
    public static final String ORIENTATION = "orientation";
    public static final String RENDERORDER = "renderorder";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String TILEWIDTH = "tilewidth";
    public static final String TILEHEIGHT = "tileheight";
    public static final String TILESET_TILE = "tileset";
    public static final String TILESET_LAYER = "layer";
    public static final String TILESET_OBJECTGROUP = "objectgroup";
    public String version;
    public String orientation;
    public String renderorder;
    public int width;
    public int height;
    public int tilewidth;
    public int tileheight;
    private SimpleList<TileObject> images = new SimpleList();
    public SimpleKeyValueList<String, SimpleList<TileObject>> objects = new SimpleKeyValueList();
    public int[] background;
    public SimpleList<String> backgroundNames = new SimpleList();
    private String path = "";

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new TileMap();
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String[] getProperties() {
        return new String[]{VERSION, ORIENTATION, RENDERORDER, WIDTH, HEIGHT, TILEWIDTH, TILEHEIGHT, TILESET_TILE, TILESET_LAYER, TILESET_OBJECTGROUP};
    }

    public Pos getSpriteBackgroundPos(int ebene, int backgroundPos) {
        int spritePos = 0;
        if (this.background != null) {
            spritePos = this.background[backgroundPos];
        }
        return this.getSpritePos(ebene, spritePos);
    }

    public Pos getSpritePos(int ebene, int pos) {
        Pos result = new Pos();
        TileObject tileObject = (TileObject)this.images.get(ebene);
        int columns = tileObject.width / this.tileheight;
        result.y = pos / columns;
        result.x = pos - result.y * columns - 1;
        return result;
    }

    public int getBackground(int sprite) {
        if (sprite < 0 || sprite >= this.background.length) {
            return 0;
        }
        return this.background[sprite];
    }

    public Pos getPos(int sprite) {
        Pos pos = new Pos();
        pos.y = sprite / this.width;
        pos.x = sprite - pos.y * this.width;
        return pos;
    }

    public int length() {
        if (this.background == null) {
            return 0;
        }
        return this.background.length;
    }

    public SimpleList<TileObject> getByName(String element) {
        return this.objects.get(element);
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (!(entity instanceof TileMap)) {
            return null;
        }
        TileMap map = (TileMap)entity;
        if (VERSION.equalsIgnoreCase(attribute)) {
            return map.version;
        }
        if (ORIENTATION.equalsIgnoreCase(attribute)) {
            return map.orientation;
        }
        if (RENDERORDER.equalsIgnoreCase(attribute)) {
            return map.renderorder;
        }
        if (WIDTH.equalsIgnoreCase(attribute)) {
            return map.width;
        }
        if (HEIGHT.equalsIgnoreCase(attribute)) {
            return map.height;
        }
        if (TILEWIDTH.equalsIgnoreCase(attribute)) {
            return map.tilewidth;
        }
        if (TILEHEIGHT.equalsIgnoreCase(attribute)) {
            return map.tileheight;
        }
        if ("source".equalsIgnoreCase(attribute)) {
            if (map.images.size() > 0) {
                return ((TileObject)map.images.first()).name;
            }
            return null;
        }
        if (WIDTH.equalsIgnoreCase(attribute)) {
            if (map.images.size() > 0) {
                return ((TileObject)map.images.first()).width;
            }
            return null;
        }
        if (HEIGHT.equalsIgnoreCase(attribute)) {
            if (map.images.size() > 0) {
                return ((TileObject)map.images.first()).height;
            }
            return null;
        }
        if (TILESET_TILE.equalsIgnoreCase(attribute)) {
            if (map.images.size() < 1) {
                return null;
            }
            XMLEntity tileset = XMLEntity.TAG(TILESET_TILE);
            for (TileObject image : map.images) {
                tileset.add("firstgid", image.gid);
                if (image.name != "") {
                    tileset.add("name", image.name);
                }
                tileset.add(TILEWIDTH, map.tilewidth);
                tileset.add(TILEHEIGHT, map.tileheight);
                tileset.add("tilecount", image.count);
                tileset.add("columns", image.width / map.tileheight);
                XMLEntity imageXML = tileset.createChild("image");
                imageXML.add("source", image.source);
                imageXML.add(WIDTH, image.width);
                imageXML.add(HEIGHT, image.height);
            }
            return tileset;
        }
        if (TILESET_LAYER.equalsIgnoreCase(attribute)) {
            if (map.background == null) {
                return null;
            }
            XMLEntity layer = XMLEntity.TAG(TILESET_LAYER);
            layer.withKeyValue("name", "Background");
            layer.withKeyValue(WIDTH, map.width);
            layer.withKeyValue(HEIGHT, map.height);
            XMLEntity data = layer.createChild("data");
            data.withKeyValue(ENCODING, "csv");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < map.background.length; ++i) {
                sb.append(map.background[i]);
                if (i < map.background.length - 1) {
                    sb.append(",");
                }
                if (i % 10 != 9) continue;
                sb.append("\r\n");
            }
            data.withValue(sb.toString());
            return layer;
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        XMLEntity data;
        XMLEntity layer;
        if (!(entity instanceof TileMap)) {
            return false;
        }
        TileMap map = (TileMap)entity;
        if (VERSION.equalsIgnoreCase(attribute)) {
            map.version = "" + value;
            return true;
        }
        if (ORIENTATION.equalsIgnoreCase(attribute)) {
            map.orientation = "" + value;
            return true;
        }
        if (RENDERORDER.equalsIgnoreCase(attribute)) {
            map.renderorder = "" + value;
            return true;
        }
        if (WIDTH.equalsIgnoreCase(attribute)) {
            map.width = Integer.valueOf("" + value);
            return true;
        }
        if (HEIGHT.equalsIgnoreCase(attribute)) {
            map.height = Integer.valueOf("" + value);
            return true;
        }
        if (TILEWIDTH.equalsIgnoreCase(attribute)) {
            map.tilewidth = Integer.valueOf("" + value);
            return true;
        }
        if (TILEHEIGHT.equalsIgnoreCase(attribute)) {
            map.tileheight = Integer.valueOf("" + value);
            return true;
        }
        if (TILESET_TILE.equalsIgnoreCase(attribute)) {
            XMLEntity tileSet = (XMLEntity)value;
            if (tileSet.sizeChildren() == 1) {
                XMLEntity imageXML = (XMLEntity)tileSet.getChild(0);
                TileObject image = new TileObject();
                image.gid = tileSet.getInt("firstgid");
                image.count = tileSet.getInt("tilecount");
                image.width = imageXML.getInt(WIDTH);
                image.height = imageXML.getInt(HEIGHT);
                image.source = imageXML.getString("source");
                image.name = imageXML.getString("name");
                map.images.add(image);
            }
            return true;
        }
        if (TILESET_LAYER.equalsIgnoreCase(attribute) && (layer = (XMLEntity)value).sizeChildren() == 1 && "csv".equals((data = (XMLEntity)layer.getChild(0)).get(ENCODING))) {
            String number;
            String text = data.getValue();
            int i = 0;
            int start = 0;
            int z = 0;
            map.background = new int[map.width * map.height];
            while (i < text.length()) {
                if (text.charAt(i) != ',') {
                    ++i;
                    continue;
                }
                number = text.substring(start, i);
                map.background[z++] = Integer.valueOf(number.trim());
                start = ++i;
            }
            number = text.substring(start, i);
            map.background[z] = Integer.valueOf(number.trim());
            return true;
        }
        if (TILESET_OBJECTGROUP.equalsIgnoreCase(attribute)) {
            SimpleList<TileObject> objects;
            XMLEntity objectGroup = (XMLEntity)value;
            String tag = objectGroup.getString("name");
            if (tag == null || tag.length() < 1) {
                tag = "element";
            }
            if ((objects = this.objects.get(tag)) == null) {
                objects = new SimpleList();
                this.objects.put(tag, objects);
            }
            for (int i = 0; i < objectGroup.size(); ++i) {
                BaseItem item = objectGroup.getChild(i);
                objects.add(TileObject.create((Entity)item));
            }
            return true;
        }
        return false;
    }

    public static TileMap create(String value) {
        TileMap entity = new TileMap();
        String tag = entity.getTag();
        MapEntity map = new MapEntity(null);
        map.withStack(new MapEntityStack().withStack(tag, entity, entity));
        XMLTokener tokener = new XMLTokener();
        tokener.withBuffer(value);
        tokener.skipHeader();
        tokener.skipTo(' ', false);
        tokener.parse(tokener, map);
        return entity;
    }

    public String getSource() {
        if (this.images.size() > 0) {
            return ((TileObject)this.images.first()).name;
        }
        return null;
    }

    public TileMap withPath(String value) {
        this.path = value;
        return this;
    }

    public String getPath() {
        return this.path;
    }
}

