/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.graph.Clazz;

public class DataType {
    public static final DataType VOID = new DataType("void");
    public static final DataType INT = new DataType("int");
    public static final DataType LONG = new DataType("long");
    public static final DataType FLOAT = new DataType("float");
    public static final DataType DOUBLE = new DataType("double");
    public static final DataType STRING = new DataType("String");
    public static final DataType BOOLEAN = new DataType("boolean");
    public static final DataType OBJECT = new DataType("Object");
    public static final DataType CHAR = new DataType("char");
    public static final DataType BYTE = new DataType("byte");
    public static final DataType CONSTRUCTOR = new DataType("");
    protected Clazz value;

    DataType(String value) {
        this.value = new Clazz().with(value);
    }

    DataType(Clazz value) {
        this.value = value;
    }

    public String getName(boolean shortName) {
        return this.getInternName(shortName, true);
    }

    protected String getInternName(boolean shortName, boolean primitivAllow) {
        if (this.value == null) {
            return null;
        }
        String result = this.value.getName(shortName);
        if (primitivAllow) {
            return result;
        }
        if (!shortName || result == null || result.lastIndexOf(".") < 0) {
            return EntityUtil.convertPrimitiveToObjectType(result);
        }
        return EntityUtil.convertPrimitiveToObjectType(result.substring(result.lastIndexOf(".") + 1));
    }

    public Clazz getClazz() {
        return this.value;
    }

    public static DataType create(Object typ) {
        if (typ instanceof DataType) {
            return (DataType)typ;
        }
        if (typ instanceof Clazz) {
            return new DataType((Clazz)typ);
        }
        if (typ instanceof String) {
            return new DataType((String)typ);
        }
        if (typ instanceof Class) {
            return new DataType(new Clazz((Class)typ));
        }
        return null;
    }

    public DataType withExternal(boolean external) {
        if (this.value != null) {
            this.value.withExternal(external);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataType)) {
            return false;
        }
        if (obj.hashCode() == this.hashCode()) {
            return true;
        }
        DataType other = (DataType)obj;
        if (this.getName(false) == null) {
            return other.getName(false) == null;
        }
        return this.getName(false).equals(other.getName(false));
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        String internName = this.getInternName(false, true);
        if ("void int long double String boolean Object".indexOf(internName) >= 0) {
            return "DataType." + internName.toUpperCase();
        }
        return "DataType.create(\"" + internName + "\")";
    }
}

