/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.story;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.ext.ClassModel;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.ext.story.StoryElement;
import de.uniks.networkparser.ext.story.StoryObjectFilter;
import de.uniks.networkparser.ext.story.StoryStepCondition;
import de.uniks.networkparser.ext.story.StoryStepDiagram;
import de.uniks.networkparser.ext.story.StoryStepImage;
import de.uniks.networkparser.ext.story.StoryStepSourceCode;
import de.uniks.networkparser.ext.story.StoryStepText;
import de.uniks.networkparser.ext.story.StoryStepTitle;
import de.uniks.networkparser.ext.story.StoryUtil;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.logic.BooleanCondition;
import de.uniks.networkparser.logic.Equals;
import de.uniks.networkparser.logic.Not;
import de.uniks.networkparser.xml.HTMLEntity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Story
extends StoryElement
implements Comparable<Story> {
    private String outputFile;
    private String label;
    private SimpleList<ObjectCondition> steps = new SimpleList();
    private int counter = -1;
    private boolean breakOnAssert = true;
    private IdMap map;
    private String path = "doc/";

    public Story() {
        this.add(new StoryStepTitle());
    }

    public void add(ObjectCondition step) {
        this.steps.add(step);
    }

    public Story withPath(String value) {
        if (value == null) {
            this.path = "";
            return this;
        }
        this.path = value.endsWith("/") || value.endsWith("\\") ? value : value + "/";
        return this;
    }

    @Override
    public String getLabel() {
        if (this.label == null && this.outputFile != null) {
            int pos = this.outputFile.lastIndexOf(47);
            int temp = this.outputFile.lastIndexOf(92);
            if (temp > pos) {
                pos = temp;
            }
            if (pos >= 0) {
                this.label = this.outputFile.substring(pos + 1);
            }
        }
        return this.label;
    }

    public Story withLabel(String value) {
        this.label = value;
        return this;
    }

    public StoryStepSourceCode addSourceCode(Class<?> className, int ... position) {
        StoryStepSourceCode step = new StoryStepSourceCode();
        if (position != null) {
            int start;
            if (position.length > 0) {
                start = position[0];
                step.withStart(start);
            }
            if (position.length > 1) {
                start = position[1];
                step.withEnd(start);
            }
        }
        step.withCode(className);
        this.addSourceCodeStep(step);
        return step;
    }

    public StoryStepSourceCode addSourceCode(String rootDir, Class<?> className, String methodSignature) {
        StoryStepSourceCode step = new StoryStepSourceCode();
        step.withMethodSignature(methodSignature);
        step.withCode(rootDir, className);
        this.addSourceCodeStep(step);
        return step;
    }

    private void addSourceCodeStep(StoryStepSourceCode step) {
        StoryStepTitle titleStep;
        ObjectCondition firstStep;
        this.add(step);
        if (this.outputFile == null) {
            this.withName(step.getMethodName());
        }
        if ((firstStep = (ObjectCondition)this.steps.first()) instanceof StoryStepTitle && (titleStep = (StoryStepTitle)firstStep).getTitle() == null) {
            titleStep.setTitle(step.getMethodName());
        }
    }

    public StoryStepDiagram addDiagram(ClassModel model) {
        StoryStepDiagram step = new StoryStepDiagram();
        step.withModel(model);
        this.add(step);
        return step;
    }

    public StoryStepDiagram addDiagram(StoryObjectFilter filter) {
        StoryStepDiagram step = new StoryStepDiagram();
        step.withFilter(filter);
        this.add(step);
        return step;
    }

    public Story withName(String name) {
        if (name == null || name.length() < 1) {
            return this;
        }
        this.outputFile = name.toLowerCase().endsWith(".html") ? name : name + ".html";
        return this;
    }

    public void addImage(String imageFile) {
        this.add(new StoryStepImage().withFile(imageFile));
    }

    public boolean dumpHTML() {
        return this.writeToFile(this.outputFile);
    }

    protected boolean writeToFile(String fileName) {
        if (fileName == null || fileName.length() < 1) {
            return false;
        }
        HTMLEntity output = new HTMLEntity();
        Story.addScript(this.path, "diagramstyle.css", output);
        Story.addScript(this.path, "highlight.pack.js", output);
        Story.addScript(this.path, "highlightjs-line-numbers.min.js", output);
        output.withEncoding("utf-8");
        output.withScript("hljs.initHighlightingOnLoad();\r\nhljs.initLineNumbersOnLoad();", output.getHeader());
        SimpleEvent evt = new SimpleEvent(this, null, null, output);
        for (ObjectCondition step : this.steps) {
            if (step.update(evt)) continue;
            return false;
        }
        return FileBuffer.writeFile(this.path + fileName, output.toString(2));
    }

    public static void addScript(String path, String name, HTMLEntity entry) {
        if (path == null || name == null) {
            return;
        }
        FileBuffer.writeFile(path + name, FileBuffer.readResource("graph/" + name), FileBuffer.NONE);
        entry.withHeader(name);
    }

    public String getPath() {
        return this.path;
    }

    public boolean addDescription(String key, String value) {
        StoryStepSourceCode source = null;
        for (int i = this.steps.size() - 1; i >= 0; --i) {
            ObjectCondition step = (ObjectCondition)this.steps.get(i);
            if (!(step instanceof StoryStepSourceCode)) continue;
            source = (StoryStepSourceCode)step;
            break;
        }
        if (source != null) {
            source.addDescription(key, value);
            return true;
        }
        return false;
    }

    public Story withCounter(int counter) {
        this.counter = counter;
        return this;
    }

    public int getCounter() {
        int value;
        if ((value = this.counter++) >= 0) {
            // empty if block
        }
        return value;
    }

    public Story addText(String text) {
        StoryStepText step = new StoryStepText();
        step.withText(text);
        this.add(step);
        return this;
    }

    protected Story withBreakOnAssert(boolean value) {
        this.breakOnAssert = value;
        return this;
    }

    public Story withMap(IdMap map) {
        this.map = map;
        return this;
    }

    public IdMap getMap() {
        if (this.map == null) {
            this.map = new IdMap();
        }
        return this.map;
    }

    public void finish() {
        for (ObjectCondition step : this.steps) {
            if (!(step instanceof StoryStepSourceCode)) continue;
            StoryStepSourceCode sourceCode = (StoryStepSourceCode)step;
            sourceCode.finish();
        }
    }

    private void addCondition(StoryStepCondition step) {
        this.add(step);
        if (!step.checkCondition() && this.breakOnAssert) {
            block4: {
                this.dumpHTML();
                Method assertClass = null;
                try {
                    assertClass = Class.forName("org.junit.Assert").getMethod("assertTrue", String.class, Boolean.TYPE);
                    if (assertClass != null) {
                        assertClass.invoke(null, "FAILED: " + step.getMessage(), false);
                    }
                }
                catch (ReflectiveOperationException e) {
                    if (!(e instanceof InvocationTargetException)) break block4;
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    StoryUtil.throwException(targetException);
                }
            }
            throw new RuntimeException(step.getMessage());
        }
    }

    public void assertEquals(String message, double expected, double actual, double delta) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Equals().withValue(expected, delta));
        this.addCondition(step);
    }

    public void assertEquals(String message, int expected, int actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Equals().withValue(expected));
        this.addCondition(step);
    }

    public void assertEquals(String message, long expected, long actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Equals().withValue(expected));
        this.addCondition(step);
    }

    public void assertEquals(String message, Object expected, Object actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Equals().withValue(expected));
        this.addCondition(step);
    }

    public void assertTrue(String message, boolean actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new BooleanCondition().withValue(true));
        this.addCondition(step);
    }

    public void assertFalse(String message, boolean actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new BooleanCondition().withValue(false));
        this.addCondition(step);
    }

    public void assertNull(String message, Object actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, Equals.createNullCondition());
        this.addCondition(step);
    }

    public void assertNotNull(String message, Object actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Not().with(Equals.createNullCondition()));
        this.addCondition(step);
    }

    @Override
    public String getOutputFile() {
        return this.outputFile;
    }

    @Override
    public int compareTo(Story story) {
        String label = this.getLabel();
        String otherLabel = null;
        if (story != null) {
            otherLabel = story.getLabel();
        }
        if (label == null) {
            if (otherLabel != null) {
                return -1;
            }
            return 0;
        }
        return label.compareTo(otherLabel);
    }
}

