/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx;

import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.javafx.JsonObjectLazy;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.list.AbstractArray;

public class JsonArrayLazy
extends JsonArray {
    private Object ref = null;
    private boolean loaded;

    public JsonArrayLazy(Object element) {
        this.ref = element;
    }

    public boolean lazyLoad() {
        if (this.ref == null) {
            return false;
        }
        if (this.loaded) {
            return false;
        }
        this.loaded = true;
        int size = (Integer)ReflectionLoader.call(this.ref, "eval", "this.length;");
        for (int i = 0; i < size; ++i) {
            Object value = ReflectionLoader.call(this.ref, "eval", "this[" + i + "]");
            if (ReflectionLoader.JSOBJECT.isAssignableFrom(value.getClass())) {
                AbstractArray child;
                boolean isArray = (Boolean)ReflectionLoader.call(value, "eval", "Array.isArray(this);");
                if (isArray) {
                    child = new JsonArrayLazy(value);
                    this.add(child);
                    ((JsonArrayLazy)child).lazyLoad();
                    continue;
                }
                child = new JsonObjectLazy(value);
                this.add(child);
                ((JsonObjectLazy)child).lazyLoad();
                continue;
            }
            this.add(value);
        }
        return true;
    }

    @Override
    protected Object getByIndex(int offset, int index, int size) {
        Object result = super.getByIndex(offset, index, size);
        if (result != null) {
            if (result instanceof JsonObjectLazy) {
                ((JsonObjectLazy)result).lazyLoad();
            } else if (result instanceof JsonArrayLazy) {
                ((JsonArrayLazy)result).lazyLoad();
            }
        }
        return result;
    }
}

