/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.converter;

import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.interfaces.Entity;

public class EntityStringConverter
implements Converter {
    private int indentFactor;
    private int indent;
    public static final String EMPTY = "";

    public EntityStringConverter() {
    }

    public EntityStringConverter(int indentFactor, int indent) {
        this.indentFactor = indentFactor;
        this.indent = indent;
    }

    public EntityStringConverter(int indentFactor) {
        this.indentFactor = indentFactor;
    }

    @Override
    public String encode(BaseItem entity) {
        if (entity instanceof Entity) {
            return ((Entity)entity).toString(this.getIndentFactor());
        }
        return entity.toString(this);
    }

    public int getIndentFactor() {
        return this.indentFactor;
    }

    public int getIndent() {
        return this.indent;
    }

    public String getStep() {
        char[] buf = new char[this.indentFactor];
        for (int i = 0; i < this.indentFactor; ++i) {
            buf[i] = 32;
        }
        return new String(buf);
    }

    public String getPrefixFirst() {
        if (this.indent < 1) {
            return EMPTY;
        }
        char[] buf = new char[this.indent + 2];
        buf[0] = 13;
        buf[1] = 10;
        for (int i = 0; i < this.indent; ++i) {
            buf[i + 2] = 32;
        }
        return new String(buf);
    }

    public String getPrefix() {
        if (this.indent + this.indentFactor == 0) {
            return EMPTY;
        }
        char[] buf = new char[this.indent + 2];
        buf[0] = 13;
        buf[1] = 10;
        for (int i = 0; i < this.indent; ++i) {
            buf[i + 2] = 32;
        }
        return new String(buf);
    }

    public void add() {
        this.indent += this.indentFactor;
    }

    public void minus() {
        this.indent -= this.indentFactor;
    }
}

