package de.uniks.networkparser.yaml;

/*
The MIT License

Copyright (c) 2010-2016 Stefan Lindel https://github.com/fujaba/NetworkParser/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Converter;

public class YamlItem implements BaseItem{
	private Object key;
	private Object value;
	private String comment;

	public String getComment() {
		return comment;
	}

	public YamlItem withComment(String comment) {
		this.comment = comment;
		return this;
	}

	public Object getValue() {
		return value;
	}

	public YamlItem withValue(Object value) {
		this.value = value;
		return this;
	}

	public Object getKey() {
		return key;
	}

	public YamlItem withKey(Object key) {
		this.key = key;
		return this;
	}

	@Override
	public String toString(Converter converter) {
		return null;
	}

	@Override
	public boolean add(Object... values) {
		return false;
	}

	@Override
	public BaseItem getNewList(boolean keyValue) {
		return new YamlEntity();
	}

	@Override
	public int size() {
		return 1;
	}
}
