package de.uniks.networkparser.gui;

/*
The MIT License

Copyright (c) 2010-2016 Stefan Lindel https://github.com/fujaba/NetworkParser/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
import de.uniks.networkparser.interfaces.ObjectCondition;

public interface JavaViewAdapter extends ObjectCondition {
	public static final String SUCCEEDED = "SUCCEEDED";
	public static final String DRAGOVER="Drag_Over";
	public static final String DRAGDROPPED="Drag_Dropped";
	public static final String ERROR="Error";
	public static final String DRAGEXITED="Drag_Exited";
    public static final String STATE="javafx.concurrent.Worker$State";

	public JavaViewAdapter withOwner(JavaBridge owner);
	public String readFile(String file);
	public Object executeScript(String script);
	public boolean load(Object entity);
	public Object getWebView();
	public Object getWebEngine();
	public void loadFinish();
}
