/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Annotation;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphDiff;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphImage;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.Import;
import de.uniks.networkparser.graph.Literal;
import de.uniks.networkparser.graph.Method;
import de.uniks.networkparser.graph.Modifier;
import de.uniks.networkparser.graph.ModifyEntry;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;

public class GraphUtil {
    public static final String getPackage(Class<?> classObj) {
        if (classObj != null) {
            return GraphUtil.getPackage(classObj.getName());
        }
        return "";
    }

    public static final String getPackage(String name) {
        if (name == null) {
            return "";
        }
        int pos = name.lastIndexOf(".");
        if (pos > 0) {
            return name.substring(0, pos);
        }
        return name;
    }

    public static final Clazz getByObject(GraphEntity item, String clazz, boolean fullName) {
        if (clazz == null) {
            return null;
        }
        return (Clazz)item.getByObject(clazz, fullName);
    }

    public static final SimpleSet<Annotation> getAnnotations(GraphMember item) {
        if (item == null) {
            return null;
        }
        SimpleSet<Annotation> collection = new SimpleSet<Annotation>();
        Annotation annotation = null;
        if (item instanceof Clazz) {
            annotation = ((Clazz)item).getAnnotation();
        }
        if (item instanceof Attribute) {
            annotation = ((Attribute)item).getAnnotation();
        }
        if (item instanceof Annotation) {
            annotation = (Annotation)item;
        }
        if (annotation != null) {
            collection.add(annotation);
            while (annotation.hasNext()) {
                annotation = annotation.next();
                collection.add(annotation);
            }
        }
        return collection;
    }

    public static final void setAssociation(GraphEntity entry, Association assoc) {
        entry.with(assoc);
    }

    public static final void setGraphImage(Clazz clazz, GraphImage ... images) {
        clazz.with(images);
    }

    public static final void setLiteral(Clazz clazz, Literal ... literals) {
        clazz.with(literals);
    }

    public static final void setModifierEntry(Clazz clazz, ModifyEntry modifier) {
        clazz.with(modifier);
    }

    public static final void setClazzType(Clazz clazz, String clazzType) {
        clazz.withType(clazzType);
    }

    public static final void setImport(Clazz clazz, Import ... importClazzes) {
        clazz.with(importClazzes);
    }

    public static boolean setId(GraphEntity graphEntity, String id) {
        return graphEntity.setId(id);
    }

    public static final boolean isWithNoObjects(Clazz clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.getModifier().has(Modifier.ABSTRACT) || "interface".equals(clazz.getType());
    }

    public static final boolean isInterface(Clazz clazz) {
        if (clazz == null) {
            return false;
        }
        return "interface".equals(clazz.getType());
    }

    public static final boolean isEnumeration(Clazz clazz) {
        if (clazz == null) {
            return false;
        }
        return "enum".equals(clazz.getType());
    }

    public static final boolean isUndirectional(Association assoc) {
        if (assoc == null) {
            return false;
        }
        if ((assoc.getType() == AssociationTypes.ASSOCIATION || assoc.getType() == AssociationTypes.UNDIRECTIONAL) && assoc.getOtherType() == AssociationTypes.EDGE) {
            return true;
        }
        return (assoc.getOtherType() == AssociationTypes.ASSOCIATION || assoc.getOtherType() == AssociationTypes.UNDIRECTIONAL) && assoc.getType() == AssociationTypes.EDGE;
    }

    public static final boolean isInterfaceAssociation(Association assoc) {
        if (assoc == null) {
            return false;
        }
        if (assoc.getType() == AssociationTypes.IMPLEMENTS && assoc.getOtherType() == AssociationTypes.EDGE) {
            return true;
        }
        return assoc.getOtherType() == AssociationTypes.IMPLEMENTS && assoc.getType() == AssociationTypes.EDGE;
    }

    public static final CharacterBuffer getMethodParameters(Method method, boolean shortName) {
        return method.getParameterString(shortName, false);
    }

    public static final SimpleSet<Association> getOtherAssociations(Clazz clazz) {
        SimpleSet<Association> collection = new SimpleSet<Association>();
        for (Association assoc : clazz.getAssociations(new Condition[0])) {
            collection.add(assoc.getOther());
        }
        return collection;
    }

    public static final GraphSimpleSet getChildren(GraphMember item) {
        return item.getChildren();
    }

    public static final String getSeperator(Association item) {
        return item.getSeperator();
    }

    public static final SimpleSet<GraphEntity> getNodes(GraphMember item) {
        return item.getNodes();
    }

    public static final GraphDiff getDifference(GraphMember item) {
        return item.getDiff();
    }

    public static final void removeYou(GraphMember value) {
        if (value == null) {
            return;
        }
        value.setParentNode(null);
        if (value instanceof Attribute) {
            Attribute attribute = (Attribute)value;
            Annotation annotation = attribute.getAnnotation();
            value.without(annotation);
        }
        if (value instanceof Association) {
            Association assoc = (Association)value;
            assoc.withOther(null);
            assoc.without(assoc.getClazz());
        }
        if (value instanceof Clazz) {
            Clazz clazz = (Clazz)value;
            GraphSimpleSet collection = clazz.getChildren();
            clazz.without(collection.toArray(new GraphMember[collection.size()]));
        }
    }

    public static final boolean containsClazzAssociation(SimpleList<GraphMember> visited, Association assoc, Association other) {
        boolean foundAssoc = false;
        for (GraphMember checkItem : visited) {
            Association assocA;
            Association assocB;
            if (!(checkItem instanceof Association) || checkItem.getName() == null || (assocB = (assocA = (Association)checkItem).getOther()).getName() == null || !assocA.getName().equals(assoc.getName()) || !assocB.getName().equals(other.getName())) continue;
            foundAssoc = true;
            if (assocA.getClazz() == assoc.getClazz()) {
                if (assocB.getClazz() == other.getClazz()) {
                    assocA.with(Cardinality.MANY);
                    assocB.with(Cardinality.MANY);
                    break;
                }
                assocA.with(Cardinality.MANY);
                break;
            }
            assocB.with(Cardinality.MANY);
            break;
        }
        return foundAssoc;
    }

    public static final String getShortAssoc(Association assoc) {
        if (assoc == null) {
            return "";
        }
        CharacterBuffer sb = new CharacterBuffer();
        Clazz clazz = assoc.getClazz();
        if (clazz != null) {
            sb.with(clazz.getName(true));
        }
        sb.with(':');
        sb.with(assoc.getName());
        sb.with("_");
        sb.with(assoc.getCardinality().getValue());
        sb.with(assoc.getSeperator());
        assoc = assoc.getOther();
        if (assoc != null) {
            clazz = assoc.getClazz();
            if (clazz != null) {
                sb.with(clazz.getName(true));
            }
            sb.with(':');
            sb.with(assoc.getName());
            sb.with("_");
            sb.with(assoc.getCardinality().getValue());
        }
        return sb.toString();
    }

    public static final GraphModel getGraphModel(GraphMember member) {
        GraphSimpleSet list;
        if (member instanceof GraphModel) {
            return (GraphModel)member;
        }
        Object parent = member.getParent();
        if (parent instanceof GraphMember) {
            return GraphUtil.getGraphModel((GraphMember)parent);
        }
        if (parent instanceof GraphSimpleSet && (list = (GraphSimpleSet)parent).size() > 0) {
            return GraphUtil.getGraphModel((GraphMember)list.first());
        }
        return null;
    }

    public static final Clazz getParentClazz(GraphMember member) {
        GraphSimpleSet list;
        if (member instanceof Clazz) {
            return (Clazz)member;
        }
        Object parent = member.getParent();
        if (parent instanceof GraphMember) {
            return GraphUtil.getParentClazz((GraphMember)parent);
        }
        if (parent instanceof GraphSimpleSet && (list = (GraphSimpleSet)parent).size() > 0) {
            return GraphUtil.getParentClazz((GraphMember)list.first());
        }
        return null;
    }

    public static final String createType(String value) {
        if (value == null) {
            return "class";
        }
        String trim = value.trim().toLowerCase();
        if (trim.equals("enum")) {
            return "enum";
        }
        if (trim.equals("interface")) {
            return "interface";
        }
        if (trim.equals("creator")) {
            return "creator";
        }
        if (trim.equals("set")) {
            return "set";
        }
        if (trim.equals("pattern")) {
            return "pattern";
        }
        return "class";
    }
}

