/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.parser;

import de.uniks.networkparser.graph.Method;

public class LoCMetric {
    private int linesOfCode = 0;
    private int commentCount = 0;
    private int methodheader = 0;
    private int emptyLine = 0;
    private int annotation = 0;

    public void finish(Method item) {
        String[] lines;
        for (String line : lines = item.getBody().split("\r\n")) {
            String simple = line.trim();
            if (simple.length() < 1) {
                ++this.emptyLine;
                continue;
            }
            if (simple.indexOf("/*") >= 0 || simple.indexOf("*/") >= 0 || simple.indexOf("//") >= 0 || simple.startsWith("*")) {
                ++this.commentCount;
                continue;
            }
            if ("{}".indexOf(simple) >= 0) {
                ++this.methodheader;
                continue;
            }
            if (simple.startsWith("@")) {
                ++this.annotation;
                continue;
            }
            ++this.linesOfCode;
        }
    }

    public int getLinesOfCode() {
        return this.linesOfCode;
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public int getMethodheader() {
        return this.methodheader;
    }

    public int getEmptyLine() {
        return this.emptyLine;
    }

    public int getAnnotation() {
        return this.annotation;
    }

    public String toString() {
        return "Line of File:" + this.getFullLines() + " - Lines of Code:" + this.linesOfCode;
    }

    public int getFullLines() {
        return this.linesOfCode + this.commentCount + this.methodheader + this.emptyLine + this.annotation;
    }
}

