/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf;

import de.uniks.networkparser.DateTimeEntity;
import de.uniks.networkparser.Filter;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.NetworkParserLog;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.Tokener;
import de.uniks.networkparser.UpdateAccumulate;
import de.uniks.networkparser.converter.ByteConverter;
import de.uniks.networkparser.converter.ByteConverterString;
import de.uniks.networkparser.ext.ErrorHandler;
import de.uniks.networkparser.ext.LogItem;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.petaf.Message;
import de.uniks.networkparser.ext.petaf.ModelExecutor;
import de.uniks.networkparser.ext.petaf.ModelHistory;
import de.uniks.networkparser.ext.petaf.NodeBackup;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.PetaFilter;
import de.uniks.networkparser.ext.petaf.ReceivingTimerTask;
import de.uniks.networkparser.ext.petaf.SendableItem;
import de.uniks.networkparser.ext.petaf.SendingTimerTask;
import de.uniks.networkparser.ext.petaf.SimpleExecutor;
import de.uniks.networkparser.ext.petaf.TaskExecutor;
import de.uniks.networkparser.ext.petaf.filter.ProxyFilter;
import de.uniks.networkparser.ext.petaf.messages.AcceptMessage;
import de.uniks.networkparser.ext.petaf.messages.ChangeMessage;
import de.uniks.networkparser.ext.petaf.messages.ConnectMessage;
import de.uniks.networkparser.ext.petaf.messages.InfoMessage;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyFileSystem;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyLocal;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyModel;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyTCP;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.interfaces.MapListener;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonTokener;
import de.uniks.networkparser.list.AbstractArray;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;
import de.uniks.networkparser.list.SortedSet;

public class Space
extends SendableItem
implements ObjectCondition,
SendableEntityCreator {
    private final String[] properties = new String[]{"name", "path", "history", "proxies"};
    public static final String PROPERTY_MODELROOT = "root";
    public static final String PROPERTY_HISTORY = "history";
    public static final String PROPERTY_PROXY = "proxies";
    public static final String INMESSAGE = "";
    public static final String PROPERTY_PATH = "path";
    public static final String PROPERTY_NAME = "name";
    static final int DISABLE = 0;
    static final int MINUTE = 60;
    static final int TENMINUTE = 6000;
    static final int THIRTYMINUTE = 30000;
    private SortedSet<NodeProxy> proxies = new SortedSet(true);
    private ByteConverter converter;
    protected ModelHistory history = null;
    protected String path = "";
    private ProxyFilter filter = new ProxyFilter();
    private TaskExecutor executor;
    private NodeProxy firstPeer;
    private NodeProxy myNode;
    protected SimpleList<ObjectCondition> clients = new SimpleList();
    private int peerCount = 2;
    protected String name;
    protected NodeBackup backupTask = new NodeBackup().withSpace(this);
    protected NetworkParserLog log = new NetworkParserLog();
    protected final ErrorHandler handler = new ErrorHandler();
    protected boolean isInit = true;
    protected final ChangeMessage changeMessageCreator = new ChangeMessage();
    protected PetaFilter messageFilter = new PetaFilter().withTyp("id");
    private SimpleList<Integer> tryReconnectTimeSecond = (SimpleList)((AbstractArray)((AbstractArray)new SimpleList().with(60, 60, 60, 60, 60)).with(6000, 6000, 6000, 6000, 6000)).with(30000, 0);
    protected IdMap map = this.createIdMap();
    private Tokener tokener;
    private DateTimeEntity lastTimerRun;
    private NodeProxyModel myModel;

    public IdMap getMap() {
        return this.map;
    }

    public String getName() {
        return this.name;
    }

    protected TaskExecutor createExecutorTimer() {
        return new SimpleExecutor().withSpace(this);
    }

    public PetaFilter getMessageFilter() {
        return this.messageFilter;
    }

    protected IdMap createIdMap() {
        IdMap map = new IdMap().with(this, new Message(), this.changeMessageCreator, new InfoMessage(), new NodeProxyTCP(), new NodeProxyLocal(), new NodeProxyFileSystem(null), new ConnectMessage().withSpace(this), new AcceptMessage().withSpace(this), new NodeProxyModel(null));
        map.withListener(this);
        if (ReflectionLoader.PLATFORM != null) {
            map.withModelExecutor(new ModelExecutor());
        }
        return map;
    }

    public Space withCreator(IdMap value) {
        this.map.with(value);
        return this;
    }

    public Space withCreator(SendableEntityCreator ... values) {
        this.map.withCreator(values);
        return this;
    }

    public Space withModelRoot(NodeProxyModel modelRoot) {
        this.with(modelRoot);
        return this;
    }

    public Space withName(String name) {
        this.name = name;
        return this;
    }

    public Space withName(String name, Object root) {
        this.withName(name);
        this.createModel(root, name + ".json");
        this.startModelDistribution(false);
        return this;
    }

    public Space with(NodeProxy ... values) {
        if (values == null) {
            return this;
        }
        for (NodeProxy proxy : values) {
            boolean changed;
            if (proxy == null || !proxy.isValid() || !(changed = this.proxies.add(proxy))) continue;
            if (proxy.getKey() != null) {
                this.map.put(proxy.getKey(), proxy, false);
            }
            this.myNode = null;
            proxy.initSpace(this);
            this.firePropertyChange(PROPERTY_PROXY, null, proxy);
        }
        return this;
    }

    public ModelHistory getHistory() {
        if (this.history == null) {
            this.history = new ModelHistory().withSpace(this);
        }
        return this.history;
    }

    public NodeProxy connectToPeer(String url, int port) {
        NodeProxy proxy;
        this.firstPeer = proxy = this.getOrCreateProxy(url, port);
        if (proxy != null) {
            proxy.connectToPeer();
        }
        return proxy;
    }

    public NodeProxy getFirstPeer() {
        return this.firstPeer;
    }

    public NodeProxy createServer(int port) {
        NodeProxy newProxy = this.getNewProxy();
        newProxy.withType("INOUT");
        newProxy.setValue(newProxy, "port", port, "new");
        this.with(newProxy);
        return newProxy;
    }

    public NodeProxyModel createModel(Object root) {
        NodeProxyModel model = this.getModel();
        if (root == null) {
            return model;
        }
        if (model != null) {
            while (model.nextModel() != null) {
                if (!root.equals(model.getModel())) continue;
                return model;
            }
        }
        model = new NodeProxyModel(root);
        this.with(model);
        return model;
    }

    public NodeProxyFileSystem createModel(Object root, String fileName) {
        this.createModel(root);
        NodeProxyFileSystem fileSystem = null;
        if (fileName != null) {
            String filePath = null;
            filePath = this.path != null && this.path.length() > 0 ? this.path + "/" + fileName : fileName;
            fileSystem = new NodeProxyFileSystem(filePath);
            fileSystem.withFullModell(true);
            this.isInit = false;
            this.with(fileSystem);
            fileSystem.load(root);
            this.isInit = true;
            SimpleList<NodeProxy> candidates = new SimpleList<NodeProxy>();
            NodeProxy[] fileSystemNodes = null;
            for (int i = 0; i < this.proxies.size(); ++i) {
                NodeProxyModel modelProxy;
                NodeProxy proxy = (NodeProxy)this.proxies.get(i);
                if (proxy instanceof NodeProxyFileSystem) {
                    candidates.add(proxy);
                    continue;
                }
                if (!(proxy instanceof NodeProxyModel) || (modelProxy = (NodeProxyModel)proxy).getKey() != null) continue;
                if (fileSystemNodes == null) {
                    for (int z = i + 1; z < this.proxies.size(); ++z) {
                        NodeProxy fileSystemNode = (NodeProxy)this.proxies.get(z);
                        if (!(fileSystemNode instanceof NodeProxyFileSystem)) continue;
                        candidates.add(fileSystemNode);
                    }
                    fileSystemNodes = candidates.toArray(new NodeProxyFileSystem[candidates.size()]);
                }
                Object modell = modelProxy.getModel();
                BaseItem value = this.encode(modell, null);
                ChangeMessage msg = new ChangeMessage();
                msg.withMessage(value);
                this.sendMessage(msg, false, fileSystemNodes);
            }
        }
        return fileSystem;
    }

    public NodeProxy getOrCreateProxy(String url, int port) {
        if (url.equals("127.0.0.1")) {
            return null;
        }
        String value = url + ":" + port;
        NodeProxy proxy = this.getProxy(value);
        if (proxy != null) {
            return proxy;
        }
        NodeProxy newProxy = this.getNewProxy();
        newProxy.setValue(newProxy, "url", url, "new");
        newProxy.setValue(newProxy, "port", port, "new");
        this.with(newProxy);
        return newProxy;
    }

    public NodeProxy getOrCreateNodeProxy(Entity msg, boolean readId) {
        String[] properties;
        NodeProxy proxy;
        Entity props = null;
        if (msg.has("prop")) {
            props = msg;
        }
        if ((proxy = this.getProxy("id")) != null) {
            return proxy;
        }
        proxy = this.getNewProxy();
        for (String property : properties = proxy.getProperties()) {
            Object value = props.getValue(property);
            if (value == null) continue;
            proxy.setValue(proxy, property, value, "new");
        }
        this.with(proxy);
        return proxy;
    }

    public NodeProxy getNewProxy() {
        return new NodeProxyTCP();
    }

    public Space withHistory(ModelHistory value) {
        if (value == this.history) {
            return this;
        }
        ModelHistory oldValue = this.history;
        if (null != oldValue) {
            this.history = null;
            oldValue.withSpace(null);
        }
        this.history = value;
        if (null != value) {
            value.withSpace(this);
        }
        this.firePropertyChange(PROPERTY_HISTORY, oldValue, value);
        return this;
    }

    public void close() {
        for (NodeProxy proxy : this.proxies) {
            if (!NodeProxy.isInput(proxy.getType())) continue;
            proxy.close();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public Entity getReplicationInfo() {
        Tokener tokener = this.getTokener();
        Entity result = tokener.newInstance();
        result.put(PROPERTY_NAME, this.name);
        EntityList proxies = tokener.newInstanceList();
        MapEntity entity = new MapEntity(this.getMap());
        for (NodeProxy proxy : this.proxies) {
            if (!NodeProxy.isOutput(proxy.getType())) continue;
            proxies.add(tokener.encode(proxy, entity));
        }
        result.put(PROPERTY_PROXY, proxies);
        return result;
    }

    public SortedSet<NodeProxy> getNodeProxies(ObjectCondition ... filters) {
        if (filters == null) {
            return this.proxies;
        }
        SortedSet<NodeProxy> result = new SortedSet<NodeProxy>(true);
        for (NodeProxy proxy : this.proxies) {
            for (ObjectCondition filter : filters) {
                if (filter == null || !filter.update(proxy)) continue;
                result.add(proxy);
            }
        }
        return this.proxies;
    }

    public ByteConverter getConverter() {
        if (this.converter == null) {
            this.converter = new ByteConverterString();
        }
        return this.converter;
    }

    public Space withConverter(ByteConverter converter) {
        this.converter = converter;
        return this;
    }

    public String convertMessage(Message msg) {
        BaseItem encode = this.getMap().encode(msg, this.tokener, this.messageFilter);
        this.addMessageElement(msg, encode);
        ByteConverter byteConverter = this.getConverter();
        return byteConverter.encode(encode);
    }

    public boolean startModelDistribution(boolean alwaysEncode) {
        IdMap map = this.getMap();
        boolean result = true;
        for (NodeProxy proxy : this.proxies) {
            if (!(proxy instanceof NodeProxyModel)) continue;
            NodeProxyModel modelProxy = (NodeProxyModel)proxy;
            Object model = modelProxy.getModel();
            if (!alwaysEncode && map.getKey(model) != null || this.getMap().encode(model, this.tokener) != null) continue;
            result = false;
        }
        return result;
    }

    protected void addMessageElement(Message msg, BaseItem encode) {
    }

    public boolean removeProxy(NodeProxy proxy) {
        boolean changed = this.proxies.remove(proxy);
        if (changed) {
            this.myNode = null;
        }
        return changed;
    }

    Filter getFilter() {
        Filter result = new Filter().withPropertyRegard(this.filter);
        return result;
    }

    private void addInfo(Message msg, NodeProxy myProxy, boolean sendAnyhow) {
        ModelHistory history = this.getHistory();
        if (sendAnyhow) {
            msg.withSendAnyHow(sendAnyhow);
        }
        if (myProxy == null) {
            myProxy = this.getMyNode();
        }
        String messageId = msg.getMessageId(this, myProxy);
        msg.withPrevChange(history.getPrevChangeId(messageId));
        msg.withAddToReceived(myProxy);
        if (msg instanceof ReceivingTimerTask) {
            ((ReceivingTimerTask)msg).withSpace(this);
        }
    }

    public Space withPath(String path) {
        this.path = path;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public boolean sendMessage(SendingTimerTask task, NodeProxy ... proxy) {
        if (proxy != null) {
            NodeProxy sender = null;
            if (proxy != null && proxy.length > 0) {
                sender = proxy[0];
            }
            task.withSender(sender);
            this.scheduleTask(task);
        }
        return true;
    }

    public boolean sendMessage(Message msg, boolean sendAnyhow, NodeProxy ... proxies) {
        if (proxies == null) {
            return false;
        }
        NodeProxy myProxy = null;
        for (NodeProxy item : this.proxies) {
            if (!NodeProxy.isOutput(item.getType()) || item.getKey() == null) continue;
            myProxy = item;
            break;
        }
        this.addInfo(msg, myProxy, sendAnyhow);
        boolean sended = true;
        for (NodeProxy proxy : proxies) {
            if (proxy == null) continue;
            this.with(proxy);
            if (proxy.filter(msg)) {
                boolean bl = sended = sended && proxy.sending(msg);
            }
            if (!sended) continue;
            proxy.withOnline(true);
        }
        return sended;
    }

    public Space withPeerCount(int peerCount) {
        this.peerCount = peerCount;
        return this;
    }

    public boolean sendMessageToPeers(Message msg) {
        return this.sendMessageToPeers(msg, null);
    }

    public NodeProxy getProxy(String id) {
        if (id == null) {
            return null;
        }
        for (NodeProxy proxy : this.proxies) {
            if (!id.equals(proxy.getKey())) continue;
            return proxy;
        }
        return null;
    }

    public void addMessage(Object owner, LogItem logItem) {
        this.log.print(owner, logItem);
    }

    protected void calculateSendProxy(Message msg, NodeProxy receiver, SimpleSet<NodeProxy> sendProxies) {
        NodeProxy proxy;
        int i;
        SimpleSet<NodeProxy> received = msg.getReceived();
        SimpleList<Object> receiverProxy = new SimpleList<Object>();
        boolean out = false;
        NodeProxy myNode = this.getMyNode();
        if (receiver != null) {
            for (i = 0; i < this.proxies.size(); ++i) {
                proxy = (NodeProxy)this.proxies.get(i);
                if (NodeProxy.isOutput(proxy.getType())) {
                    out = true;
                }
                if (receiver == proxy || this.isMyNode(proxy, myNode)) {
                    receiverProxy.add((Object)i);
                    if (!proxy.isSendable()) continue;
                    msg.withAddToReceived(proxy);
                    continue;
                }
                if (proxy.isReconnecting(this.tryReconnectTimeSecond)) continue;
                sendProxies.add(proxy);
            }
        } else {
            for (i = 0; i < this.proxies.size(); ++i) {
                proxy = (NodeProxy)this.proxies.get(i);
                if ("OUT".equals(proxy.getType())) {
                    out = true;
                    continue;
                }
                if (NodeProxy.isInput(proxy.getType())) {
                    if (NodeProxy.isOutput(proxy.getType())) {
                        out = true;
                    }
                    receiverProxy.add((Object)i);
                    if (!proxy.isSendable()) continue;
                    msg.withAddToReceived(proxy);
                    continue;
                }
                if (proxy.isReconnecting(this.tryReconnectTimeSecond)) continue;
                sendProxies.add(proxy);
            }
        }
        if (!out) {
            return;
        }
        if (receiverProxy.size() < 1 && this.proxies.size() > 0) {
            receiverProxy.add((Object)0);
        }
        for (Integer n : receiverProxy) {
            int number = n;
            int step = 0;
            while (step < this.peerCount) {
                if (++number >= this.proxies.size()) {
                    number -= this.proxies.size();
                    ++step;
                }
                if (!NodeProxy.isOutput((proxy = (NodeProxy)this.proxies.get(number)).getType()) || received.indexOf(proxy) >= 0 && !(proxy instanceof NodeProxyFileSystem)) continue;
                ++step;
                if (sendProxies.add(proxy)) continue;
                step = this.peerCount;
            }
        }
        receiverProxy.add((Object)new Object[]{this.firstPeer});
    }

    private boolean isMyNode(NodeProxy proxy, NodeProxy myNode) {
        if (proxy == myNode) {
            return true;
        }
        while (myNode != null) {
            if ((myNode = myNode.next()) != proxy) continue;
            return true;
        }
        return false;
    }

    public boolean sendMessageToPeers(Message msg, NodeProxy receiver) {
        boolean success = false;
        this.addInfo(msg, receiver, false);
        SimpleSet<NodeProxy> sendProxies = new SimpleSet<NodeProxy>();
        this.calculateSendProxy(msg, receiver, sendProxies);
        if (sendProxies.size() < 1) {
            return true;
        }
        ModelHistory history = this.getHistory();
        history.addHistory(msg);
        for (NodeProxy peer : sendProxies) {
            boolean done;
            if (!peer.filter(msg) || !(done = peer.sending(msg))) continue;
            msg.withAddToReceived(peer);
            success = true;
        }
        if (receiver != null) {
            receiver.sending(InfoMessage.create(this));
        }
        return success;
    }

    public SimpleList<Integer> getReconnectTime() {
        return this.tryReconnectTimeSecond;
    }

    public static Space newInstance(NodeProxy ... proxyListener) {
        Space space = new Space().with(proxyListener);
        return space;
    }

    public static Space newInstance(Object world, IdMap map, NodeProxy ... proxyListener) {
        Space space = new Space();
        space.with(new NodeProxyModel(world));
        space.with(proxyListener);
        return space;
    }

    public static Space newInstance(IdMap map, NodeProxy ... proxyListener) {
        Space space = new Space();
        space.with(new NodeProxyModel(null));
        space.with(proxyListener);
        return space;
    }

    public Object execute(Runnable task) {
        if (this.executor == null) {
            this.executor = new SimpleExecutor().withSpace(this);
        }
        return this.executor.executeTask(task, 0);
    }

    public NodeProxyModel getModel() {
        if (this.myModel == null) {
            NodeProxyModel last = null;
            for (NodeProxy item : this.proxies) {
                if (!(item instanceof NodeProxyModel)) continue;
                NodeProxyModel proxy = (NodeProxyModel)item;
                if (last == null) {
                    this.myModel = last = proxy.setNextModel(null);
                    continue;
                }
                last = last.setNextModel(proxy);
            }
        }
        return this.myModel;
    }

    public Tokener getTokener() {
        if (this.tokener == null) {
            this.tokener = new JsonTokener();
        }
        return this.tokener;
    }

    public BaseItem encode(Object entity, Filter entityFilter) {
        if (this.map != null) {
            return this.map.encode(entity, this.tokener, entityFilter);
        }
        return null;
    }

    public String getId(Object entity) {
        if (this.map != null) {
            return this.map.getId(entity, true);
        }
        return null;
    }

    public String getKey(Object entity) {
        if (this.map != null) {
            return this.map.getKey(entity);
        }
        return null;
    }

    public Object getObject(String key) {
        if (this.map != null) {
            return this.map.getId(key, true);
        }
        return null;
    }

    public TaskExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = this.createExecutorTimer();
        }
        return this.executor;
    }

    public boolean updateBackup() {
        if (this.backupTask.isEnable()) {
            return false;
        }
        this.backupTask.enable();
        this.scheduleTask(this.backupTask, 10000);
        return true;
    }

    public Object scheduleTask(Runnable task) {
        if (task == null) {
            return null;
        }
        return this.getExecutor().executeTask(task, 0);
    }

    public Object scheduleTask(Runnable task, int delay) {
        if (task == null) {
            return null;
        }
        return this.getExecutor().executeTask(task, delay);
    }

    public Object scheduleTask(Runnable task, int delay, int interval) {
        if (task == null) {
            return null;
        }
        return this.getExecutor().executeTask(task, delay, interval);
    }

    @Override
    public boolean update(Object value) {
        if (!(value instanceof SimpleEvent)) {
            return false;
        }
        SimpleEvent event = (SimpleEvent)value;
        for (ObjectCondition client : this.clients) {
            client.update(event);
        }
        if (event.isIdEvent()) {
            return true;
        }
        if (event.getPropertyName() == null) {
            return true;
        }
        if (event.getNewValue() instanceof Message) {
            return true;
        }
        if (event.getModelValue() instanceof NodeProxy) {
            return true;
        }
        if (event.getNewValue() instanceof NodeProxy || event.getSource() instanceof NodeProxy) {
            return true;
        }
        return this.updateModel(event);
    }

    public boolean updateModel(SimpleEvent event) {
        if (!this.isInit) {
            return false;
        }
        if ("upd".equals(event.getType()) || "new".equals(event.getType())) {
            Object newValue = event.getNewValue();
            Object oldValue = event.getOldValue();
            if (newValue instanceof NodeProxy) {
                return true;
            }
            if (newValue instanceof LogItem || oldValue instanceof LogItem) {
                return true;
            }
            ChangeMessage change = this.changeMessageCreator.getSendableInstance(false);
            change.withValue(event);
            this.sendMessageToPeers(change);
            return true;
        }
        return this.isInit;
    }

    public Space withInit(boolean value) {
        this.isInit = value;
        return this;
    }

    public Space withClient(ObjectCondition ... clients) {
        if (clients == null) {
            return this;
        }
        for (ObjectCondition item : clients) {
            this.clients.add(item);
        }
        return this;
    }

    public Space withoutClients(ObjectCondition ... clients) {
        if (clients == null) {
            return this;
        }
        for (ObjectCondition item : clients) {
            this.clients.remove(item);
        }
        return this;
    }

    public void dispose() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        for (NodeProxy proxy : this.proxies) {
            proxy.close();
        }
    }

    public NodeProxy getMyNode() {
        if (this.myNode == null) {
            NodeProxy last = null;
            for (NodeProxy item : this.proxies) {
                if (!NodeProxy.isInput(item.getType())) continue;
                if (last == null) {
                    this.myNode = last = item;
                    item.setNextMyNode(null);
                    continue;
                }
                last = last.setNextMyNode(item);
            }
        }
        return this.myNode;
    }

    public NodeProxy updateProxy(Message message) {
        return message.getReceiver();
    }

    public void clearProxies() {
        this.proxies.clear();
    }

    public boolean suspendNotification(UpdateAccumulate ... accumulates) {
        MapListener mapListener = this.getMap().getMapListener();
        return mapListener.suspendNotification(accumulates);
    }

    public SimpleList<UpdateAccumulate> resetNotification() {
        MapListener mapListener = this.getMap().getMapListener();
        return mapListener.resetNotification();
    }

    public NodeProxy getLastProxy(String property) {
        NodeProxy lastItem = null;
        long max = Long.MIN_VALUE;
        for (NodeProxy item : this.proxies) {
            Long no;
            Object value = item.getValue(item, property);
            if (!(value instanceof Number) || (no = (Long)value) <= max) continue;
            max = no;
            lastItem = item;
        }
        return lastItem;
    }

    public boolean sendEventToClients(SimpleEvent event) {
        boolean result = true;
        for (ObjectCondition client : this.clients) {
            result &= client.update(event);
        }
        return result;
    }

    public Space withLastTimerRun(DateTimeEntity value) {
        this.lastTimerRun = value;
        return this;
    }

    public DateTimeEntity getLastTimerRun() {
        return this.lastTimerRun;
    }

    @Override
    public String[] getProperties() {
        return this.properties;
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (!(entity instanceof Space)) {
            return null;
        }
        Space space = (Space)entity;
        if (attribute.equalsIgnoreCase(PROPERTY_PROXY)) {
            return space.getNodeProxies(new ObjectCondition[0]);
        }
        if (attribute.equalsIgnoreCase(PROPERTY_NAME)) {
            return space.getName();
        }
        if (attribute.equalsIgnoreCase(PROPERTY_PATH)) {
            return space.getPath();
        }
        if (attribute.equalsIgnoreCase(PROPERTY_HISTORY)) {
            return space.getHistory();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (!(entity instanceof Space)) {
            return false;
        }
        Space space = (Space)entity;
        if (attribute.equalsIgnoreCase(PROPERTY_PROXY)) {
            space.with((NodeProxy)value);
            return true;
        }
        return false;
    }

    public void handleException(Throwable e) {
        this.handler.saveException(e, false);
    }

    public boolean handleMsg(Message message) {
        if (message instanceof ReceivingTimerTask) {
            ((ReceivingTimerTask)message).withSpace(this);
            this.scheduleTask((ReceivingTimerTask)message);
            return true;
        }
        if (message.isSendingToPeers()) {
            this.sendMessageToPeers(message);
        }
        return false;
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return Space.class;
    }

    public boolean updateNetwork(String type, NodeProxy nodeProxy) {
        SimpleEvent event = new SimpleEvent(this, type, null, nodeProxy);
        return this.sendEventToClients(event);
    }

    public Space withModelExecutor(ObjectCondition modelExecutor) {
        this.map.withModelExecutor(modelExecutor);
        return this;
    }
}

