/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf;

import de.uniks.networkparser.Filter;
import de.uniks.networkparser.ext.petaf.Message;
import de.uniks.networkparser.ext.petaf.ModelChange;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.Space;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;
import de.uniks.networkparser.list.SortedSet;
import de.uniks.networkparser.logic.SimpleObjectFilter;
import java.util.Collection;

public class ModelHistory {
    public static final String PROPERTY_HISTORY = "history";
    public static final String PROPERTY_LASTMODELCHANGE = "lastmodelchange";
    public static final String PROPERTY_CHANGES = "changes";
    private SimpleSet<ModelChange> history = new SimpleSet();
    private Space space;
    private SimpleKeyValueList<SendableEntityCreator, Object> prototypeCache = new SimpleKeyValueList();
    private SimpleKeyValueList<String, JsonObject> postponedChanges = new SimpleKeyValueList();
    private long allDataMsgNo;

    public ModelChange getLastModelChange() {
        return (ModelChange)this.history.last();
    }

    public boolean refactoringHistory() {
        Entity changeEntity;
        ModelChange change;
        BaseItem changeMsg;
        int i;
        SortedSet<NodeProxy> nodes = this.getSpace().getNodeProxies(new ObjectCondition[0]);
        SimpleList<String> keys = new SimpleList<String>();
        for (NodeProxy proxy : nodes) {
            String key = proxy.getHistory();
            keys.add(key);
        }
        SimpleKeyValueList<String, ModelChange> changes = new SimpleKeyValueList<String, ModelChange>();
        SimpleKeyValueList<String, String> deletedChanges = new SimpleKeyValueList<String, String>();
        for (i = this.checkMergeInitModel(); i < this.history.size() && (changeMsg = (change = (ModelChange)this.history.get(i)).getChange()) instanceof Entity; ++i) {
            Entity changeChange;
            EntityList changeChanges;
            changeEntity = (Entity)changeMsg;
            this.setNewPrevId(changeEntity, deletedChanges);
            String value = change.getKey();
            if (keys.contains(value)) break;
            value = changeEntity.getString("changeid");
            if (!"ChangeMessage".equals(changeEntity.getString("class"))) continue;
            int pos = changes.indexOf(value);
            if (pos < 0) {
                changes.put(value, change);
                continue;
            }
            Entity changeListEntity = (Entity)((ModelChange)changes.getValueByIndex(pos)).getChange();
            if (changeListEntity.has(PROPERTY_CHANGES)) {
                changeChanges = (EntityList)changeListEntity.getValue(PROPERTY_CHANGES);
            } else {
                changeChanges = (EntityList)changeListEntity.getNewList(false);
                changeListEntity.put(PROPERTY_CHANGES, changeChanges);
                changeChange = (Entity)changeChanges.getNewList(true);
                changeChanges.add(changeChange);
                value = changeListEntity.getString("property");
                changeChange.put("property", value);
                value = changeListEntity.getString("old");
                changeChange.put("old", value);
                value = changeListEntity.getString("new");
                changeChange.put("new", value);
                value = changeListEntity.getString("changeid");
                changeChange.put("changeid", value);
            }
            changeChange = null;
            value = changeEntity.getString("property");
            for (int c = 0; c < changeChanges.sizeChildren(); ++c) {
                Entity child = (Entity)changeChanges.getChild(c);
                if (!value.equals(child.getString("property"))) continue;
                changeChange = child;
            }
            if (changeChange == null) {
                changeChange = (Entity)changeChanges.getNewList(true);
                changeChanges.add(changeChange);
                changeChange.put("property", value);
                value = changeEntity.getString("old");
                changeChange.put("old", value);
            }
            value = changeEntity.getString("new");
            changeChange.put("new", value);
            value = changeEntity.getString("changeid");
            changeChange.put("changeid", value);
            this.setNewPrevId(changeEntity, deletedChanges);
            this.history.remove(i);
            --i;
        }
        while (i < this.history.size()) {
            change = (ModelChange)this.history.get(i);
            changeMsg = change.getChange();
            if (changeMsg instanceof Entity) {
                changeEntity = (Entity)changeMsg;
                this.setNewPrevId(changeEntity, deletedChanges);
            }
            ++i;
        }
        return true;
    }

    private int checkMergeInitModel() {
        return 0;
    }

    private void setNewPrevId(Entity changeEntity, SimpleKeyValueList<String, String> deletedChanges) {
        int pos;
        String value = changeEntity.getString("prevChange");
        if (value != null && (pos = deletedChanges.indexOf(value)) >= 0) {
            changeEntity.put("prevChange", deletedChanges.getValueByIndex(pos));
        }
    }

    protected boolean isToManyField(SendableEntityCreator createrClass, String fieldName) {
        Object fieldValue;
        Object prototype = this.prototypeCache.get(createrClass);
        if (prototype == null) {
            prototype = createrClass.getSendableInstance(true);
            this.prototypeCache.put(createrClass, prototype);
        }
        return (fieldValue = createrClass.getValue(prototype, fieldName)) != null && fieldValue instanceof Collection;
    }

    public String getPrevChangeId(String change) {
        if (this.history.isEmpty()) {
            return null;
        }
        ModelChange last = (ModelChange)this.history.last();
        if (last == null) {
            return null;
        }
        return last.getKey();
    }

    public boolean addHistory(Message value) {
        ModelChange change = new ModelChange();
        NodeProxy proxy = value.getReceiver();
        change.withReceiver(this.space.encode(proxy, null));
        change.withChange(value.getMessage());
        change.withKey(value.getMessageId(this.space, proxy));
        return this.addHistory(change);
    }

    private Entity getElement(ModelChange change) {
        BaseItem item = change.getChange();
        if (item instanceof Entity) {
            return (Entity)item;
        }
        return null;
    }

    public boolean addHistory(ModelChange value) {
        boolean success = true;
        ModelChange historyChange = this.history.ceiling(value, true);
        while (success && historyChange != null) {
            String valueJsonId;
            String historyJsonId;
            if (value.compareTo(historyChange) == 0) {
                return false;
            }
            Entity historyJsonObject = this.getElement(historyChange);
            Entity valueJsonObject = this.getElement(value);
            if (!historyJsonObject.has("id")) {
                System.out.println("ERROR");
            }
            if (!(historyJsonId = historyJsonObject.getString("id")).equals(valueJsonId = valueJsonObject.getString("id"))) continue;
            Entity historyPropsObject = (Entity)historyJsonObject.getValue("upd");
            if (historyPropsObject == null) {
                historyPropsObject = (Entity)historyJsonObject.getValue("rem");
            }
            if (historyPropsObject == null) {
                return false;
            }
            Entity valuePropsObject = (Entity)valueJsonObject.getValue("upd");
            if (valuePropsObject == null) {
                valuePropsObject = (Entity)valueJsonObject.getValue("rem");
            }
            for (int i = 0; i < historyPropsObject.size(); ++i) {
                Object valueProp;
                String historyKey = historyPropsObject.getKeyByIndex(i);
                if (historyKey == null) continue;
                String fieldName = historyKey;
                if (valuePropsObject == null || (valueProp = valuePropsObject.getValue(fieldName)) == null) continue;
                Object target = this.space.getObject(valueJsonId);
                if (target == null) {
                    return false;
                }
                SendableEntityCreator createrClass = this.space.getMap().getCreatorClass(target);
                if (createrClass.getValue(target, fieldName) instanceof Collection) {
                    String valueKidId;
                    Entity historyKid = this.getObject(historyPropsObject, fieldName);
                    if (historyKid == null) {
                        success = false;
                        break;
                    }
                    Entity valueKid = this.getObject(valuePropsObject, fieldName);
                    if (valueKid == null) {
                        success = false;
                        break;
                    }
                    String historyKidId = historyKid.getString("id");
                    if (!historyKidId.equals(valueKidId = valueKid.getString("id"))) continue;
                    success = false;
                    break;
                }
                success = false;
                break;
            }
            historyChange = this.history.ceiling(historyChange, false);
        }
        if (value != null && value.getKey() != null) {
            this.history.add(value);
        }
        return success;
    }

    public Entity getObject(Entity jsonObject, String fieldName) {
        Object historyKid = jsonObject.getValue(fieldName);
        if (historyKid == null) {
            historyKid = jsonObject.getValue(fieldName + "rem");
        }
        if (!(historyKid instanceof Entity)) {
            return null;
        }
        return (Entity)historyKid;
    }

    public Space getSpace() {
        return this.space;
    }

    public ModelHistory withSpace(Space space) {
        this.space = space;
        return this;
    }

    public void addFirstHistory(ModelChange change) {
        this.history.add(change);
    }

    public ModelChange createChange(int key, BaseItem receiver, Entity value) {
        ModelChange modelChange = new ModelChange();
        modelChange.withKey("" + key);
        modelChange.withChange(value);
        modelChange.withReceiver(receiver);
        return modelChange;
    }

    public ModelChange createChange(Entity value) {
        ModelChange modelChange = new ModelChange();
        modelChange.withChange(value);
        return modelChange;
    }

    public ModelChange createChange(int key, String receiver, Entity value) {
        NodeProxy proxy = this.space.getProxy(receiver);
        JsonObject receiverObj = this.space.getMap().toJsonObject(proxy, Filter.regard(new SimpleObjectFilter()));
        return this.createChange(key, receiverObj, value);
    }

    public ModelChange ceiling(ModelChange element, boolean sameElement) {
        return this.history.ceiling(element, sameElement);
    }

    public ModelChange last() {
        return (ModelChange)this.history.last();
    }

    public boolean checkMessage(Entity change) {
        Object value = change.getValue("prevChange");
        int previousMsgNo = Integer.parseInt("" + value);
        return (long)previousMsgNo <= this.getAllDataMsgNo() || previousMsgNo <= 1;
    }

    public long getNewMsgNo() {
        NodeProxy myNode;
        if (this.space != null && (myNode = this.space.getMyNode()) != null) {
            return myNode.getNewMsgNo();
        }
        return 0L;
    }

    public long getAllDataMsgNo() {
        return this.allDataMsgNo;
    }

    public ModelHistory withAllDataMsgNo(long allDataMsgNo) {
        this.allDataMsgNo = allDataMsgNo;
        return this;
    }

    public void addPostponedChanges(String key, JsonObject msg) {
        this.postponedChanges.put(key, msg);
    }

    public SimpleKeyValueList<String, JsonObject> getPostponedChanges() {
        return this.postponedChanges;
    }

    public ModelChange lower(ModelChange change) {
        return this.history.lower(change, false);
    }

    public SimpleSet<ModelChange> getHistory() {
        return this.history;
    }
}

