/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.SimpleObject;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.ext.javafx.GUIEvent;
import de.uniks.networkparser.ext.javafx.JsonObjectLazy;
import de.uniks.networkparser.gui.BridgeCommand;
import de.uniks.networkparser.gui.EventTypes;
import de.uniks.networkparser.gui.JavaBridge;
import de.uniks.networkparser.gui.JavaViewAdapter;
import de.uniks.networkparser.gui.controls.Control;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.xml.HTMLEntity;
import de.uniks.networkparser.xml.XMLEntity;
import java.io.File;
import java.util.concurrent.CountDownLatch;

public class JavaAdapter
implements JavaViewAdapter {
    private SimpleKeyValueList<Object, String> callBack = new SimpleKeyValueList();
    protected JavaBridge owner;
    protected Object webView;
    protected Object webEngine;
    private SimpleList<String> queue = new SimpleList();
    protected boolean loadHTMLEntity = false;

    public JavaAdapter() {
        if (ReflectionLoader.WEBVIEW != null) {
            this.webView = ReflectionLoader.newInstance(ReflectionLoader.WEBVIEW, new Object[0]);
            this.webEngine = ReflectionLoader.call("getEngine", this.webView, new Object[0]);
            ReflectionLoader.call("setMaxSize", this.webView, Double.TYPE, Double.MAX_VALUE, Double.TYPE, Double.MAX_VALUE);
        }
    }

    @Override
    public JavaAdapter withOwner(JavaBridge owner) {
        this.owner = owner;
        return this;
    }

    @Override
    public boolean load(Object item) {
        if (item instanceof String) {
            ReflectionLoader.call("load", this.webEngine, item);
            return true;
        }
        if (item instanceof File) {
            File file = (File)item;
            if (!file.exists()) {
                System.out.println("FILE NOT FOUND");
            }
            ReflectionLoader.call("load", this.webEngine, file.toURI().toString());
            return true;
        }
        if (!(item instanceof HTMLEntity)) {
            return false;
        }
        HTMLEntity entity = (HTMLEntity)item;
        if (this.loadHTMLEntity) {
            ReflectionLoader.call("loadContent", this.webEngine, entity.toString());
            return true;
        }
        XMLEntity headers = entity.getHeader();
        for (int i = 0; i < headers.sizeChildren(); ++i) {
            XMLEntity child = (XMLEntity)headers.getChild(i);
            if (!"script".equalsIgnoreCase(child.getTag())) continue;
            Object value = child.getValue("src");
            if (value != null) {
                this._execute(this.readFile("" + value));
                continue;
            }
            this._execute(child.getValue());
        }
        XMLEntity body = entity.getHeader();
        for (int i = 0; i < body.sizeChildren(); ++i) {
            XMLEntity child = (XMLEntity)body.getChild(i);
            if (!"script".equalsIgnoreCase(child.getTag()) || child.has("src")) continue;
            this._execute(child.getValue());
        }
        this.registerListener(this);
        ReflectionLoader.call("loadContent", this.webEngine, String.class, entity.toString());
        return true;
    }

    public boolean registerListener(ObjectCondition listener) {
        Object stateProperty = ReflectionLoader.callChain(this.webEngine, "getLoadWorker", "stateProperty");
        GUIEvent eventListener = new GUIEvent().withListener(listener);
        Object proxy = ReflectionLoader.createProxy(eventListener, ReflectionLoader.CHANGELISTENER, ReflectionLoader.EVENTHANDLER);
        ReflectionLoader.call("addListener", stateProperty, ReflectionLoader.CHANGELISTENER, proxy);
        ReflectionLoader.call("setOnError", this.webEngine, ReflectionLoader.EVENTHANDLER, proxy);
        ReflectionLoader.call("setOnAlert", this.webEngine, ReflectionLoader.EVENTHANDLER, proxy);
        ReflectionLoader.call("setOnDragExited", this.webView, ReflectionLoader.EVENTHANDLER, proxy);
        ReflectionLoader.call("setOnDragOver", this.webView, ReflectionLoader.EVENTHANDLER, proxy);
        ReflectionLoader.call("setOnDragDropped", this.webView, ReflectionLoader.EVENTHANDLER, proxy);
        return true;
    }

    @Override
    public boolean update(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            JsonObject data = new JsonObject().withValue("" + value);
            this.owner.fireEvent(data);
            return true;
        }
        if (ReflectionLoader.JSOBJECT.isAssignableFrom(value.getClass())) {
            GUIEvent event = GUIEvent.create(value);
            this.owner.fireEvent(event);
            return true;
        }
        return false;
    }

    public boolean changed(SimpleEvent event) {
        if ("SUCCEEDED".equals("" + event.getNewValue())) {
            this.loadFinish();
            return true;
        }
        return false;
    }

    public void showAlert(String value) {
        System.err.println(value);
    }

    public boolean executeChange(String value) {
        this.owner.setApplyingChangeMSG(true);
        JsonObject json = JsonObject.create(value);
        IdMap map = this.owner.getMap();
        Object encode = map.decode(json);
        if (encode == null) {
            SimpleObject newItem = SimpleObject.create(json);
            map.put(newItem.getId(), newItem, false);
        }
        this.owner.setApplyingChangeMSG(false);
        return true;
    }

    @Override
    public String readFile(String file) {
        if (file == null) {
            return "";
        }
        FileBuffer buffer = new FileBuffer().withFile(file);
        return buffer.toString();
    }

    @Override
    public Object executeScript(String script) {
        this.owner.logScript(script, 4, this, "executeScript");
        if (this.queue != null) {
            this.queue.add(script);
        }
        return this._execute(script);
    }

    private Object _execute(String script) {
        Object jsObject = ReflectionLoader.call("executeScript", this.webEngine, String.class, script);
        if (jsObject != null && ReflectionLoader.JSOBJECT.isAssignableFrom(jsObject.getClass())) {
            JsonObject item = this.convertJSObject(jsObject);
            return item;
        }
        return jsObject;
    }

    private JsonObject convertJSObject(Object element) {
        JsonObjectLazy result = new JsonObjectLazy(element);
        result.lazyLoad();
        return result;
    }

    @Override
    public Object getWebView() {
        return this.webView;
    }

    @Override
    public Object getWebEngine() {
        return this.webEngine;
    }

    protected void addAdapter(ObjectCondition eventListener) {
        JsonObjectLazy executeScript = (JsonObjectLazy)this._execute("bridge.addAdapter(new DiagramJS.DelegateAdapter());");
        if (executeScript != null) {
            Object reference = executeScript.getReference();
            ReflectionLoader.call("setAdapter", reference, Object.class, eventListener);
        }
    }

    @Override
    public void loadFinish() {
        this.addAdapter(this);
        while (this.queue.size() > 0) {
            String command = (String)this.queue.remove(0);
            this._execute(command);
        }
        this.queue = null;
    }

    public boolean addListener(Control control, EventTypes type, String functionName, Object callBackClazz) {
        this.owner.addControl(control);
        String id = control.getId();
        if (callBackClazz != null) {
            String callBackName = this.getCallBackName(callBackClazz);
            this.executeScript(BridgeCommand.register(type, id, callBackName + "." + functionName));
            return true;
        }
        this.executeScript("bridge.registerListener(" + (Object)((Object)type) + ", \"" + id + "\");");
        return true;
    }

    public String getCallBackName(Object clazz) {
        String callBackName = this.callBack.get(clazz);
        Object window = this._execute("window");
        if (callBackName == null) {
            callBackName = "_callBack" + (this.callBack.size() + 1);
            this.callBack.put(clazz, callBackName);
            ReflectionLoader.call("setMember", window, String.class, callBackName, Object.class, clazz);
        }
        return callBackName;
    }

    public static void execute(Runnable runnable) {
        ReflectionLoader.call("runLater", ReflectionLoader.PLATFORM, Runnable.class, runnable);
    }

    public static void executeAndWait(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (((Boolean)ReflectionLoader.call("isFxApplicationThread", ReflectionLoader.PLATFORM, new Object[0])).booleanValue()) {
            runnable.run();
            return;
        }
        final CountDownLatch doneLatch = new CountDownLatch(1);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    doneLatch.countDown();
                }
            }
        };
        JavaAdapter.execute(task);
        try {
            doneLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

