/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext;

import de.uniks.networkparser.Deep;
import de.uniks.networkparser.Filter;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.Server;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.xml.XMLEntity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Iterator;

public class RESTServiceTask
implements Runnable,
Server {
    private int port;
    public static final String ERROR404 = "HTTP 404";
    public static final String OK = "HTTP 200";
    public static final String PROPERTY_ERROR = "error";
    public static final String PROPERTY_ALLOW = "allow";
    public static final String LENGTH = "Content-Length:";
    private ServerSocket serverSocket;
    private IdMap map;
    private Object root;
    private SendableEntityCreator creator;
    private Filter filter = Filter.regard(Deep.create(1));
    private Condition<Exception> errorListener;
    private Condition<SimpleEvent> allowListener;
    public static final String JSON = "/json";
    public static final String XML = "/xml";

    public RESTServiceTask(int port, IdMap map, Object root) {
        this.port = port;
        this.map = map;
        this.root = root;
        this.creator = map.getCreatorClass(root);
    }

    public RESTServiceTask withErrorListener(Condition<Exception> listener) {
        this.errorListener = listener;
        return this;
    }

    public RESTServiceTask withAllowListener(Condition<SimpleEvent> listener) {
        this.allowListener = listener;
        return this;
    }

    @Override
    public void run() {
        block10: {
            try {
                this.serverSocket = new ServerSocket(this.port);
                CharacterBuffer buffer = new CharacterBuffer();
                while (this.serverSocket != null) {
                    try {
                        int c;
                        Socket clientSocket = this.serverSocket.accept();
                        buffer.clear();
                        InputStreamReader isr = new InputStreamReader(clientSocket.getInputStream());
                        BufferedReader br = new BufferedReader(isr);
                        while ((c = br.read()) != -1 && c != 32) {
                            buffer.with((char)c);
                        }
                        String type = buffer.toString();
                        buffer.clear();
                        while ((c = br.read()) != -1 && c != 32) {
                            buffer.with((char)c);
                        }
                        if (buffer.charAt(0) == '/') {
                            buffer.withStartPosition(1);
                        }
                        PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                        SimpleEvent event = new SimpleEvent(clientSocket, buffer.toString(), br, out);
                        event.withType(type);
                        if (this.allowListener != null && !this.allowListener.update(event)) {
                            out.write("HTTP 403");
                            out.close();
                            clientSocket.close();
                            continue;
                        }
                        String result = this.executeRequest(event);
                        out.write(result);
                        out.close();
                        clientSocket.close();
                    }
                    catch (Exception e) {
                        if (this.errorListener != null) {
                            this.errorListener.update(e);
                            continue;
                        }
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                if (this.errorListener == null) break block10;
                this.errorListener.update(e);
            }
        }
    }

    @Override
    public boolean close() {
        if (this.serverSocket == null || this.serverSocket.isClosed()) {
            return true;
        }
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean isRun() {
        return this.serverSocket != null && !this.serverSocket.isClosed();
    }

    public String executeRequest(String request) {
        SimpleEvent event = new SimpleEvent(this, request, null, null);
        return this.executeRequest(event);
    }

    public String executeRequest(SimpleEvent socketRequest) {
        if (socketRequest == null) {
            return null;
        }
        String type = socketRequest.getType();
        if ("GET".equalsIgnoreCase(type) || "".equals(type) || "new".equalsIgnoreCase(type)) {
            return this.getExecute(socketRequest);
        }
        if ("POST".equalsIgnoreCase(type)) {
            return this.postExecute(socketRequest);
        }
        if ("PUT".equalsIgnoreCase(type)) {
            return this.putExecute(socketRequest);
        }
        if ("PATCH".equalsIgnoreCase(type)) {
            return this.patchExecute(socketRequest);
        }
        if ("DELETE".equalsIgnoreCase(type)) {
            return this.deleteExecute(socketRequest);
        }
        return null;
    }

    private Object getElement(CharacterBuffer request, CharacterBuffer path, CharacterBuffer listID, boolean lastElement) {
        int pos = 0;
        SendableEntityCreator creator = this.creator;
        if (request.startsWith(JSON, 0, false)) {
            pos = 6;
        } else if (request.startsWith(XML, 0, false)) {
            pos = 5;
        }
        Object element = this.root;
        Object last = this.root;
        CharacterBuffer oldPath = new CharacterBuffer();
        while (pos < request.length()) {
            if (request.charAt(pos) == '[') {
                listID.clear();
                ++pos;
                while (pos < request.length() && request.charAt(pos) != ']') {
                    listID.with(request.charAt(pos));
                    ++pos;
                }
                ++pos;
            }
            if (request.charAt(pos) != '/' && pos < request.length()) {
                path.with(request.charAt(pos));
                ++pos;
            }
            if (request.charAt(pos) != '/' && (pos != request.length() || path.length() <= 0)) continue;
            last = element;
            oldPath.set(path.toString());
            element = creator.getValue(element, path.toString());
            if (element == null) break;
            if (element instanceof Collection) {
                Iterator i;
                int temp;
                String id = listID.toString();
                try {
                    temp = Integer.parseInt(id);
                }
                catch (NumberFormatException e) {
                    temp = -1;
                }
                Collection collection = (Collection)element;
                if (temp < 0) {
                    Object item = null;
                    i = collection.iterator();
                    if (id.length() > 0) {
                        element = null;
                        while (i.hasNext()) {
                            item = i.next();
                            if (!id.equals(this.map.getId(item, true))) continue;
                            last = element;
                            oldPath.set(path.toString());
                            element = item;
                            break;
                        }
                    } else if (collection.size() == 1) {
                        last = element;
                        oldPath.set(path.toString());
                        element = i.next();
                    }
                } else {
                    last = element;
                    oldPath.set(path.toString());
                    element = null;
                    int collectionPos = 0;
                    i = collection.iterator();
                    while (i.hasNext()) {
                        if (collectionPos == temp) {
                            element = i.next();
                            break;
                        }
                        i.next();
                        ++collectionPos;
                    }
                }
            }
            creator = this.map.getCreatorClass(element);
            path.clear();
            listID.clear();
            ++pos;
        }
        if (lastElement) {
            path.set(oldPath.toString());
            return last;
        }
        return element;
    }

    private String getExecute(SimpleEvent socketRequest) {
        CharacterBuffer path = new CharacterBuffer();
        CharacterBuffer listID = new CharacterBuffer();
        CharacterBuffer request = new CharacterBuffer().with(socketRequest.getPropertyName());
        Object element = this.getElement(request, path, listID, false);
        if (element == this.root) {
            if (path.length() > 0) {
                element = null;
            } else if (listID.length() > 0) {
                element = this.map.getObject(listID.toString());
            }
        }
        boolean isXML = false;
        if (!request.startsWith(JSON, 0, false) && request.startsWith(XML, 0, false)) {
            isXML = true;
        }
        if (element != null) {
            if (isXML) {
                XMLEntity xml = this.map.toXMLEntity(element, this.filter);
                return xml.toString();
            }
            if (element instanceof Collection) {
                JsonArray jsonArray = this.map.toJsonArray(element, this.filter);
                return jsonArray.toString();
            }
            JsonObject jsonObject = this.map.toJsonObject(element, this.filter);
            return jsonObject.toString();
        }
        return ERROR404;
    }

    private String deleteExecute(SimpleEvent socketRequest) {
        CharacterBuffer path = new CharacterBuffer();
        CharacterBuffer listID = new CharacterBuffer();
        CharacterBuffer request = new CharacterBuffer().with(socketRequest.getPropertyName());
        Object element = this.getElement(request, path, listID, false);
        if (element != null) {
            this.map.removeObj(element, true);
            return OK;
        }
        return ERROR404;
    }

    private String postExecute(SimpleEvent socketRequest) {
        if (socketRequest == null) {
            return ERROR404;
        }
        try {
            Object source = socketRequest.getSource();
            if (!(source instanceof Socket)) {
                return ERROR404;
            }
            BufferedReader br = (BufferedReader)socketRequest.getOldValue();
            String propertyName = socketRequest.getPropertyName();
            CharacterBuffer path = new CharacterBuffer();
            CharacterBuffer listID = new CharacterBuffer();
            CharacterBuffer request = new CharacterBuffer().with(socketRequest.getPropertyName());
            Object element = this.getElement(request, path, listID, true);
            CharacterBuffer buffer = new CharacterBuffer();
            int c = br.read();
            int pos = 0;
            boolean found = false;
            while ((c = br.read()) != -1) {
                if (c == LENGTH.charAt(pos)) {
                    if (++pos == LENGTH.length()) {
                        found = true;
                        break;
                    }
                } else {
                    pos = 0;
                }
                buffer.with((char)c);
            }
            int length = 0;
            if (found) {
                while ((c = br.read()) != -1) {
                    if (c == 32) continue;
                    if (c < 48 || c > 57) break;
                    length = length * 10 + c - 48;
                }
                char[] item = new char[length];
                while ((c = br.read()) != -1 && (c == 13 || c == 10 || c == 32)) {
                }
                item[0] = (char)c;
                br.read(item, 1, item.length - 1);
                CharacterBuffer entry = new CharacterBuffer();
                entry.with(item, 0, item.length);
                if (entry.charAt(0) == '{' || entry.charAt(0) == '<') {
                    Object child = this.map.decode(entry);
                    SendableEntityCreator creator = this.map.getCreatorClass(element);
                    if (creator != null) {
                        creator.setValue(element, propertyName, child, "new");
                    }
                    return OK;
                }
                SimpleKeyValueList child = new SimpleKeyValueList().withKeyValueString(entry.toString(), String.class);
                String className = child.getString("class");
                SendableEntityCreator childCreator = this.map.getCreator(className, false);
                Object childValue = childCreator.getSendableInstance(false);
                for (int i = 0; i < child.size(); ++i) {
                    String key = (String)child.getKeyByIndex(i);
                    if ("class".equalsIgnoreCase(key)) continue;
                    childCreator.setValue(childValue, (String)child.getKeyByIndex(i), child.getValueByIndex(i), "new");
                }
                this.creator.setValue(element, propertyName, childValue, "new");
                return OK;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ERROR404;
    }

    private String putExecute(SimpleEvent socketRequest) {
        return ERROR404;
    }

    private String patchExecute(SimpleEvent socketRequest) {
        return ERROR404;
    }

    public void stop() {
        block3: {
            if (this.serverSocket != null) {
                try {
                    ServerSocket socket = this.serverSocket;
                    this.serverSocket = null;
                    socket.close();
                }
                catch (IOException e) {
                    if (this.errorListener == null) break block3;
                    this.errorListener.update(e);
                }
            }
        }
    }
}

