/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.buffer;

import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.CharacterBuffer;

public abstract class BufferedBuffer
extends Buffer {
    protected int length;
    int start;

    public boolean back() {
        if (this.position > 0) {
            --this.position;
            return true;
        }
        return false;
    }

    public BufferedBuffer withPosition(int value) {
        this.position = value;
        return this;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isEnd() {
        if (this.position() - this.start + 1 < 0) {
            return true;
        }
        return this.position() - this.start + 1 >= this.length();
    }

    public boolean isEndCharacter() {
        if (this.position() - this.start + 1 >= this.length()) {
            return true;
        }
        return this.nextClean(true) == '\u0000';
    }

    public BufferedBuffer withLength(int value) {
        this.length = value;
        return this;
    }

    public abstract BufferedBuffer newInstance();

    public abstract byte byteAt(int var1);

    public abstract char charAt(int var1);

    @Override
    public char getCurrentChar() {
        return this.charAt(this.position());
    }

    public abstract CharacterBuffer subSequence(int var1, int var2);

    @Override
    public BufferedBuffer withLookAHead(CharSequence lookahead) {
        if (lookahead == null) {
            return this;
        }
        this.withPosition(this.position() - lookahead.length() + 1);
        return this;
    }

    @Override
    public BufferedBuffer withLookAHead(char lookahead) {
        if (lookahead < '\u0000') {
            return this;
        }
        this.withPosition(this.position() - 1);
        return this;
    }

    @Override
    protected CharacterBuffer parseString(CharacterBuffer sc, boolean allowQuote, boolean nextStep, char ... quotes) {
        char c;
        if (quotes == null) {
            sc.with(this.getCurrentChar());
            return sc;
        }
        int startpos = this.position();
        char b = this.getCurrentChar();
        int quoteLen = quotes.length;
        block4: do {
            c = this.getChar();
            switch (c) {
                case '\u0000': {
                    c = '\u0000';
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (b != '\\') break;
                    if (c == '\\' && allowQuote) {
                        c = '\u0000';
                    }
                    if (!allowQuote) break;
                    b = c;
                    c = '\u0001';
                    continue block4;
                }
            }
            b = c;
            for (int i = 0; i < quoteLen; ++i) {
                if (c != quotes[i]) continue;
                c = '\u0000';
                continue block4;
            }
        } while (c != '\u0000');
        int endPos = this.position();
        if (nextStep) {
            this.skip();
        }
        sc.with(this.subSequence(startpos, endPos));
        return sc;
    }

    public String getNextString(int n) {
        int pos = 0;
        if (n < -1) {
            char[] chars = new char[n *= -1];
            while (pos < n) {
                chars[pos] = this.charAt(this.position() - (n - pos++));
            }
            return new String(chars);
        }
        if (n == -1) {
            n = this.length() - this.position();
        } else {
            if (n == 0) {
                return "";
            }
            if (this.position() + n > this.length()) {
                n = this.length() - this.position();
            }
        }
        char[] chars = new char[n];
        while (pos < n) {
            chars[pos] = this.charAt(this.position() + pos++);
        }
        return new String(chars);
    }

    @Override
    protected CharacterBuffer nextValue(char c, boolean allowDuppleMark) {
        int start = this.position();
        if (allowDuppleMark) {
            while (c >= ' ' && ",]}/\\\"[{;=# ".indexOf(c) < 0) {
                c = this.getChar();
            }
        } else {
            while (c >= ' ' && ",:]}/\\\"[{;=# ".indexOf(c) < 0) {
                c = this.getChar();
            }
        }
        CharacterBuffer sb = this.subSequence(start, this.position()).trim();
        return sb;
    }

    public String nextString(int count) {
        int start = this.position();
        CharacterBuffer sb = this.subSequence(start, start + count).trim();
        return sb.toString();
    }

    @Override
    public String substring(int ... positions) {
        if (positions == null || positions.length < 1) {
            positions = new int[]{-1};
        }
        int start = positions[0];
        int end = -1;
        if (positions.length < 2) {
            end = this.length();
            if (start == -1) {
                start = this.position();
            }
        } else {
            end = positions[1];
        }
        if (end == -1) {
            end = this.position();
        } else if (end == 0) {
            if (start < 0) {
                end = this.position();
                start = this.position() + start;
            } else {
                end = this.position() + start;
                if (this.position() + end > this.length()) {
                    end = this.length();
                }
                start = this.position();
            }
        }
        if (start < 0 || end <= 0 || start > end) {
            return "";
        }
        return this.subSequence(start, end).toString();
    }

    public byte[] toBytes(boolean ... all) {
        byte[] result;
        int i = this.start;
        if (all != null && all.length > 0 && all[0]) {
            result = new byte[this.length];
        } else {
            result = new byte[this.length - this.position];
            i = this.position;
        }
        while (i < result.length) {
            result[i] = this.byteAt(i);
            ++i;
        }
        return result;
    }

    public String toArrayString(boolean ... addString) {
        CharacterBuffer sb = new CharacterBuffer();
        sb.with('[');
        byte[] byteArray = this.toBytes(new boolean[0]);
        if (byteArray != null && byteArray.length > 0) {
            sb.with("" + byteArray[0]);
            for (int i = 1; i < this.length; ++i) {
                sb.with("," + byteArray[i]);
            }
        }
        sb.with(']');
        if (addString != null && addString.length > 0 && addString[0]) {
            sb.with(' ').with('(').with(new String(byteArray)).with(')');
        }
        return sb.toString();
    }

    public final void clear() {
        this.length = 0;
        this.start = 0;
        this.position = 0;
    }

    public abstract BufferedBuffer with(char[] var1, int var2, int var3);

    public abstract BufferedBuffer with(CharSequence ... var1);
}

