/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.yaml;

import de.uniks.networkparser.Tokener;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.yaml.YamlItem;

public class YAMLTokener
extends Tokener {
    public static final char DASH = '-';
    public static final String STOPCHARS = "=# ";
    public static final char RETURN = '\n';
    private SimpleKeyValueList<Object, SimpleKeyValueList<String, SimpleList<String>>> refs;

    @Override
    public void parseToEntity(EntityList entity) {
        this.parseLine(0, entity);
    }

    protected int parseLine(int deep, EntityList owner) {
        char c = this.getCurrentChar();
        int newDeep = 0;
        boolean read = false;
        BaseItem item = null;
        do {
            if (read) {
                c = this.getChar();
            }
            read = true;
            if (c == ' ') {
                ++newDeep;
                continue;
            }
            if (newDeep < deep) {
                return newDeep;
            }
            if (c == '\r') {
                c = this.getChar();
            }
            if (c == '\n') {
                this.parseLine(newDeep, owner);
                c = '\u0000';
                continue;
            }
            CharacterBuffer buffer = null;
            switch (c) {
                case '\u0000': {
                    break;
                }
                case '=': {
                    break;
                }
                case '-': {
                    c = this.getChar();
                    if (c == ' ') {
                        item = deep <= newDeep ? owner.getNewList(false) : owner.getNewList(true);
                    }
                }
                default: {
                    if (buffer == null) {
                        buffer = new CharacterBuffer();
                    }
                    buffer.with(c);
                }
            }
        } while (c != '\u0000');
        if (this.buffer != null && owner != null) {
            if (item == null) {
                item = owner.getNewList(false);
            }
            if (item instanceof YamlItem) {
                ((YamlItem)item).withKey(this.buffer.toString());
            }
            owner.add(item);
        }
        return newDeep;
    }

    public Object decode(String yaml) {
        this.buffer = new CharacterBuffer().with(yaml);
        Object root = null;
        this.refs = new SimpleKeyValueList();
        while (!this.buffer.isEnd()) {
            if ('-' != this.buffer.getCurrentChar()) {
                this.buffer.printError("'-' expected");
                continue;
            }
            this.buffer.skipChar('-');
            CharacterBuffer key = this.buffer.nextString();
            if (key.endsWith(":", true)) {
                Object returnValue = this.parseUsualObjectAttrs(key);
                if (root != null) continue;
                root = returnValue;
                continue;
            }
            this.parseObjectTableAttrs(key);
        }
        if (this.refs.size() > 0) {
            for (int o = 0; o < this.refs.size(); ++o) {
                Object entity = this.refs.getKeyByIndex(o);
                SendableEntityCreator creator = this.map.getCreatorClass(entity);
                SimpleKeyValueList<String, SimpleList<String>> entityRefs = this.refs.getValueByIndex(o);
                for (int r = 0; r < entityRefs.size(); ++r) {
                    String attribute = entityRefs.getKeyByIndex(r);
                    SimpleList<String> valueRefs = entityRefs.getValueByIndex(r);
                    for (String ref : valueRefs) {
                        Object value = this.map.getObject(ref);
                        if (value == null) continue;
                        creator.setValue(entity, attribute, value, "new");
                    }
                }
            }
        }
        return root;
    }

    private void parseObjectTableAttrs(CharacterBuffer currentToken) {
        if (currentToken == null || this.map == null) {
            return;
        }
        String className = currentToken.toString();
        SendableEntityCreator creator = this.map.getCreator(className, false);
        currentToken = this.buffer.nextString();
        SimpleList<String> colNameList = new SimpleList<String>();
        while (currentToken.length() > 0 && currentToken.endsWith(":", true)) {
            colNameList.add(currentToken.rtrim(':').toString());
            this.buffer.skipChar(' ');
            if (this.buffer.getCurrentChar() == '\n') {
                currentToken = this.buffer.nextString();
                break;
            }
            currentToken = this.buffer.nextString();
        }
        while (currentToken.length() > 0 && !currentToken.equals("-")) {
            String objectId = currentToken.rtrim(':').toString();
            currentToken = this.buffer.nextString();
            Object obj = this.map.getObject(objectId);
            if (obj == null) {
                obj = creator.getSendableInstance(false);
                this.map.put(objectId, obj, false);
            }
            int colNum = 0;
            while (currentToken.length() > 0 && !currentToken.endsWith(":", true) && !currentToken.equals("-")) {
                String attrName = (String)colNameList.get(colNum);
                if (currentToken.startsWith("[")) {
                    String value = currentToken.substring(1);
                    if (value.trim().equals("")) {
                        value = this.buffer.nextString().toString();
                    }
                    this.setValue(creator, obj, attrName, value);
                    while (currentToken.length() > 0 && !currentToken.endsWith("]", true)) {
                        currentToken = this.buffer.nextString();
                        value = currentToken.toString();
                        if (currentToken.endsWith("]", true)) {
                            value = currentToken.substring(0, currentToken.length() - 1);
                        }
                        if (value.trim().equals("")) continue;
                        this.setValue(creator, obj, attrName, value);
                    }
                } else {
                    this.setValue(creator, obj, attrName, currentToken.toString());
                }
                ++colNum;
                currentToken = this.buffer.nextString();
            }
            if (!currentToken.equals("-")) continue;
            this.buffer.withLookAHead('-');
        }
    }

    private Object parseUsualObjectAttrs(CharacterBuffer currentToken) {
        if (this.buffer == null || currentToken == null || this.map == null) {
            return null;
        }
        String objectId = currentToken.trimEnd(1).toString();
        String className = this.buffer.nextString().rtrim(new char[0]).toString();
        currentToken = this.buffer.nextString();
        SendableEntityCreator creator = this.map.getCreator(className, false);
        Object obj = this.map.getObject(objectId);
        if (obj == null) {
            obj = creator.getSendableInstance(false);
            this.map.put(objectId, obj, false);
        }
        while (!currentToken.equals("") && !currentToken.equals("-")) {
            String attrName = currentToken.rtrim(':').toString();
            currentToken = this.buffer.nextString();
            while (!(currentToken.equals("") || currentToken.endsWith(":", true) || currentToken.equals("-"))) {
                String attrValue = currentToken.toString();
                this.setValue(creator, obj, attrName, attrValue);
                currentToken = this.buffer.nextString();
            }
            if (!currentToken.equals("-")) continue;
            this.buffer.withLookAHead('-');
        }
        return obj;
    }

    private boolean setValue(SendableEntityCreator creator, Object obj, String attrName, String attrValue) {
        if (this.map == null) {
            return false;
        }
        Object targetObj = this.map.getObject(attrValue);
        if (targetObj != null) {
            try {
                creator.setValue(obj, attrName, targetObj, "new");
            }
            catch (Exception e) {
                creator.setValue(obj, attrName, attrValue, "new");
            }
            return true;
        }
        SimpleKeyValueList<String, SimpleList<String>> values = this.refs.get(obj);
        try {
            SimpleList<String> valueNames;
            if (values != null && (valueNames = values.get(attrName)) != null) {
                valueNames.add(attrValue);
                return true;
            }
            creator.setValue(obj, attrName, attrValue, "new");
        }
        catch (Exception e) {
            SimpleList<String> valueNames;
            if (values == null) {
                values = new SimpleKeyValueList();
                this.refs.put(obj, values);
            }
            if ((valueNames = values.get(attrName)) != null) {
                valueNames.add(attrValue);
            }
            valueNames = new SimpleList();
            valueNames.add(attrValue);
            values.put(attrName, valueNames);
        }
        return true;
    }
}

