/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.ext.petaf.ModelThread;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public class UpdateModel
implements Callable<Object>,
Runnable,
Supplier<Object> {
    private Object newValue;
    private String property;
    private Object entity;
    private ModelThread owner;
    private String id;

    public UpdateModel(ModelThread owner, Object element, String property, Object newValue) {
        this.owner = owner;
        this.entity = element;
        this.property = property;
        this.newValue = newValue;
    }

    public UpdateModel(ModelThread owner, String id, String property) {
        this.owner = owner;
        this.id = id;
        this.property = property;
    }

    public UpdateModel withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public void run() {
        this.call();
    }

    @Override
    public Object get() {
        return this.call();
    }

    @Override
    public Object call() {
        try {
            IdMap map = this.owner.getMap();
            if (this.id != null && this.entity == null) {
                Object element = map.getObject(this.id);
                if (this.property != null) {
                    SendableEntityCreator creator = map.getCreatorClass(this.entity);
                    return creator.getValue(element, this.property);
                }
                return element;
            }
            if (this.entity instanceof String) {
                String className = (String)this.entity;
                SendableEntityCreator creator = map.getCreator(className, true);
                Object element = creator.getSendableInstance(true);
                if (this.id == null) {
                    this.id = map.getId(element, true);
                }
                map.put(this.id, element, false);
                return element;
            }
            if (map == null) {
                return null;
            }
            SendableEntityCreator creator = map.getCreatorClass(this.entity);
            Object element = this.entity;
            return creator.setValue(element, this.property, this.newValue, "new");
        }
        catch (Exception e) {
            this.owner.getErrorHandler().saveException(e, false);
            return false;
        }
    }
}

