/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf;

import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyServer;
import de.uniks.networkparser.interfaces.Server;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.DatagramChannel;
import java.util.Date;

public class Server_Time
extends Thread
implements Server {
    protected boolean run = true;
    private int port = 37;
    private NodeProxyServer proxy;
    private DatagramChannel channel;

    public Server_Time(NodeProxyServer proxy, boolean asyn) {
        this.proxy = proxy;
        if (this.init() && asyn) {
            this.start();
        }
    }

    public Server_Time(boolean asyn) {
        if (this.init() && asyn) {
            this.start();
        }
    }

    @Override
    public boolean close() {
        this.run = false;
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.channel = null;
        }
        return true;
    }

    @Override
    public boolean isRun() {
        return this.run;
    }

    @Override
    public void run() {
        this.runServer();
    }

    public void runServer() {
        Thread.currentThread().setName(this.port + " time server");
        ByteBuffer in = ByteBuffer.allocate(8192);
        ByteBuffer out = ByteBuffer.allocate(8);
        out.order(ByteOrder.BIG_ENDIAN);
        while (!this.isInterrupted() && this.run) {
            try {
                in.clear();
                SocketAddress client = this.channel.receive(in);
                out.clear();
                long secondsSince1900 = Server_Time.getTime();
                out.putLong(secondsSince1900);
                out.flip();
                out.position(4);
                this.channel.send(out, client);
            }
            catch (IOException iOException) {}
        }
    }

    public Server_Time withPort(int value) {
        this.port = value;
        return this;
    }

    private boolean init() {
        boolean success = true;
        try {
            if (this.proxy != null && NodeProxy.isInput(this.proxy.getType())) {
                this.port = this.proxy.getPort();
            }
            InetSocketAddress address = new InetSocketAddress(this.port);
            this.channel = DatagramChannel.open();
            DatagramSocket socket = this.channel.socket();
            socket.bind(address);
        }
        catch (SocketException e) {
            success = false;
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    private static long getTime() {
        long differenceBetweenEpochs = 2208988800L;
        Date now = new Date();
        long secondsSince1970 = now.getTime() / 1000L;
        long secondsSince1900 = secondsSince1970 + differenceBetweenEpochs;
        return secondsSince1900;
    }
}

