/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx.dialog;

import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.javafx.JavaAdapter;
import de.uniks.networkparser.ext.javafx.JavaBridgeFX;
import de.uniks.networkparser.ext.javafx.dialog.DialogPane;
import de.uniks.networkparser.ext.javafx.dialog.DialogStage;
import de.uniks.networkparser.gui.controls.Button;
import de.uniks.networkparser.gui.controls.Control;
import de.uniks.networkparser.gui.controls.Label;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.list.SimpleSet;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DialogBox
implements ObjectCondition {
    protected static final int HEADER_HEIGHT = 28;
    protected static final URL DIALOGS_CSS_URL = DialogBox.class.getResource("dialogs.css");
    boolean alwaysOnTop;
    boolean modal = true;
    private SimpleSet<Control> titleElements = new SimpleSet();
    private SimpleSet<Control> actionElements = new SimpleSet();
    private double mouseDragDeltaY;
    private double mouseDragDeltaX;
    protected static final Object ACTIVE_PSEUDO_CLASS = ReflectionLoader.call("getPseudoClass", ReflectionLoader.PSEUDOCLASS, "active");
    protected Object dialogTitleBar;
    private Object root;
    private Object stage;
    private Object originalParent;
    Button action;
    private Object owner;
    private Label titleElement = new Label().withType("title");
    private boolean isInline;
    private boolean iconified;
    private Object center;

    public DialogBox() {
        this.titleElements.add(this.titleElement);
        this.titleElements.add(new Label().withType("spacer"));
        this.titleElements.add(new Button().withActionType("close", this));
    }

    public DialogBox withTitle(String value) {
        if (value != null) {
            this.titleElement.setValue(value);
        }
        return this;
    }

    public Button show(Object owner) {
        Object title;
        if (this.titleElement.length() < 1 && (title = ReflectionLoader.call("getTitle", owner, new Object[0])) != null) {
            this.titleElement.setValue((String)title);
        }
        if (this.isInline) {
            return this.showIntern(owner);
        }
        return this.showExtern(owner);
    }

    private Button showIntern(Object parent) {
        this.stage = parent;
        Object scene = ReflectionLoader.call("getScene", this.stage, new Object[0]);
        this.configScene();
        this.originalParent = ReflectionLoader.call("getRoot", scene, new Object[0]);
        this.createContent();
        DialogPane myPane = new DialogPane(this, this.originalParent);
        ReflectionLoader.call("pseudoClassStateChanged", this.root, ReflectionLoader.PSEUDOCLASS, ACTIVE_PSEUDO_CLASS, Boolean.TYPE, true);
        ReflectionLoader.call("setRoot", scene, ReflectionLoader.PARENT, myPane.getPane());
        ReflectionLoader.call("setVisible", this.root, Boolean.TYPE, true);
        if (this.originalParent != null) {
            JavaBridgeFX.addChildren(myPane.getPane(), 0, this.originalParent);
            Map properties = (Map)ReflectionLoader.call("getProperties", this.originalParent, new Object[0]);
            Map dialogProperties = (Map)ReflectionLoader.call("getProperties", myPane.getPane(), new Object[0]);
            dialogProperties.putAll(properties);
        }
        ReflectionLoader.call("requestFocus", this.root, new Object[0]);
        JavaAdapter.execute(myPane);
        return null;
    }

    public void hide(Button value) {
        if (this.action == null) {
            this.setAction(value);
        }
    }

    public void setAction(Button value) {
        this.action = value;
        if (this.isInline) {
            ReflectionLoader.call("setVisible", this.root, Boolean.TYPE, false);
            Object scene = ReflectionLoader.call("getScene", this.stage, new Object[0]);
            Object oldParent = ReflectionLoader.call("getRoot", scene, new Object[0]);
            JavaBridgeFX.removeChildren(oldParent, this.originalParent);
            JavaBridgeFX.removeStyle(this.originalParent, "root");
            ReflectionLoader.call("setRoot", scene, ReflectionLoader.PARENT, this.originalParent);
            return;
        }
        if (this.stage != null) {
            ReflectionLoader.call("hide", this.stage, new Object[0]);
        }
    }

    public void minimize() {
        if (this.stage != null) {
            ReflectionLoader.call("setIconified", this.stage, this.iconified);
        }
    }

    public void maximize() {
        if (this.isInline) {
            // empty if block
        }
        if (this.stage != null) {
            ReflectionLoader.call("setFullScreen", this.stage, true);
        }
    }

    protected double getOverlayWidth() {
        if (this.owner != null) {
            return (Double)ReflectionLoader.callChain(this.owner, "getLayoutBounds", "getWidth");
        }
        if (this.stage != null) {
            return (Double)ReflectionLoader.callChain(this.stage, "getScene", "getWidth");
        }
        return 0.0;
    }

    protected double getOverlayHeight() {
        if (this.owner != null) {
            return (Double)ReflectionLoader.callChain(this.owner, "getLayoutBounds", "getHeight");
        }
        if (this.stage != null) {
            return (Double)ReflectionLoader.callChain(this.stage, "getScene", "getHeight");
        }
        return 0.0;
    }

    private Button showExtern(Object owner) {
        Object toolKit = ReflectionLoader.call("getToolkit", ReflectionLoader.TOOLKITFX, new Object[0]);
        Object isFX = ReflectionLoader.call("isFxUserThread", toolKit, new Object[0]);
        if (isFX != null && ((Boolean)isFX).booleanValue()) {
            new DialogStage(this, owner).run();
            return this.action;
        }
        JavaAdapter.execute(new DialogStage(this, owner));
        return null;
    }

    public DialogBox withInline(boolean value) {
        this.isInline = value;
        return this;
    }

    public DialogBox withAlwaysOnTop(boolean value) {
        this.alwaysOnTop = value;
        return this;
    }

    public DialogBox withModal(boolean modal) {
        this.modal = modal;
        return this;
    }

    void configScene() {
        List list;
        Object styleSheet;
        Object scene = ReflectionLoader.call("getScene", this.stage, new Object[0]);
        String dialogsCssUrl = DIALOGS_CSS_URL.toExternalForm();
        if (scene == null && this.owner != null) {
            scene = ReflectionLoader.call("getScene", this.owner, new Object[0]);
        }
        if (scene != null && (styleSheet = ReflectionLoader.call("getStylesheets", scene, new Object[0])) instanceof List && !(list = (List)styleSheet).contains(dialogsCssUrl)) {
            list.add(dialogsCssUrl);
        }
    }

    public void createContent() {
        this.root = ReflectionLoader.newInstance(ReflectionLoader.BORDERPANE, new Object[0]);
        JavaBridgeFX.setStyle(this.root, false, "dialog", "decorated-root");
        ObjectCondition condition = new ObjectCondition(){

            @Override
            public boolean update(Object value) {
                boolean active = (Boolean)value;
                ReflectionLoader.call("pseudoClassStateChanged", DialogBox.this.root, ReflectionLoader.PSEUDOCLASS, ACTIVE_PSEUDO_CLASS, Boolean.TYPE, active);
                return true;
            }
        };
        Object property = ReflectionLoader.call("focusedProperty", this.stage, new Object[0]);
        JavaBridgeFX.addListener(property, "addListener", ReflectionLoader.CHANGELISTENER, condition);
        this.dialogTitleBar = ReflectionLoader.newInstance(ReflectionLoader.TOOLBAR, new Object[0]);
        JavaBridgeFX.setStyle(this.dialogTitleBar, false, "window-header");
        ReflectionLoader.call("setPrefHeight", this.dialogTitleBar, Double.TYPE, 28);
        ReflectionLoader.call("setMinHeight", this.dialogTitleBar, Double.TYPE, 28);
        ReflectionLoader.call("setMaxHeight", this.dialogTitleBar, Double.TYPE, 28);
        for (Control control : this.titleElements) {
            Object guiElement = JavaBridgeFX.convert(control, true);
            JavaBridgeFX.addChildren(this.dialogTitleBar, -1, guiElement);
        }
        condition = new ObjectCondition(){

            @Override
            public boolean update(Object event) {
                DialogBox.this.mouseDragDeltaX = (Double)ReflectionLoader.call("getSceneX", event, new Object[0]);
                DialogBox.this.mouseDragDeltaY = (Double)ReflectionLoader.call("getSceneY", event, new Object[0]);
                return true;
            }
        };
        JavaBridgeFX.addListener(this.dialogTitleBar, "setOnMousePressed", ReflectionLoader.EVENTHANDLER, condition);
        condition = new ObjectCondition(){

            @Override
            public boolean update(Object event) {
                double eventX = (Double)ReflectionLoader.call("getScreenX", event, new Object[0]) - DialogBox.this.mouseDragDeltaX;
                double eventY = (Double)ReflectionLoader.call("getScreenY", event, new Object[0]) - DialogBox.this.mouseDragDeltaY;
                if (DialogBox.this.isInline) {
                    double x = (Double)ReflectionLoader.call("getLayoutX", DialogBox.this.root, new Object[0]);
                    double y = (Double)ReflectionLoader.call("getLayoutY", DialogBox.this.root, new Object[0]);
                    ReflectionLoader.call("setLayoutX", DialogBox.this.root, Double.TYPE, x + eventX);
                    ReflectionLoader.call("setLayoutY", DialogBox.this.root, Double.TYPE, y + eventY);
                } else {
                    ReflectionLoader.call("setX", DialogBox.this.stage, Double.TYPE, eventX);
                    ReflectionLoader.call("setY", DialogBox.this.stage, Double.TYPE, eventY);
                }
                return true;
            }
        };
        JavaBridgeFX.addListener(this.dialogTitleBar, "setOnMouseDragged", ReflectionLoader.EVENTHANDLER, condition);
        ReflectionLoader.call("setTop", this.root, ReflectionLoader.NODE, this.dialogTitleBar);
        ReflectionLoader.call("setCenter", this.root, ReflectionLoader.NODE, this.center);
        if (this.actionElements.size() > 0) {
            Object actionToolbar = ReflectionLoader.newInstance(ReflectionLoader.HBOX, new Object[0]);
            JavaBridgeFX.setStyle(actionToolbar, false, "window-action");
            for (Control item : this.actionElements) {
                Object guiElement = JavaBridgeFX.convert(item, false);
                JavaBridgeFX.addChildren(actionToolbar, -1, guiElement);
            }
            Object object = ReflectionLoader.getField("TOP_RIGHT", ReflectionLoader.POS);
            ReflectionLoader.call("setAlignment", actionToolbar, ReflectionLoader.POS, object);
            ReflectionLoader.call("setBottom", this.root, ReflectionLoader.NODE, actionToolbar);
        }
    }

    public DialogBox withCenter(Object node) {
        this.center = node;
        return this;
    }

    public DialogBox withTitleButton(int index, Control ... value) {
        if (value == null) {
            return this;
        }
        ArrayList<Control> items = new ArrayList<Control>();
        for (Control item : value) {
            items.add(item);
        }
        this.titleElements.addAll(index, items);
        return this;
    }

    public DialogBox withTitleButton(Control ... value) {
        if (value == null) {
            return this;
        }
        for (Control item : value) {
            this.titleElements.add(item);
        }
        return this;
    }

    public DialogBox withActionButton(int index, Control ... value) {
        if (value == null) {
            return this;
        }
        ArrayList<Control> items = new ArrayList<Control>();
        for (Control item : value) {
            items.add(item);
        }
        this.actionElements.addAll(index, items);
        return this;
    }

    public DialogBox withActionButton(Control ... value) {
        if (value == null) {
            return this;
        }
        for (Control item : value) {
            this.actionElements.add(item);
        }
        return this;
    }

    public DialogBox withCenterInfo(String value) {
        this.withCenterText("information.png", value);
        return this;
    }

    public DialogBox withCenterQuestion(String value) {
        this.withCenterText("confirm.png", value);
        return this;
    }

    public DialogBox withCenterText(String image, String value) {
        Object box = ReflectionLoader.newInstance(ReflectionLoader.HBOX, new Object[0]);
        URL resource = DialogBox.class.getResource(image);
        if (resource == null) {
            return this;
        }
        Object imageView = ReflectionLoader.newInstance(ReflectionLoader.IMAGEVIEW, String.class, resource.toString());
        Object text = ReflectionLoader.newInstance(ReflectionLoader.LABEL, String.class, value);
        JavaBridgeFX.setStyle(text, false, "labelText");
        Object vBox = ReflectionLoader.newInstance(ReflectionLoader.VBOX, new Object[0]);
        Object pos = ReflectionLoader.getField("CENTER", ReflectionLoader.POS);
        ReflectionLoader.call("setAlignment", vBox, ReflectionLoader.POS, pos);
        JavaBridgeFX.addChildren(vBox, -1, text);
        JavaBridgeFX.addChildren(box, -1, imageView, vBox);
        JavaBridgeFX.setStyle(box, false, "centerbox");
        this.center = box;
        return this;
    }

    public static Button showInfo(Object parent, String title, String text, boolean inLine) {
        DialogBox dialogBox = new DialogBox().withTitle(title).withCenterInfo(text).withInline(inLine);
        return dialogBox.withActionButton(new Button().withActionType("close", dialogBox).withValue("OK")).show(parent);
    }

    public static Button showInfo(String title, String text) {
        DialogBox dialogBox = new DialogBox().withTitle(title).withCenterInfo(text);
        return dialogBox.withActionButton(new Button().withValue("OK").withActionType("close", dialogBox)).show(null);
    }

    public static Button showQuestion(Object parent, String title, String text) {
        DialogBox dialogBox = new DialogBox().withTitle(title).withCenterInfo(text);
        return dialogBox.withActionButton(new Button().withValue("Yes").withActionType("close", dialogBox), new Button().withValue("No").withActionType("close", dialogBox)).show(parent);
    }

    public static boolean createQuestionCheck(Object parent, String title, String text, String ... check) {
        Button action = DialogBox.showQuestion(parent, title, text);
        if (action == null) {
            return false;
        }
        for (String item : check) {
            if (item == null || !item.equalsIgnoreCase((String)action.getValue())) continue;
            return true;
        }
        return false;
    }

    public Button getAction() {
        return this.action;
    }

    @Override
    public boolean update(Object value) {
        if (!(value instanceof Button)) {
            return false;
        }
        Button btn = (Button)value;
        if ("close".equalsIgnoreCase(btn.getActionType())) {
            this.hide(btn);
        }
        if ("minimize".equalsIgnoreCase(btn.getActionType())) {
            this.minimize();
        }
        if ("maximize".equalsIgnoreCase(btn.getActionType())) {
            this.maximize();
        }
        return true;
    }

    public double prefWidth(double value) {
        return (Double)ReflectionLoader.call("prefWidth", this.root, Double.TYPE, -1);
    }

    public double prefHeight(double value) {
        return (Double)ReflectionLoader.call("prefHeight", this.root, Double.TYPE, -1);
    }

    public void setStage(Object newStage) {
        this.stage = newStage;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isModel() {
        return this.modal;
    }

    public Object getScene() {
        return ReflectionLoader.call("getScene", this.stage, new Object[0]);
    }
}

