/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.io;

import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.ext.io.MQTTMessage;
import de.uniks.networkparser.ext.io.MessageSession;
import de.uniks.networkparser.ext.io.RabbitMessage;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyBroker;
import de.uniks.networkparser.interfaces.ObjectCondition;

public class ReaderComm
implements Runnable {
    private boolean running = false;
    private String threadName;
    private MessageSession session;
    private String channel;
    private NodeProxyBroker broker;
    private ObjectCondition condition;

    public void start(NodeProxyBroker broker, String threadName) {
        this.threadName = threadName;
        this.broker = broker;
        if (!this.running) {
            this.running = true;
        }
    }

    public ReaderComm withSession(MessageSession session) {
        this.session = session;
        return this;
    }

    public boolean stop() {
        if (this.running) {
            this.running = false;
            return this.session.close();
        }
        return false;
    }

    @Override
    public void run() {
        Thread recThread = Thread.currentThread();
        recThread.setName(this.threadName);
        if (this.session == null) {
            return;
        }
        while (this.running && !this.session.isClose()) {
            try {
                String text;
                Object msg;
                Object response = this.session.getServerResponse(this.broker);
                if (this.condition == null) continue;
                if (response instanceof RabbitMessage) {
                    msg = (RabbitMessage)response;
                    text = ((RabbitMessage)msg).getText();
                    if (text == null) continue;
                    this.condition.update(new SimpleEvent(this, this.channel, null, text).withType("Message"));
                    continue;
                }
                if (!(response instanceof MQTTMessage) || (text = ((MQTTMessage)(msg = (MQTTMessage)response)).getText()) == null) continue;
                String myChannel = this.channel;
                if (((MQTTMessage)msg).getNames() != null && ((MQTTMessage)msg).getNames().length > 0) {
                    myChannel = ((MQTTMessage)msg).getNames()[0];
                }
                this.condition.update(new SimpleEvent(this, myChannel, null, text).withType("Message"));
            }
            catch (Exception exception) {}
        }
    }

    public ReaderComm withCondition(ObjectCondition condition) {
        this.condition = condition;
        return this;
    }

    public ReaderComm withChannel(String name) {
        this.channel = name;
        return this;
    }
}

