/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.generic;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;

public class GenericCreator
implements SendableEntityCreator {
    private Object item;
    private Class<?> clazz;
    private String[] properties = null;
    private static final LinkedHashSet<String> badProperties = new LinkedHashSet();

    public GenericCreator() {
        badProperties.add("getClass");
        badProperties.add("getPropertyChangeSupport");
    }

    public GenericCreator(Object item) {
        this();
        this.withItem(item);
    }

    public GenericCreator withClass(String value) {
        try {
            this.clazz = Class.forName(value);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this;
    }

    public GenericCreator withClass(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public GenericCreator withItem(Object value) {
        this.item = value;
        if (this.item == null) {
            this.properties = new String[0];
        } else {
            this.clazz = this.item.getClass();
            Method[] methods = this.clazz.getMethods();
            LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
            for (Method method : methods) {
                String methodName = method.getName();
                String name = this.getValidMethod(methodName);
                if (name == null) continue;
                fieldNames.add(name.toLowerCase());
            }
            this.properties = fieldNames.toArray(new String[0]);
        }
        return this;
    }

    @Override
    public String[] getProperties() {
        return this.properties;
    }

    @Override
    public Object getSendableInstance(boolean prototype) {
        if (this.item != null) {
            return ReflectionLoader.newInstance(this.clazz, new Object[0]);
        }
        if (this.clazz != null) {
            return ReflectionLoader.newInstance(this.clazz, new Object[0]);
        }
        return null;
    }

    private String getMethodName(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (entity == null) {
            return null;
        }
        try {
            Method method = this.clazz.getMethod("get" + this.getMethodName(attribute), new Class[0]);
            Object invoke = method.invoke(entity, new Object[0]);
            return invoke;
        }
        catch (ReflectiveOperationException method) {
            try {
                Method method2 = this.clazz.getMethod(attribute, new Class[0]);
                Object invoke = method2.invoke(entity, new Object[0]);
                return invoke;
            }
            catch (ReflectiveOperationException method2) {
                try {
                    Field field = this.clazz.getDeclaredField(attribute);
                    if (!this.isAccess(field, entity)) {
                        field.setAccessible(true);
                        Object invoke = field.get(entity);
                        field.setAccessible(false);
                        return invoke;
                    }
                    Object invoke = field.get(entity);
                    return invoke;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    return null;
                }
            }
        }
    }

    private boolean setNewValue(Object entity, String methodName, Object value) {
        try {
            this.clazz.getMethod(methodName, value.getClass()).invoke(entity, value);
            return true;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            try {
                int intValue = Integer.parseInt("" + value);
                this.clazz.getMethod(methodName, Integer.TYPE).invoke(entity, intValue);
                return true;
            }
            catch (ReflectiveOperationException intValue) {
            }
            catch (NumberFormatException intValue) {
                // empty catch block
            }
            try {
                double doubleValue = Double.parseDouble("" + value);
                this.clazz.getMethod(methodName, Double.TYPE).invoke(entity, doubleValue);
                return true;
            }
            catch (ReflectiveOperationException doubleValue) {
            }
            catch (NumberFormatException doubleValue) {
                // empty catch block
            }
            try {
                float floatValue = Float.parseFloat("" + value);
                this.clazz.getMethod(methodName, Float.TYPE).invoke(entity, Float.valueOf(floatValue));
                return true;
            }
            catch (ReflectiveOperationException reflectiveOperationException2) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return false;
        }
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (entity == null) {
            return false;
        }
        if (this.setNewValue(entity, "set" + this.getMethodName(attribute), value)) {
            return true;
        }
        if (this.setNewValue(entity, "with" + this.getMethodName(attribute), value)) {
            return true;
        }
        if (attribute.endsWith("s") && this.setNewValue(entity, "addTo" + this.getMethodName(attribute), value)) {
            return true;
        }
        try {
            Field field = this.clazz.getDeclaredField(attribute);
            if (!this.isAccess(field, entity)) {
                field.setAccessible(true);
                field.set(entity, value);
                field.setAccessible(false);
                return true;
            }
            field.set(entity, value);
            return true;
        }
        catch (ReflectiveOperationException e) {
            System.out.println(e);
            return false;
        }
    }

    private boolean isAccess(Field field, Object entity) {
        Method method;
        try {
            method = field.getClass().getMethod("canAccess", Object.class);
            if (method != null) {
                return (Boolean)method.invoke((Object)field, entity);
            }
        }
        catch (Exception method2) {
            // empty catch block
        }
        try {
            method = field.getClass().getMethod("isAccessible", new Class[0]);
            if (method != null) {
                return (Boolean)method.invoke((Object)field, entity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected Class<?> getClassForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    String getValidMethod(String methodName) {
        String name = null;
        if (!badProperties.contains(methodName)) {
            if (methodName.startsWith("get")) {
                name = methodName.substring(3);
            } else if (methodName.startsWith("is")) {
                name = methodName.substring(2);
            }
            if (name == null || "".equals(name.trim())) {
                return null;
            }
        }
        return name;
    }

    public static GenericCreator create(IdMap map, String className) {
        try {
            return GenericCreator.create(map, Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static GenericCreator create(IdMap map, Class<?> instance) {
        Field[] fields;
        Type type;
        ParameterizedType genericSuperclass;
        Type types2;
        Class<?> child;
        Method[] methods;
        SendableEntityCreator creator = map.getCreator(instance.getName(), true, null);
        if (creator != null) {
            return (GenericCreator)creator;
        }
        GenericCreator genericCreator = new GenericCreator();
        try {
            if (!instance.isInterface()) {
                genericCreator.withItem(ReflectionLoader.newInstance(instance, new Object[0]));
            }
        }
        catch (Exception e1) {
            genericCreator.withClass(instance);
        }
        map.add(genericCreator);
        for (Method method : methods = instance.getMethods()) {
            String methodName = method.getName();
            if (genericCreator.getValidMethod(methodName) == null || EntityUtil.isPrimitiveType((child = method.getReturnType()).getName())) continue;
            try {
                types2 = child.getGenericSuperclass();
                if (types2 != null && types2 instanceof ParameterizedType && (genericSuperclass = (ParameterizedType)types2).getActualTypeArguments().length > 0) {
                    type = genericSuperclass.getActualTypeArguments()[0];
                    String typeClass = "" + ReflectionLoader.call("getTypeName", type, new Object[0]);
                    if (typeClass.length() > 0) {
                        child = Class.forName(typeClass);
                    }
                }
            }
            catch (ReflectiveOperationException types2) {
                // empty catch block
            }
            if (child.isInterface() || child instanceof Class) continue;
            GenericCreator.create(map, child);
        }
        for (Field field : fields = instance.getDeclaredFields()) {
            Object childClass;
            child = field.getType();
            if (EntityUtil.isPrimitiveType(child.getName())) continue;
            types2 = field.getGenericType();
            if (types2 != null && types2 instanceof ParameterizedType && (genericSuperclass = (ParameterizedType)types2).getActualTypeArguments().length > 0 && (childClass = ReflectionLoader.call("getTypeName", type = genericSuperclass.getActualTypeArguments()[0], new Object[0])) != null) {
                child = ReflectionLoader.getClass("" + childClass);
            }
            GenericCreator.create(map, child);
        }
        return genericCreator;
    }
}

