/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext;

import de.uniks.networkparser.DateTimeEntity;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.ext.Os;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.javafx.SimpleController;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.list.SimpleList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;

public class ErrorHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TYPE = "ERROR";
    private String path;
    private Object stage;
    private DateTimeEntity startDate = new DateTimeEntity();
    private SimpleList<ObjectCondition> list = new SimpleList();

    public String getIP() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getMac() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            return sb.toString();
        }
        catch (SocketException socketException) {
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public boolean saveErrorFile(String prefix, String fileName, String filePath, Throwable e) {
        boolean success;
        try {
            File file = this.getFileName(filePath, prefix, fileName);
            if (file == null) {
                return false;
            }
            FileOutputStream networkFile = new FileOutputStream(file);
            PrintStream ps = new PrintStream(networkFile);
            ps.println("Error: " + e.getMessage());
            ps.println("Start: " + this.getJVMStartUp().toString("dd.mm.yyyy HH:MM:SS"));
            ps.println("Startdate: " + this.startDate.toString("dd.mm.yyyy HH:MM:SS"));
            ps.println("Date: " + new DateTimeEntity().toString("dd.mm.yyyy HH:MM:SS"));
            ps.println("Thread: " + Thread.currentThread().getName());
            ps.println("PID: " + this.getPID());
            ps.println("Version: " + SimpleController.getVersion());
            ps.println("IP: " + this.getIP());
            ps.println("MAC: " + this.getMac());
            ps.println("------------ SYSTEM-INFO ------------");
            ErrorHandler.printProperty(ps, "java.class.version");
            ErrorHandler.printProperty(ps, "java.runtime.version");
            ErrorHandler.printProperty(ps, "java.specification.version");
            ErrorHandler.printProperty(ps, "java.version");
            ErrorHandler.printProperty(ps, "java.home");
            ErrorHandler.printProperty(ps, "os.arch");
            ErrorHandler.printProperty(ps, "os.name");
            ErrorHandler.printProperty(ps, "os.version");
            ErrorHandler.printProperty(ps, "user.dir");
            ErrorHandler.printProperty(ps, "user.home");
            ErrorHandler.printProperty(ps, "user.language");
            ErrorHandler.printProperty(ps, "user.name");
            ErrorHandler.printProperty(ps, "user.timezone");
            ps.println("");
            Runtime r = Runtime.getRuntime();
            ps.println("Prozessoren :       " + r.availableProcessors());
            ps.println("Freier Speicher JVM:    " + r.freeMemory());
            ps.println("Maximaler Speicher JVM: " + r.maxMemory());
            ps.println("Gesamter Speicher JVM:  " + r.totalMemory());
            ps.println();
            ErrorHandler.printSubTrace(ps, "", 1, e);
            ps.close();
            if ("Java heap space".equals(e.getMessage())) {
                this.saveHeapSpace(prefix);
            }
            success = true;
        }
        catch (FileNotFoundException exception) {
            success = false;
        }
        catch (IOException exception) {
            success = false;
        }
        return success;
    }

    public boolean saveHeapSpace(String prefix) {
        String filepath = ErrorHandler.createDir(this.path);
        if (filepath == null) {
            return false;
        }
        if (filepath.length() > 0 && !filepath.endsWith("/")) {
            filepath = filepath + "/";
        }
        String fullfilename = filepath + prefix + "heap.bin";
        SimpleList commandList = new SimpleList();
        commandList.with("jmap", "-dump:live,format=b,file=" + fullfilename, "" + this.getPID());
        String[] list = commandList.toArray(new String[commandList.size()]);
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        try {
            Process process = processBuilder.start();
            process.waitFor();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public DateTimeEntity getJVMStartUp() {
        Object returnValue;
        DateTimeEntity item = new DateTimeEntity();
        if (ReflectionLoader.MANAGEMENTFACTORY == null) {
            return item;
        }
        Object runTime = ReflectionLoader.call("getRuntimeMXBean", ReflectionLoader.MANAGEMENTFACTORY, new Object[0]);
        if (runTime != null && (returnValue = ReflectionLoader.getField("vmStartupTime", runTime)) instanceof Long) {
            item.withTime((Long)returnValue);
        }
        return item;
    }

    public int getPID() {
        Object returnValue;
        int pid = -1;
        if (ReflectionLoader.MANAGEMENTFACTORY == null) {
            return pid;
        }
        Object runTime = ReflectionLoader.call("getRuntimeMXBean", ReflectionLoader.MANAGEMENTFACTORY, new Object[0]);
        if (runTime == null) {
            return pid;
        }
        Object jvm = ReflectionLoader.getField("jvm", runTime);
        if (jvm != null && (returnValue = ReflectionLoader.call("getProcessId", jvm, new Object[0])) instanceof Integer) {
            pid = (Integer)returnValue;
        }
        return pid;
    }

    public static void printProperty(PrintStream ps, String property) {
        ps.println(property + ": " + System.getProperty(property));
    }

    public static void printSubTrace(PrintStream ps, String prefix, int index, Throwable e) {
        if (prefix == null) {
            return;
        }
        if (prefix.length() > 0) {
            prefix = prefix + ":" + index;
            ps.println(prefix);
        } else {
            prefix = "Sub";
        }
        e.printStackTrace(ps);
        Throwable[] suppressed = e.getSuppressed();
        if (suppressed != null) {
            for (int number = 0; number < suppressed.length; ++number) {
                ErrorHandler.printSubTrace(ps, prefix, number, suppressed[number]);
            }
        }
    }

    public static String createDir(String path) {
        if (path == null) {
            return "";
        }
        File dirPath = new File(path);
        if (!(dirPath = new File(dirPath.getPath())).exists()) {
            if (dirPath.mkdirs()) {
                return path;
            }
        } else {
            return path;
        }
        return null;
    }

    public ErrorHandler withPath(String value) {
        this.path = value;
        return this;
    }

    public File getFileName(String filepath, String prefix, String fileName) throws IOException {
        if (filepath == null) {
            return null;
        }
        if (fileName == null) {
            return null;
        }
        if ((filepath = ErrorHandler.createDir(filepath)) == null) {
            return null;
        }
        if (filepath.length() > 0 && !filepath.endsWith("/")) {
            filepath = filepath + "/";
        }
        String fullfilename = null;
        fullfilename = prefix != null ? filepath + prefix + fileName : filepath + fileName;
        File file = new File(fullfilename);
        if (!file.exists() && !file.createNewFile()) {
            return null;
        }
        return file;
    }

    public Exception saveScreenShoot(String prefix, String fileName, String filePath, Object currentStage) {
        if (currentStage == null) {
            currentStage = this.stage;
        }
        try {
            File target = this.getFileName(filePath, prefix, fileName);
            if (target == null) {
                return null;
            }
            Object rect = ReflectionLoader.newInstance(ReflectionLoader.RECTANGLE, ReflectionLoader.DIMENSION, ReflectionLoader.callChain(ReflectionLoader.TOOLKIT, "getDefaultToolkit", "getScreenSize"));
            this.writeScreen(target, rect);
            if (currentStage != null) {
                Double x = (Double)ReflectionLoader.call("getX", currentStage, new Object[0]);
                Double y = (Double)ReflectionLoader.call("getY", currentStage, new Object[0]);
                Double width = (Double)ReflectionLoader.call("getWidth", currentStage, new Object[0]);
                Double height = (Double)ReflectionLoader.call("getHeight", currentStage, new Object[0]);
                String windowName = currentStage.getClass().getSimpleName();
                target = this.getFileName(filePath, prefix + windowName, fileName);
                rect = ReflectionLoader.newInstance(ReflectionLoader.RECTANGLE, Integer.TYPE, x.intValue(), Integer.TYPE, y.intValue(), Integer.TYPE, width.intValue(), Integer.TYPE, height.intValue());
                this.writeScreen(target, rect);
            }
        }
        catch (Exception e1) {
            return e1;
        }
        return null;
    }

    private boolean writeScreen(File file, Object rectangle) {
        Object robot = ReflectionLoader.newInstance(ReflectionLoader.ROBOT, new Object[0]);
        Object bi = ReflectionLoader.call("createScreenCapture", robot, ReflectionLoader.RECTANGLE, rectangle);
        Boolean result = (Boolean)ReflectionLoader.call("write", ReflectionLoader.IMAGEIO, ReflectionLoader.RENDEREDIMAGE, bi, String.class, "jpg", File.class, file);
        return result;
    }

    public void saveException(Throwable e) {
        this.saveException(e, this.stage, true);
    }

    public void saveException(Throwable e, boolean throwException) {
        this.saveException(e, this.stage, throwException);
    }

    public boolean writeOutput(String output, boolean error) {
        String fullFileName = "";
        if (this.path != null && (fullFileName = this.path).length() > 0 && !fullFileName.endsWith("/")) {
            fullFileName = fullFileName + "/";
        }
        ErrorHandler.createDir(this.path);
        File file = error ? new File(fullFileName + "error.txt") : new File(fullFileName + "output.txt");
        try {
            if (!file.exists() && !file.createNewFile()) {
                return false;
            }
            FileOutputStream stream = new FileOutputStream(file, true);
            stream.write(output.getBytes());
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.saveException(e, this.stage, true);
    }

    public String getPrefix() {
        return new DateTimeEntity().toString("yyyymmdd_HHMMSS_");
    }

    public void saveException(Throwable e, Object stage, boolean throwException) {
        String prefixName = this.getPrefix();
        this.saveErrorFile(prefixName, "error.txt", this.path, e);
        this.saveScreenShoot(prefixName, "Full.jpg", this.path, stage);
        if (this.list.size() > 0) {
            SimpleEvent event = new SimpleEvent(this, prefixName, null, e);
            event.withType(TYPE);
            for (ObjectCondition child : this.list) {
                child.update(event);
            }
        }
        if (Os.isEclipse()) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Object getStage() {
        return this.stage;
    }

    public ErrorHandler withStage(Object value) {
        this.stage = value;
        return this;
    }

    public void addListener(ObjectCondition world) {
        this.list.add(world);
    }

    public String getPath() {
        return this.path;
    }
}

